/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.swing;

import java.awt.Point;
import java.util.Iterator;
import java.util.logging.Level;
import org.w3c.dom.Element;
import org.xhtmlrenderer.layout.BlockFormattingContext;
import org.xhtmlrenderer.layout.Layer;
import org.xhtmlrenderer.layout.SharedContext;
import org.xhtmlrenderer.render.Box;
import org.xhtmlrenderer.render.InlineBox;
import org.xhtmlrenderer.render.LineBox;
import org.xhtmlrenderer.swing.BasicPanel;
import org.xhtmlrenderer.util.XRLog;

public class BoxFinder {
    private static Element findElementByBox(Box box) {
        return null;
    }

    private static Box findBoxByID(String id, SharedContext ctx) {
        return ctx.getIDBox(id);
    }

    private static Element findElementByID(String id, SharedContext ctx) {
        Box bx = BoxFinder.findBoxByID(id, ctx);
        return BoxFinder.findElementByBox(bx);
    }

    private static Point findCoordsByBox(Box box) {
        if (box.getParent() != null) {
            Point pt = BoxFinder.findCoordsByBox(box.getParent());
            pt.translate(box.x, box.y);
            return pt;
        }
        return new Point(0, 0);
    }

    private static Box findBox(Layer layer, int x, int y) {
        if (layer == null) {
            return null;
        }
        Iterator i = layer.getChildren().iterator();
        while (i.hasNext()) {
            Layer child = (Layer)i.next();
            Box result = BoxFinder.findDeepestChild(child.getMaster(), x, y);
            if (result == null) continue;
            return result;
        }
        return BoxFinder.findDeepestChild(layer.getMaster(), x, y);
    }

    private static Box findDeepestChild(Box container, int x, int y) {
        if (container == null) {
            return null;
        }
        int dx = container.x + container.tx;
        int ttx = x - dx + container.tx;
        int dy = container.y + container.ty;
        int tty = y - dy + container.ty;
        if (!container.contains(ttx, tty)) {
            return null;
        }
        Iterator i = container.getChildIterator();
        while (i.hasNext()) {
            Box bx = (Box)i.next();
            Box retbox = BoxFinder.findDeepestChild(bx, x - dx, y - dy);
            if (retbox == null) continue;
            return retbox;
        }
        if (container.contains(ttx, tty)) {
            return container;
        }
        return null;
    }

    private static int[] adjustForAbsolute(Box bx, int tx, int ty, BlockFormattingContext bfc) {
        return new int[]{0, 0};
    }

    private static int findBoxX(BasicPanel panel, int x, int y) {
        return BoxFinder.findBoxX(panel.getRootBox(), x, y);
    }

    private static int findBoxX(Box box, int x, int y) {
        XRLog.layout(Level.FINEST, "findBox(" + box + " at (" + x + "," + y + ")");
        Iterator it = box.getChildIterator();
        while (it.hasNext()) {
            Box bx = (Box)it.next();
            int tx = x;
            int ty = y;
            int retbox = BoxFinder.findBoxX(bx, tx -= bx.x, ty -= bx.y);
            if (retbox != -1) {
                return retbox;
            }
            int tty = y;
            if (bx instanceof InlineBox) {
                InlineBox ibx = (InlineBox)bx;
                LineBox lbx = (LineBox)box;
                XRLog.layout(Level.FINEST, "inline = " + ibx);
                XRLog.layout(Level.FINEST, "inline y = " + ibx.y);
                XRLog.layout(Level.FINEST, "inline height = " + ibx.height);
                XRLog.layout(Level.FINEST, "line = " + lbx);
                int off = 0;
                XRLog.layout(Level.FINEST, "off = " + off);
                tty -= off;
            }
            XRLog.layout(Level.FINEST, "bx test = " + bx + " " + x + "," + y);
            if (!bx.contains(x - bx.x, tty - bx.y)) continue;
            return x - bx.x;
        }
        return -1;
    }
}

