/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.swing;

import java.awt.Dimension;
import org.xhtmlrenderer.render.ReflowEvent;
import org.xhtmlrenderer.swing.RootPanel;
import org.xhtmlrenderer.util.Configuration;
import org.xhtmlrenderer.util.Uu;

public class RenderLoop
implements Runnable {
    private RootPanel root;

    public RenderLoop(RootPanel root) {
        this.root = root;
    }

    public void run() {
        Uu.p("repaint thread starting");
        this.startRepaintLoop();
    }

    public void startRepaintLoop() {
        ReflowEvent evt;
        while ((evt = this.root.queue.waitForNextRepaintEvent()) != null) {
            if ((evt = this.root.queue.collapseRepaintEvents(evt)).getType() == ReflowEvent.LAYOUT_COMPLETE) {
                this.root.repaint();
                continue;
            }
            if (!this.root.isPrintView() && Configuration.isTrue("xr.incremental.enabled", false)) {
                if (evt.getType() == ReflowEvent.MORE_BOXES_AVAILABLE) {
                    Dimension dim = evt.getDimension();
                    Dimension vpdim = null;
                    vpdim = this.root.enclosingScrollPane == null ? new Dimension(10000, 10000) : this.root.enclosingScrollPane.getViewport().getSize();
                    if (dim.getHeight() > (double)this.root.getHeight()) {
                        this.root.setPreferredSize(new Dimension((int)vpdim.getWidth(), (int)dim.getHeight()));
                        this.root.revalidate();
                    }
                }
                this.root.repaint();
            } else {
                Uu.p("not doing incremental for event: " + evt);
            }
            this.root.last_event = evt;
        }
        return;
    }
}

