/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.table;

import java.awt.Rectangle;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.xhtmlrenderer.css.constants.CSSName;
import org.xhtmlrenderer.css.constants.IdentValue;
import org.xhtmlrenderer.css.newmatch.CascadedStyle;
import org.xhtmlrenderer.css.style.CalculatedStyle;
import org.xhtmlrenderer.css.style.derived.BorderPropertySet;
import org.xhtmlrenderer.css.style.derived.RectPropertySet;
import org.xhtmlrenderer.extend.ReplacedElement;
import org.xhtmlrenderer.layout.BlockFormattingContext;
import org.xhtmlrenderer.layout.Boxing;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.layout.VerticalMarginCollapser;
import org.xhtmlrenderer.layout.content.Content;
import org.xhtmlrenderer.layout.content.TableCellContent;
import org.xhtmlrenderer.layout.content.TableContent;
import org.xhtmlrenderer.layout.content.TableRowContent;
import org.xhtmlrenderer.render.BlockBox;
import org.xhtmlrenderer.render.Box;
import org.xhtmlrenderer.render.Style;
import org.xhtmlrenderer.swing.SwingReplacedElement;
import org.xhtmlrenderer.table.CellBox;
import org.xhtmlrenderer.table.RowBox;
import org.xhtmlrenderer.table.TableBox;
import org.xhtmlrenderer.util.XRLog;

public class TableBoxing {
    public static BlockBox createBox(LayoutContext c, Content content) {
        if (!(content instanceof TableContent)) {
            XRLog.layout(Level.WARNING, "Unsupported table type " + content.getClass().getName());
            return null;
        }
        BlockBox outerBox = new BlockBox();
        return outerBox;
    }

    public static Box layout(LayoutContext c, BlockBox outerBox, Content content, Boxing.StyleSetListener listener) {
        boolean set_bfc = false;
        c.setLayingOutTable(true);
        if (!(content instanceof TableContent)) {
            XRLog.layout(Level.WARNING, "Unsupported table type " + content.getClass().getName());
            return null;
        }
        if (c.getBlockFormattingContext() == null) {
            BlockFormattingContext bfc = new BlockFormattingContext(outerBox, c);
            c.pushBFC(bfc);
            set_bfc = true;
        }
        Rectangle oe = c.getExtents();
        c.setExtents(new Rectangle(oe));
        outerBox.contentWidth = c.getExtents().width;
        outerBox.height = c.getExtents().height;
        outerBox.createDefaultStyle(c);
        TableBox tableBox = new TableBox();
        outerBox.addChild(c, tableBox);
        tableBox.element = content.getElement();
        CascadedStyle pushed = content.getStyle();
        if (pushed != null) {
            c.pushStyle(pushed);
        } else {
            c.pushStyle(CascadedStyle.emptyCascadedStyle);
        }
        tableBox.setStyle(new Style(c.getCurrentStyle(), (int)oe.getWidth()));
        if (listener != null) {
            listener.onStyleSet(tableBox);
        }
        VerticalMarginCollapser.collapseVerticalMargins(c, tableBox, content, (float)oe.getWidth());
        TableContent tableContent = (TableContent)content;
        if (tableContent.isTopMarginCollapsed()) {
            tableBox.getStyle().setMarginTopOverride(0.0f);
        }
        if (tableContent.isBottomMarginCollapsed()) {
            tableBox.getStyle().setMarginBottomOverride(0.0f);
        }
        tableBox.setStyle(new Style(c.getCurrentStyle(), (int)oe.getWidth()));
        BorderPropertySet border = c.getCurrentStyle().getBorder(c);
        RectPropertySet margin = tableBox.getStyle().getMarginWidth(c);
        RectPropertySet padding = c.getCurrentStyle().getPaddingRect((float)oe.getWidth(), (float)oe.getWidth(), c);
        int tx = (int)margin.left() + (int)border.left() + (int)padding.left();
        int ty = (int)margin.top() + (int)border.top() + (int)padding.top();
        tableBox.tx = tx;
        tableBox.ty = ty;
        c.translate(tx, ty);
        Rectangle extents = c.shrinkExtents(tx + (int)margin.right() + (int)border.right() + (int)padding.right(), ty + (int)margin.bottom() + (int)border.bottom() + (int)padding.bottom());
        IdentValue borderStyle = c.getCurrentStyle().getIdent(CSSName.BORDER_COLLAPSE);
        int borderSpacingHorizontal = (int)c.getCurrentStyle().getFloatPropertyProportionalWidth(CSSName.FS_BORDER_SPACING_HORIZONTAL, 0.0f, c);
        int borderSpacingVertical = (int)c.getCurrentStyle().getFloatPropertyProportionalWidth(CSSName.FS_BORDER_SPACING_VERTICAL, 0.0f, c);
        TableBoxing.layoutChildren(c, tableBox, content, false, borderSpacingHorizontal, borderSpacingVertical);
        if (c.shouldStop()) {
            return outerBox;
        }
        c.setExtents(extents);
        c.translate(-tx, -ty);
        if (c.getCurrentStyle().isIdent(CSSName.WIDTH, IdentValue.AUTO)) {
            TableBoxing.fixWidths(tableBox, borderSpacingHorizontal);
        } else {
            int givenWidth = (int)c.getCurrentStyle().getFloatPropertyProportionalWidth(CSSName.WIDTH, c.getExtents().width, c);
            if (tableBox.contentWidth < givenWidth) {
                tableBox.contentWidth = givenWidth;
                TableBoxing.fixWidths(tableBox, borderSpacingHorizontal);
            } else {
                c.getExtents().width = 1;
                c.translate(tx, ty);
                int[] preferredColumns = tableBox.columns;
                tableBox.columns = null;
                tableBox.removeAllChildren();
                tableBox.contentWidth = 0;
                tableBox.height = 0;
                TableBoxing.layoutChildren(c, tableBox, content, false, borderSpacingHorizontal, borderSpacingVertical);
                c.translate(-tx, -ty);
                if (tableBox.contentWidth < givenWidth) {
                    tableBox.contentWidth = givenWidth;
                    tableBox.removeAllChildren();
                    TableBoxing.fixWidths(tableBox, borderSpacingHorizontal, preferredColumns);
                    c.translate(tx, ty);
                    tableBox.contentWidth = 0;
                    tableBox.height = 0;
                    TableBoxing.layoutChildren(c, tableBox, content, true, borderSpacingHorizontal, borderSpacingVertical);
                    c.translate(-tx, -ty);
                }
            }
        }
        TableBoxing.fixHeights(tableBox, borderSpacingVertical);
        TableBoxing.alignCellLines(tableBox);
        tableBox.leftMBP = (int)border.left() + (int)padding.left();
        tableBox.leftMBP += (int)margin.left();
        tableBox.rightMBP = (int)border.right() + (int)padding.right();
        tableBox.rightMBP += (int)margin.right();
        tableBox.height = (int)margin.top() + (int)border.top() + (int)padding.top() + tableBox.height + (int)padding.bottom() + (int)border.bottom() + (int)margin.bottom();
        c.popStyle();
        c.setExtents(oe);
        if (set_bfc) {
            c.popBFC();
        }
        TableBoxing.calculateOuterBoxDimensions(outerBox);
        tableBox.setState(3);
        outerBox.setState(3);
        outerBox.calcCanvasLocation();
        outerBox.calcChildLocations();
        c.setLayingOutTable(false);
        if (c.isPrint()) {
            TableBoxing.positionRowsOnPage(c, tableBox);
            TableBoxing.calculateOuterBoxDimensions(outerBox);
            outerBox.calcChildLocations();
        }
        return outerBox;
    }

    private static void calculateOuterBoxDimensions(BlockBox outerBox) {
        if (outerBox.getChildCount() > 0) {
            Box table = outerBox.getChild(0);
            outerBox.height = table.height;
            outerBox.contentWidth = table.contentWidth;
        }
    }

    private static void positionRowsOnPage(LayoutContext c, TableBox table) {
        int lastMoved = -1;
        for (int i = 0; i < table.getChildCount(); ++i) {
            RowBox row = (RowBox)table.getChild(i);
            if (!row.crossesPageBreak(c) || i == lastMoved) continue;
            int runStart = TableBoxing.findStartOfRun(c, table, i);
            RowBox start = (RowBox)table.getChild(runStart);
            int delta = start.moveToNextPage(c);
            table.height += delta;
            for (int j = runStart + 1; j < table.getChildCount(); ++j) {
                RowBox followingSibling = (RowBox)table.getChild(j);
                followingSibling.y += delta;
                followingSibling.setAbsY(followingSibling.getAbsY() + delta);
            }
            i = runStart;
            lastMoved = runStart;
        }
    }

    private static int findStartOfRun(LayoutContext c, TableBox table, int end) {
        if (end > 0) {
            for (int offset = end; offset > 0; --offset) {
                RowBox previous = (RowBox)table.getChild(offset - 1);
                RowBox current = (RowBox)table.getChild(offset);
                IdentValue after = previous.getStyle().getCalculatedStyle().getIdent(CSSName.PAGE_BREAK_AFTER);
                IdentValue before = current.getStyle().getCalculatedStyle().getIdent(CSSName.PAGE_BREAK_BEFORE);
                if (after == IdentValue.AVOID && before == IdentValue.AUTO || after == IdentValue.AUTO && before == IdentValue.AVOID || after == IdentValue.AVOID && before == IdentValue.AVOID) {
                    continue;
                }
                return offset;
            }
            return 0;
        }
        return 0;
    }

    private static void alignCellLines(TableBox box) {
        for (int i = 0; i < box.getChildCount(); ++i) {
            RowBox row = (RowBox)box.getChild(i);
            for (int j = 0; j < row.getChildCount(); ++j) {
                CellBox cell = (CellBox)row.getChild(j);
                cell.alignLines();
            }
        }
    }

    private static void fixWidths(TableBox tableBox, int borderSpacingHorizontal) {
        if (tableBox != null && tableBox.columns != null) {
            int sum = borderSpacingHorizontal;
            for (int i = 0; i < tableBox.columns.length; ++i) {
                sum += tableBox.columns[i] + borderSpacingHorizontal;
            }
            if (sum < tableBox.contentWidth) {
                int extra = (tableBox.contentWidth - sum) / tableBox.columns.length;
                int i = 0;
                while (i < tableBox.columns.length) {
                    int n = i++;
                    tableBox.columns[n] = tableBox.columns[n] + extra;
                }
            } else {
                tableBox.contentWidth = sum;
            }
            Iterator tci = tableBox.getChildIterator();
            while (tci.hasNext()) {
                Object tc = tci.next();
                if (tc instanceof RowBox) {
                    RowBox row = (RowBox)tc;
                    int col = 0;
                    int x = borderSpacingHorizontal;
                    Iterator cbi = row.getChildIterator();
                    while (cbi.hasNext()) {
                        while (col < tableBox.columnRows.length && tableBox.columnRows[col] != 0) {
                            x += borderSpacingHorizontal + tableBox.columns[col];
                            ++col;
                        }
                        CellBox cb = (CellBox)cbi.next();
                        cb.contentWidth = 0;
                        for (int i = 0; i < cb.colspan && col + i < tableBox.columns.length; ++i) {
                            cb.contentWidth += tableBox.columns[col + i];
                        }
                        cb.contentWidth += borderSpacingHorizontal * (cb.colspan - 1);
                        cb.contentWidth -= cb.leftMBP + cb.rightMBP;
                        cb.x = x;
                        x += cb.getWidth() + borderSpacingHorizontal;
                        for (int j = 0; j < cb.colspan && col + j < tableBox.columns.length; ++j) {
                            tableBox.columnRows[col + j] = cb.rowspan;
                        }
                        col += cb.colspan;
                    }
                    int j = 0;
                    while (j < tableBox.columns.length) {
                        int n = j++;
                        tableBox.columnRows[n] = tableBox.columnRows[n] - 1;
                    }
                    continue;
                }
                XRLog.layout(Level.WARNING, "Can't fix widths of " + tc.getClass().getName() + " yet!");
            }
        }
    }

    private static void fixHeights(TableBox tableBox, int borderSpacingVertical) {
        tableBox.height += borderSpacingVertical;
        Iterator tci = tableBox.getChildIterator();
        while (tci.hasNext()) {
            Object tc = tci.next();
            if (tc instanceof RowBox) {
                RowBox row = (RowBox)tc;
                int col = 0;
                Iterator cbi = row.getChildIterator();
                while (cbi.hasNext()) {
                    while (col < tableBox.columnRows.length && tableBox.columnRows[col] != 0) {
                        if (tableBox.columnCell != null && tableBox.columnCell[col] != null) {
                            tableBox.columnCell[col].height += borderSpacingVertical + row.height;
                        }
                        ++col;
                    }
                    CellBox cb = (CellBox)cbi.next();
                    for (int j = 0; j < cb.colspan && col + j < tableBox.columnRows.length; ++j) {
                        tableBox.columnRows[col + j] = cb.rowspan;
                        tableBox.columnCell[col + j] = j == 0 ? cb : null;
                    }
                    cb.height = row.height;
                    col += cb.colspan;
                }
                while (col < tableBox.columnRows.length && tableBox.columnRows[col] != 0) {
                    if (tableBox.columnCell != null && tableBox.columnCell[col] != null) {
                        tableBox.columnCell[col].height += borderSpacingVertical + row.height;
                    }
                    ++col;
                }
                int j = 0;
                while (j < tableBox.columns.length) {
                    int n = j++;
                    tableBox.columnRows[n] = tableBox.columnRows[n] - 1;
                }
                continue;
            }
            XRLog.layout(Level.WARNING, "Can't fix widths of " + tc.getClass().getName() + " yet!");
        }
    }

    private static void fixWidths(TableBox tableBox, int borderSpacingHorizontal, int[] preferredColumns) {
        int min = borderSpacingHorizontal;
        int wantMore = 0;
        for (int i = 0; i < tableBox.columns.length; ++i) {
            min += tableBox.columns[i] + borderSpacingHorizontal;
            if (tableBox.columns[i] >= preferredColumns[i]) continue;
            ++wantMore;
        }
        if (min < tableBox.contentWidth) {
            int added;
            int wanted;
            int i;
            int extra = (tableBox.contentWidth - min) / wantMore;
            for (i = 0; i < tableBox.columns.length; ++i) {
                wanted = preferredColumns[i] - tableBox.columns[i];
                if (wanted <= 0) continue;
                added = Math.min(extra, wanted);
                int n = i;
                tableBox.columns[n] = tableBox.columns[n] + added;
                min += added;
            }
            for (i = 0; i < tableBox.columns.length; ++i) {
                wanted = preferredColumns[i] - tableBox.columns[i];
                if (wanted <= 0) continue;
                added = Math.min(tableBox.contentWidth - min, wanted);
                int n = i;
                tableBox.columns[n] = tableBox.columns[n] + added;
                min += added;
            }
        } else {
            tableBox.contentWidth = min;
        }
    }

    private static void layoutChildren(LayoutContext c, TableBox tableBox, Content content, boolean fixed, int borderSpacingHorizontal, int borderSpacingVertical) {
        Iterator contentIterator = content.getChildContent(c).iterator();
        while (contentIterator.hasNext() && !c.shouldStop()) {
            Object o = contentIterator.next();
            if (o instanceof TableRowContent) {
                c.translate(0, tableBox.height);
                RowBox row = TableBoxing.layoutRow(c, (TableRowContent)o, tableBox, fixed, borderSpacingHorizontal, borderSpacingVertical);
                c.translate(0, -tableBox.height);
                tableBox.addChild(c, row);
                row.setParent(tableBox);
                row.element = ((TableRowContent)o).getElement();
                row.x = 0;
                row.y = tableBox.height + borderSpacingVertical;
                tableBox.height = row.y + row.height;
                continue;
            }
            XRLog.layout(Level.WARNING, "Unsupported inside table: " + o.getClass().getName());
        }
    }

    private static RowBox layoutRow(LayoutContext c, TableRowContent tableRowContent, TableBox table, boolean fixed, int borderSpacingHorizontal, int borderSpacingVertical) {
        Rectangle oe = c.getExtents();
        c.setExtents(new Rectangle(oe));
        RowBox row = new RowBox();
        row.setContainingBlock(table);
        CascadedStyle pushed = tableRowContent.getStyle();
        if (pushed != null) {
            c.pushStyle(pushed);
        } else {
            c.pushStyle(CascadedStyle.emptyCascadedStyle);
        }
        row.setStyle(new Style(c.getCurrentStyle(), (int)oe.getWidth()));
        BorderPropertySet border = c.getCurrentStyle().getBorder(c);
        row.leftMBP = (int)border.left();
        row.rightMBP = (int)border.right();
        int tx = (int)border.left();
        int ty = (int)border.top();
        row.tx = tx;
        row.ty = ty;
        c.translate(tx, ty);
        Rectangle extents = c.shrinkExtents(tx + (int)border.right(), ty + (int)border.bottom());
        List cells = tableRowContent.getChildContent(c);
        TableBoxing.checkColumns(table, cells.size());
        TableBoxing.layoutCells(cells, c, row, table, fixed, borderSpacingHorizontal, borderSpacingVertical);
        c.setExtents(extents);
        c.translate(-tx, -ty);
        row.contentWidth += borderSpacingHorizontal;
        row.height = (int)border.top() + row.height + (int)border.bottom();
        c.popStyle();
        c.setExtents(oe);
        row.setState(3);
        row.setContainingBlock(null);
        return row;
    }

    private static void layoutCells(List cells, LayoutContext c, RowBox row, TableBox table, boolean fixed, int borderSpacingHorizontal, int borderSpacingVertical) {
        int j;
        int col = 0;
        Iterator i = cells.iterator();
        while (i.hasNext() && !c.shouldStop()) {
            int j2;
            TableBoxing.checkColumns(table, col + 1);
            while (table.columnRows[col] != 0) {
                row.contentWidth += borderSpacingHorizontal + table.columns[col];
                table.columnCell[col] = null;
                ++col;
            }
            TableCellContent tcc = (TableCellContent)i.next();
            CellBox cellBox = new CellBox();
            cellBox.setContainingBlock(row);
            cellBox.setContainingLayer(c.getLayer());
            c.translate(row.contentWidth, 0);
            c.setShrinkWrap();
            cellBox = TableBoxing.layoutCell(c, cellBox, tcc, fixed, table, col);
            c.unsetShrinkWrap();
            c.translate(-row.contentWidth, 0);
            cellBox.setContainingBlock(null);
            cellBox.setParent(row);
            cellBox.element = tcc.getElement();
            cellBox.x = row.contentWidth + borderSpacingHorizontal;
            TableBoxing.checkColumns(table, col + cellBox.colspan);
            for (int j3 = 0; j3 < cellBox.colspan; ++j3) {
                table.columnRows[col + j3] = cellBox.rowspan;
                table.columnHeight[col + j3] = cellBox.height;
                table.columnCell[col + j3] = null;
            }
            table.columnCell[col] = cellBox;
            int width = 0;
            for (j2 = 0; j2 < cellBox.colspan; ++j2) {
                width += table.columns[col + j2];
            }
            if (!fixed && cellBox.getWidth() > (width += borderSpacingHorizontal * (cellBox.colspan - 1))) {
                int extra = (cellBox.getWidth() - width) / cellBox.colspan;
                for (int j4 = 0; j4 < cellBox.colspan; ++j4) {
                    int n = col + j4;
                    table.columns[n] = table.columns[n] + extra;
                }
            }
            cellBox.contentWidth = 0;
            for (j2 = 0; j2 < cellBox.colspan; ++j2) {
                cellBox.contentWidth += table.columns[col + j2];
            }
            cellBox.contentWidth += (cellBox.colspan - 1) * borderSpacingHorizontal;
            cellBox.contentWidth -= cellBox.leftMBP + cellBox.rightMBP;
            row.contentWidth = cellBox.x + cellBox.getWidth();
            col += cellBox.colspan;
            cellBox.height = 0;
            row.addChild(c, cellBox);
        }
        for (j = 0; j < table.columns.length; ++j) {
            if (table.columnRows[j] == 0) continue;
            int height = table.columnHeight[j] / table.columnRows[j];
            if (height > row.height) {
                row.height = height;
            }
            int n = j;
            table.columnHeight[n] = table.columnHeight[n] - height;
            int n2 = j;
            table.columnRows[n2] = table.columnRows[n2] - 1;
        }
        for (j = 0; j < table.columns.length; ++j) {
            if (table.columnCell[j] == null) continue;
            table.columnCell[j].height += row.height;
            if (table.columnRows[j] == 0) continue;
            table.columnCell[j].height += borderSpacingVertical;
        }
    }

    private static void checkColumns(TableBox table, int cols) {
        int i;
        if (table.columns == null) {
            table.columns = new int[cols];
        } else if (table.columns.length < cols) {
            int[] newColumns = new int[cols];
            for (i = 0; i < table.columns.length; ++i) {
                newColumns[i] = table.columns[i];
            }
            table.columns = newColumns;
        }
        if (table.columnRows == null) {
            table.columnRows = new int[cols];
        } else if (table.columnRows.length < cols) {
            int[] newColumnRows = new int[cols];
            for (i = 0; i < table.columnRows.length; ++i) {
                newColumnRows[i] = table.columnRows[i];
            }
            table.columnRows = newColumnRows;
        }
        if (table.columnHeight == null) {
            table.columnHeight = new int[cols];
        } else if (table.columnHeight.length < cols) {
            int[] newColumnHeight = new int[cols];
            for (i = 0; i < table.columnHeight.length; ++i) {
                newColumnHeight[i] = table.columnHeight[i];
            }
            table.columnHeight = newColumnHeight;
        }
        if (table.columnCell == null) {
            table.columnCell = new CellBox[cols];
        } else if (table.columnCell.length < cols) {
            CellBox[] newColumnCell = new CellBox[cols];
            for (i = 0; i < table.columnCell.length; ++i) {
                newColumnCell[i] = table.columnCell[i];
            }
            table.columnCell = newColumnCell;
        }
    }

    private static CellBox layoutCell(LayoutContext c, CellBox cell, Content content, boolean fixed, TableBox table, int col) {
        ReplacedElement re;
        CascadedStyle pushed = content.getStyle();
        if (pushed != null) {
            c.pushStyle(pushed);
        }
        if (c.getCurrentStyle().isIdent(CSSName.BACKGROUND_ATTACHMENT, IdentValue.FIXED)) {
            c.getRootLayer().setFixedBackground(true);
        }
        cell.setStyle(new Style(c.getCurrentStyle(), c.getExtents().width));
        BlockFormattingContext bfc = new BlockFormattingContext(cell, c);
        c.pushBFC(bfc);
        Rectangle oe = c.getExtents();
        c.setExtents(new Rectangle(oe));
        cell.colspan = (int)c.getCurrentStyle().asFloat(CSSName.FS_COLSPAN);
        cell.rowspan = (int)c.getCurrentStyle().asFloat(CSSName.FS_ROWSPAN);
        if (fixed) {
            int width = 0;
            for (int i = 0; i < cell.colspan; ++i) {
                width += table.columns[col + i];
            }
            c.getExtents().width = width;
        }
        CalculatedStyle style = c.getCurrentStyle();
        BorderPropertySet border = c.getCurrentStyle().getBorder(c);
        RectPropertySet padding = c.getCurrentStyle().getPaddingRect((float)oe.getWidth(), (float)oe.getWidth(), c);
        int setHeight = -1;
        int setWidth = -1;
        if (!cell.getStyle().isAutoWidth()) {
            c.getExtents().width = setWidth = (int)style.getFloatPropertyProportionalWidth(CSSName.WIDTH, c.getExtents().width, c);
            cell.contentWidth = (int)((float)setWidth - border.left() - padding.left() - padding.right() - border.right());
        }
        if (!cell.getStyle().isAutoHeight()) {
            c.getExtents().height = setHeight = (int)style.getFloatPropertyProportionalHeight(CSSName.HEIGHT, c.getExtents().height, c);
            cell.height = setHeight;
        }
        if ((re = c.getReplacedElementFactory().createReplacedElement(c, cell, c.getUac(), setWidth, setHeight)) != null) {
            cell.contentWidth = re.getIntrinsicWidth();
            cell.height = re.getIntrinsicHeight();
            cell.setReplacedElement(re);
        }
        int original_height = cell.height;
        cell.leftMBP = (int)border.left() + (int)padding.left();
        cell.rightMBP = (int)padding.right() + (int)border.right();
        int tx = (int)border.left() + (int)padding.left();
        int ty = (int)border.top() + (int)padding.top();
        cell.tx = tx;
        cell.ty = ty;
        c.translate(tx, ty);
        Rectangle extents = c.shrinkExtents(tx + (int)border.right() + (int)padding.right(), ty + (int)border.bottom() + (int)padding.bottom());
        if (!cell.isReplaced()) {
            Boxing.layoutChildren(c, cell, content);
        } else if (c.isInteractive()) {
            c.getCanvas().add(((SwingReplacedElement)cell.getReplacedElement()).getJComponent());
        }
        c.setExtents(extents);
        c.translate(-tx, -ty);
        if (!cell.getStyle().isAutoHeight()) {
            cell.height = original_height;
        } else {
            int delta = c.getBlockFormattingContext().getFloatManager().getClearDelta(c, (int)border.top() + (int)padding.top() + cell.height);
            if (delta > 0) {
                cell.height += delta;
            }
        }
        cell.height = (int)border.top() + (int)padding.top() + cell.height + (int)padding.bottom() + (int)border.bottom();
        c.setExtents(oe);
        c.popBFC();
        if (pushed != null) {
            c.popStyle();
        }
        cell.setState(3);
        cell.expandToMaxChildWidth();
        return cell;
    }
}

