/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.util;

import java.io.InputStream;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import org.xhtmlrenderer.util.XRLog;

public class GeneralUtil {
    public static final DecimalFormat PADDED_HASH_FORMAT = new DecimalFormat("0000000000");

    public static InputStream openStreamFromClasspath(Object obj, String resource) {
        InputStream readStream = null;
        try {
            ClassLoader loader = obj.getClass().getClassLoader();
            readStream = loader == null ? ClassLoader.getSystemResourceAsStream(resource) : loader.getResourceAsStream(resource);
            if (readStream == null) {
                URL stream = resource.getClass().getResource(resource);
                readStream = stream.openStream();
            }
        }
        catch (Exception ex) {
            XRLog.exception("Could not open stream from CLASSPATH: " + resource, ex);
        }
        return readStream;
    }

    public static URL getURLFromClasspath(Object obj, String resource) {
        URL url = null;
        try {
            ClassLoader loader = obj.getClass().getClassLoader();
            url = loader == null ? ClassLoader.getSystemResource(resource) : loader.getResource(resource);
            if (url == null) {
                url = resource.getClass().getResource(resource);
            }
        }
        catch (Exception ex) {
            XRLog.exception("Could not get URL from CLASSPATH: " + resource, ex);
        }
        return url;
    }

    public static void dumpShortException(Exception ex) {
        String s = ex.getMessage();
        if (s == null || s.trim().equals("null")) {
            s = "{no ex. message}";
        }
        System.out.println(s + ", " + ex.getClass());
        StackTraceElement[] stes = ex.getStackTrace();
        for (int i = 0; i < stes.length && i < 5; ++i) {
            StackTraceElement ste = stes[i];
            System.out.println("  " + ste.getClassName() + "." + ste.getMethodName() + "(ln " + ste.getLineNumber() + ")");
        }
    }

    public static String trackBack(int cnt) {
        Exception ex = new Exception();
        StringBuffer sb = new StringBuffer();
        ArrayList<String> list = new ArrayList<String>(cnt);
        StackTraceElement[] stes = ex.getStackTrace();
        if (cnt >= stes.length) {
            cnt = stes.length - 1;
        }
        for (int i = cnt; i >= 1; --i) {
            StackTraceElement ste = stes[i];
            sb.append(GeneralUtil.classNameOnly(ste.getClassName()));
            sb.append(".");
            sb.append(ste.getMethodName());
            sb.append("(ln " + ste.getLineNumber() + ")");
            list.add(sb.toString());
            sb = new StringBuffer();
        }
        Iterator iter = list.iterator();
        StringBuffer padding = new StringBuffer("");
        StringBuffer trackback = new StringBuffer();
        while (iter.hasNext()) {
            String s = (String)iter.next();
            trackback.append(padding + s + "\n");
            padding.append("   ");
        }
        return trackback.toString();
    }

    public static String classNameOnly(Object o) {
        String s = "[null object ref]";
        if (o != null) {
            s = GeneralUtil.classNameOnly(o.getClass().getName());
        }
        return s;
    }

    public static String classNameOnly(String cname) {
        String s = "[null object ref]";
        if (cname != null) {
            s = cname.substring(cname.lastIndexOf(46) + 1);
        }
        return s;
    }

    public static String paddedHashCode(Object o) {
        String s = "0000000000";
        if (o != null) {
            s = PADDED_HASH_FORMAT.format(o.hashCode());
        }
        return s;
    }

    public static boolean isMacOSX() {
        try {
            if (System.getProperty("os.name").toLowerCase().startsWith("mac os x")) {
                return true;
            }
        }
        catch (SecurityException e) {
            System.err.println(e.getLocalizedMessage());
        }
        return false;
    }
}

