/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.util;

import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xhtmlrenderer.util.Util;
import org.xml.sax.InputSource;

public class XMLUtil {
    private Util util;

    public XMLUtil() {
        this.util = new Util(System.out);
    }

    public XMLUtil(OutputStream out) {
        this.util = new Util(out);
    }

    public XMLUtil(PrintWriter pw) {
        this.util = new Util(pw);
    }

    public XMLUtil(Util util) {
        this.util = util;
    }

    public void p(Document doc) {
        this.util.print("document:");
        NodeList children = doc.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            this.p(children.item(i));
        }
    }

    public void p(Node node) {
        this.util.print("node: " + node);
        this.util.print("name: " + node.getNodeName());
        this.util.print("value: " + node.getNodeValue());
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            this.p(children.item(i));
        }
    }

    public static Document documentFromURL(URL docURL) throws Exception {
        DocumentBuilderFactory fact = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = fact.newDocumentBuilder();
        builder.setErrorHandler(null);
        return builder.parse(docURL.openStream());
    }

    public static Document documentFromFile(File docFile) throws Exception {
        URL url = docFile.toURL();
        DocumentBuilderFactory fact = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = fact.newDocumentBuilder();
        builder.setErrorHandler(null);
        return builder.parse(url.openStream());
    }

    public static Document documentFromString(String documentContents) throws Exception {
        DocumentBuilderFactory fact = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = fact.newDocumentBuilder();
        builder.setErrorHandler(null);
        return builder.parse(new InputSource(new StringReader(documentContents)));
    }

    public static Document loadDocument(String string) throws Exception {
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(string);
        return doc;
    }

    public static Document newDocument() throws Exception {
        Document output = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        return output;
    }

    public static Element ne(Document doc, String name, String value) {
        return XMLUtil.newElement(doc, name, value);
    }

    public static Element newElement(Document doc, String name, String value) {
        if (value == null) {
            value = "";
        }
        Element elem = doc.createElement(name);
        Text text = doc.createTextNode(value);
        elem.appendChild(text);
        return elem;
    }

    public static void transform(Document doc, String xsl, PrintWriter pw) throws Exception {
        DOMSource xml_source = new DOMSource(doc);
        File xsl_file = new File(xsl);
        StreamSource xsl_source = new StreamSource(xsl_file);
        Transformer transformer = TransformerFactory.newInstance().newTransformer(xsl_source);
        StreamResult result = new StreamResult(pw);
        transformer.transform(xml_source, result);
    }

    public static void clear(Element element) {
        NodeList nl = element.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            element.removeChild(nl.item(0));
        }
    }

    public static Element child(Element node, String name) {
        NodeList nl = node.getElementsByTagName(name);
        if (nl == null) {
            return null;
        }
        return (Element)nl.item(0);
    }

    public static NodeList children(Element node, String name) {
        NodeList nl = node.getElementsByTagName(name);
        return nl;
    }

    public static String text(Node node) {
        NodeList nl = node.getChildNodes();
        Node item = nl.item(0);
        return item.getNodeValue();
    }
}

