/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.xhtmlrenderer.util.Configuration;
import org.xhtmlrenderer.util.XRRuntimeException;

public class XRLog {
    private static final String CONFIG = "plumbing.config";
    private static final String EXCEPTION = "plumbing.exception";
    private static final String GENERAL = "plumbing.general";
    private static final String INIT = "plumbing.init";
    private static final String JUNIT = "plumbing.junit";
    private static final String LOAD = "plumbing.load";
    private static final String MATCH = "plumbing.match";
    private static final String CASCADE = "plumbing.cascade";
    private static final String XML_ENTITIES = "plumbing.load.xml-entities";
    private static final String CSS_PARSE = "plumbing.css-parse";
    private static final String LAYOUT = "plumbing.layout";
    private static final String RENDER = "plumbing.render";
    private static boolean initPending = true;

    public static void cssParse(String msg) {
        XRLog.cssParse(Level.INFO, msg);
    }

    public static void cssParse(Level level, String msg) {
        XRLog.log(CSS_PARSE, level, msg);
    }

    public static void cssParse(Level level, String msg, Throwable th) {
        XRLog.log(CSS_PARSE, level, msg, th);
    }

    public static void xmlEntities(String msg) {
        XRLog.xmlEntities(Level.INFO, msg);
    }

    public static void xmlEntities(Level level, String msg) {
        XRLog.log(XML_ENTITIES, level, msg);
    }

    public static void xmlEntities(Level level, String msg, Throwable th) {
        XRLog.log(XML_ENTITIES, level, msg, th);
    }

    public static void cascade(String msg) {
        XRLog.cascade(Level.INFO, msg);
    }

    public static void cascade(Level level, String msg) {
        XRLog.log(CASCADE, level, msg);
    }

    public static void cascade(Level level, String msg, Throwable th) {
        XRLog.log(CASCADE, level, msg, th);
    }

    public static void exception(String msg) {
        XRLog.exception(msg, null);
    }

    public static void exception(String msg, Throwable th) {
        XRLog.log(EXCEPTION, Level.WARNING, msg, th);
    }

    public static void general(String msg) {
        XRLog.general(Level.INFO, msg);
    }

    public static void general(Level level, String msg) {
        XRLog.log(GENERAL, level, msg);
    }

    public static void general(Level level, String msg, Throwable th) {
        XRLog.log(GENERAL, level, msg, th);
    }

    public static void init(String msg) {
        XRLog.init(Level.INFO, msg);
    }

    public static void init(Level level, String msg) {
        XRLog.log(INIT, level, msg);
    }

    public static void init(Level level, String msg, Throwable th) {
        XRLog.log(INIT, level, msg, th);
    }

    public static void junit(String msg) {
        XRLog.junit(Level.FINEST, msg);
    }

    public static void junit(Level level, String msg) {
        XRLog.log(JUNIT, level, msg);
    }

    public static void junit(Level level, String msg, Throwable th) {
        XRLog.log(JUNIT, level, msg, th);
    }

    public static void load(String msg) {
        XRLog.load(Level.INFO, msg);
    }

    public static void load(Level level, String msg) {
        XRLog.log(LOAD, level, msg);
    }

    public static void load(Level level, String msg, Throwable th) {
        XRLog.log(LOAD, level, msg, th);
    }

    public static void match(String msg) {
        XRLog.match(Level.INFO, msg);
    }

    public static void match(Level level, String msg) {
        XRLog.log(MATCH, level, msg);
    }

    public static void match(Level level, String msg, Throwable th) {
        XRLog.log(MATCH, level, msg, th);
    }

    public static void layout(String msg) {
        XRLog.layout(Level.INFO, msg);
    }

    public static void layout(Level level, String msg) {
        XRLog.log(LAYOUT, level, msg);
    }

    public static void layout(Level level, String msg, Throwable th) {
        XRLog.log(LAYOUT, level, msg, th);
    }

    public static void render(String msg) {
        XRLog.render(Level.INFO, msg);
    }

    public static void render(Level level, String msg) {
        XRLog.log(RENDER, level, msg);
    }

    public static void render(Level level, String msg, Throwable th) {
        XRLog.log(RENDER, level, msg, th);
    }

    public static void log(String where, Level level, String msg) {
        if (initPending) {
            XRLog.init();
        }
        XRLog.getLogger(where).log(level, msg);
    }

    public static void log(String where, Level level, String msg, Throwable th) {
        if (initPending) {
            XRLog.init();
        }
        XRLog.getLogger(where).log(level, msg, th);
    }

    public static void main(String[] args) {
        try {
            XRLog.cascade("Cascade msg");
            XRLog.cascade(Level.WARNING, "Cascade msg");
            XRLog.exception("Exception msg");
            XRLog.exception("Exception msg", new Exception());
            XRLog.general("General msg");
            XRLog.general(Level.WARNING, "General msg");
            XRLog.init("Init msg");
            XRLog.init(Level.WARNING, "Init msg");
            XRLog.load("Load msg");
            XRLog.load(Level.WARNING, "Load msg");
            XRLog.match("Match msg");
            XRLog.match(Level.WARNING, "Match msg");
            XRLog.layout("Layout msg");
            XRLog.layout(Level.WARNING, "Layout msg");
            XRLog.render("Render msg");
            XRLog.render(Level.WARNING, "Render msg");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init() {
        Class clazz = XRLog.class;
        synchronized (clazz) {
            if (!initPending) {
                return;
            }
            initPending = false;
            try {
                String prefix = "xr.util-logging.";
                Iterator iter = Configuration.keysByPrefix(prefix);
                Properties props = new Properties();
                while (iter.hasNext()) {
                    String fullkey = (String)iter.next();
                    String lmkey = fullkey.substring(prefix.length());
                    props.setProperty(lmkey, Configuration.valueFor(fullkey));
                }
                File f = File.createTempFile("xr-log", null);
                FileOutputStream fos = new FileOutputStream(f);
                props.store(fos, "# Temporary properties file");
                fos.close();
                FileInputStream fis = new FileInputStream(f);
                LogManager.getLogManager().readConfiguration(fis);
                fis.close();
                f.delete();
                Configuration.setConfigLogger(Logger.getLogger(CONFIG));
            }
            catch (SecurityException e) {
            }
            catch (FileNotFoundException e) {
                throw new XRRuntimeException("Could not initialize logs. " + e.getLocalizedMessage());
            }
            catch (IOException e) {
                throw new XRRuntimeException("Could not initialize logs. " + e.getLocalizedMessage());
            }
        }
    }

    private static Logger getLogger(String log) {
        return Logger.getLogger(log);
    }

    public static void setLevel(String log, Level level) {
        XRLog.getLogger(log).setLevel(level);
    }
}

