/*
 * Decompiled with CFR 0.152.
 */
package cryptix.provider;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.util.Properties;

final class Install {
    private PrintWriter out;
    private String product_name;
    private String provider_class;
    private String version_string;
    private int errorcode;
    private static final int INSTALLED = 10;
    private static final int ALREADY_INSTALLED = 10;
    private static final int NOT_INSTALLED = 1;

    public static void main(String[] stringArray) {
        Install install = new Install(new PrintWriter(System.out, true), "Cryptix", "cryptix.provider.Cryptix", "Cryptix V3");
        try {
            install.run();
        }
        catch (RuntimeException runtimeException) {
            System.err.println(runtimeException.getMessage());
            System.err.println();
            System.err.println("Cryptix has not been installed.");
        }
        System.exit(install.getErrorCode());
    }

    Install(PrintWriter printWriter, String string, String string2, String string3) {
        this.out = printWriter;
        this.product_name = string;
        this.provider_class = string2;
        this.version_string = string3;
        this.errorcode = 1;
    }

    int getErrorCode() {
        return this.errorcode;
    }

    void run() {
        Object object;
        String string = System.getProperty("java.home");
        this.out.println("Examining the Java installation at " + string);
        this.out.println();
        String string2 = System.getProperty("line.separator");
        Properties properties = new Properties();
        File file = new File(string, "lib" + File.separator + "security" + File.separator);
        File file2 = new File(file, "java.security");
        try {
            try {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file2));
                properties.load(bufferedInputStream);
                bufferedInputStream.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                try {
                    file2 = new File(file, "JAVA.SEC");
                    object = new BufferedInputStream(new FileInputStream(file2));
                    properties.load((InputStream)object);
                    ((BufferedInputStream)object).close();
                }
                catch (FileNotFoundException fileNotFoundException2) {
                    file2 = new File(file, "java.security");
                    throw fileNotFoundException;
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                if (file.exists()) {
                    if (!file.isDirectory()) {
                        this.out.println("The installation program needs to create the directory");
                        this.out.println("  " + file.getPath() + File.separator);
                        this.out.println("but a file already exists with that name.");
                        throw new RuntimeException("Could not create directory.");
                    }
                } else {
                    file.mkdirs();
                }
                DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file2)));
                dataOutputStream.writeBytes("# " + this.version_string + " (do not edit or delete this line)" + string2 + "# This is the \"master security properties file\"." + string2 + "#" + string2 + "# The " + this.product_name + " installation program was unable to find an existing" + string2 + "# java.security file, so it created this one." + string2 + string2 + "security.provider.1=" + this.provider_class + string2);
                dataOutputStream.close();
                this.errorcode = 10;
                this.out.println("The file " + file2);
                this.out.println("has been created.");
                return;
            }
            catch (IOException iOException) {
                this.errorcode = 1;
                this.out.println("The file " + file2);
                this.out.println("could not be created because of an I/O exception.");
                throw new RuntimeException(iOException.toString());
            }
        }
        catch (IOException iOException) {
            this.errorcode = 1;
            this.out.println("Failed to load the java.security file.");
            throw new RuntimeException(iOException.toString());
        }
        catch (SecurityException securityException) {
            this.errorcode = 1;
            this.out.println("Not allowed to load the java.security file.");
            throw new RuntimeException(securityException.toString());
        }
        int n = 1;
        while ((object = properties.getProperty("security.provider." + n)) != null) {
            if (((String)object).equals(this.provider_class)) {
                this.errorcode = 10;
                this.out.println(this.product_name + " is already installed.");
                return;
            }
            ++n;
        }
        if (properties.getProperty("security.provider." + (n + 1)) != null) {
            this.out.println("Warning: additional providers may have been added that were not previously");
            this.out.println("recognized, because a gap in the sequence of provider numbers has been filled.");
            this.out.println("You should edit the java.security file and check that it is correct.");
            this.out.println();
        }
        object = string2 + "# Added by " + this.version_string + " installation program:" + string2 + "security.provider." + n + "=" + this.provider_class + string2;
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(file2, "rw");
            long l = file2.length();
            randomAccessFile.seek(l);
            randomAccessFile.writeBytes((String)object);
            randomAccessFile.close();
            this.errorcode = 10;
            this.out.println("The following lines were added to");
            this.out.println("  " + file2 + ":");
            this.out.println((String)object);
            this.out.println("To uninstall " + this.product_name + ", remove these lines manually.");
        }
        catch (IOException iOException) {
            this.errorcode = 1;
            this.out.println("The file " + file2);
            this.out.println("could not be written to because of an I/O exception.");
            throw new RuntimeException(iOException.toString());
        }
        catch (SecurityException securityException) {
            this.errorcode = 1;
            this.out.println("The file " + file2);
            this.out.println("could not be written to because of a security exception.");
            throw new RuntimeException(securityException.toString());
        }
    }
}

