/*
 * Decompiled with CFR 0.152.
 */
package cryptix.provider.cipher;

import cryptix.provider.cipher.DES;
import cryptix.provider.key.RawSecretKey;
import cryptix.util.core.Debug;
import java.io.PrintWriter;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyException;
import xjava.security.Cipher;
import xjava.security.SymmetricCipher;

public class DESX
extends Cipher
implements SymmetricCipher {
    private static final boolean DEBUG = true;
    private static final boolean DEBUG_SLOW = false;
    private static final int debuglevel = Debug.getLevel("DESX");
    private static final PrintWriter err = Debug.getOutput();
    private static final int BLOCK_SIZE = 8;
    private static final int KEY_LENGTH = 24;
    private static final int SINGLE_KEY_LENGTH = 8;
    private Cipher des = new DES();
    private byte[] XORkey1 = null;
    private byte[] XORkey2 = null;

    private static void debug(String string) {
        err.println("DESX: " + string);
    }

    public DESX() {
        super(false, false, "Cryptix");
    }

    public int engineBlockSize() {
        return 8;
    }

    public void engineInitEncrypt(Key key) throws KeyException {
        byte[][] byArray = this.splitKey(key);
        RawSecretKey rawSecretKey = new RawSecretKey("DES", byArray[0]);
        this.des.initEncrypt(rawSecretKey);
        this.XORkey1 = byArray[1];
        this.XORkey2 = byArray[2];
    }

    protected void engineInitDecrypt(Key key) throws KeyException {
        byte[][] byArray = this.splitKey(key);
        RawSecretKey rawSecretKey = new RawSecretKey("DES", byArray[0]);
        this.des.initDecrypt(rawSecretKey);
        this.XORkey1 = byArray[2];
        this.XORkey2 = byArray[1];
    }

    protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        int n4;
        byte[] byArray3 = new byte[n2];
        for (n4 = 0; n4 < n2; ++n4) {
            byArray3[n4] = (byte)(byArray[n4 + n] ^ this.XORkey2[n4 % 8]);
        }
        this.des.update(byArray3, 0, n2, byArray3, 0);
        for (n4 = 0; n4 < n2; ++n4) {
            byArray2[n4 + n3] = (byte)(byArray3[n4] ^ this.XORkey1[n4 % 8]);
        }
        return n2;
    }

    private byte[][] splitKey(Key key) throws InvalidKeyException {
        byte[] byArray = key.getEncoded();
        if (byArray == null) {
            throw new InvalidKeyException(this.getAlgorithm() + ": Null user key");
        }
        if (byArray.length != 24) {
            throw new InvalidKeyException(this.getAlgorithm() + ": Invalid user key length");
        }
        byte[][] byArray2 = new byte[3][8];
        for (int i = 0; i < 3; ++i) {
            System.arraycopy(byArray, i * 8, byArray2[i], 0, 8);
        }
        return byArray2;
    }
}

