/*
 * Decompiled with CFR 0.152.
 */
package cryptix.provider.cipher;

import cryptix.util.core.Debug;
import java.io.PrintWriter;
import java.security.Key;
import java.security.KeyException;
import xjava.security.Cipher;
import xjava.security.SymmetricCipher;

public final class LOKI91
extends Cipher
implements SymmetricCipher {
    private static final boolean DEBUG = true;
    private static final boolean DEBUG_SLOW = false;
    private static final int debuglevel = Debug.getLevel("LOKI91");
    private static final PrintWriter err = Debug.getOutput();
    private static final int BLOCK_SIZE = 8;
    private static final int ROUNDS = 16;
    private static final byte[] S = new byte[4096];
    private static final int[] P = new int[256];
    private int[] sKey = new int[16];

    private static void debug(String string) {
        err.println("LOKI91: " + string);
    }

    private static final byte exp31(int n, int n2) {
        if (n == 0) {
            return 0;
        }
        int n3 = n;
        n = LOKI91.mult(n, n, n2);
        n3 = LOKI91.mult(n3, n, n2);
        n = LOKI91.mult(n, n, n2);
        n3 = LOKI91.mult(n3, n, n2);
        n = LOKI91.mult(n, n, n2);
        n3 = LOKI91.mult(n3, n, n2);
        n = LOKI91.mult(n, n, n2);
        return (byte)LOKI91.mult(n3, n, n2);
    }

    private static final int mult(int n, int n2, int n3) {
        int n4 = 0;
        while (n2 != 0) {
            if ((n2 & 1) != 0) {
                n4 ^= n;
            }
            if ((n <<= 1) > 255) {
                n ^= n3;
            }
            n2 >>>= 1;
        }
        return n4;
    }

    public LOKI91() {
        super(false, false, "Cryptix");
    }

    public final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    protected int engineBlockSize() {
        return 8;
    }

    protected void engineInitEncrypt(Key key) throws KeyException {
        this.makeKey(key);
    }

    protected void engineInitDecrypt(Key key) throws KeyException {
        this.makeKey(key);
    }

    protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        boolean bl;
        if (n2 < 0) {
            throw new IllegalArgumentException("inLen < 0");
        }
        int n4 = n2 / 8;
        n2 = n4 * 8;
        boolean bl2 = bl = this.getState() == 1;
        if (byArray == byArray2 && (n3 >= n && (long)n3 < (long)n + (long)n2 || n >= n3 && (long)n < (long)n3 + (long)n2)) {
            byte[] byArray3 = new byte[n2];
            System.arraycopy(byArray, n, byArray3, 0, n2);
            byArray = byArray3;
            n = 0;
        }
        if (bl) {
            for (int i = 0; i < n4; ++i) {
                this.blockEncrypt(byArray, n, byArray2, n3);
                n += 8;
                n3 += 8;
            }
        } else {
            for (int i = 0; i < n4; ++i) {
                this.blockDecrypt(byArray, n, byArray2, n3);
                n += 8;
                n3 += 8;
            }
        }
        return n2;
    }

    private synchronized void makeKey(Key key) throws KeyException {
        byte[] byArray = key.getEncoded();
        if (byArray == null) {
            throw new KeyException("Null LOKI91 key");
        }
        if (byArray.length < 8) {
            throw new KeyException("Invalid LOKI91 user key length");
        }
        this.sKey[0] = (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
        this.sKey[1] = this.sKey[0] << 12 | this.sKey[0] >>> 20;
        this.sKey[2] = (byArray[4] & 0xFF) << 24 | (byArray[5] & 0xFF) << 16 | (byArray[6] & 0xFF) << 8 | byArray[7] & 0xFF;
        this.sKey[3] = this.sKey[2] << 12 | this.sKey[2] >>> 20;
        for (int i = 4; i < 16; i += 4) {
            this.sKey[i] = this.sKey[i - 3] << 13 | this.sKey[i - 3] >>> 19;
            this.sKey[i + 1] = this.sKey[i] << 12 | this.sKey[i] >>> 20;
            this.sKey[i + 2] = this.sKey[i - 1] << 13 | this.sKey[i - 1] >>> 19;
            this.sKey[i + 3] = this.sKey[i + 2] << 12 | this.sKey[i + 2] >>> 20;
        }
    }

    private void blockEncrypt(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = (byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
        int n4 = (byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n] & 0xFF;
        int n5 = 0;
        while (n5 < 16) {
            int n6 = n4 ^ this.sKey[n5++];
            n3 ^= P[S[n6 & 0xFFF] & 0xFF] | P[S[n6 >>> 8 & 0xFFF] & 0xFF] << 1 | P[S[n6 >>> 16 & 0xFFF] & 0xFF] << 2 | P[S[(n6 >>> 24 | n6 << 8) & 0xFFF] & 0xFF] << 3;
            n6 = n3 ^ this.sKey[n5++];
            n4 ^= P[S[n6 & 0xFFF] & 0xFF] | P[S[n6 >>> 8 & 0xFFF] & 0xFF] << 1 | P[S[n6 >>> 16 & 0xFFF] & 0xFF] << 2 | P[S[(n6 >>> 24 | n6 << 8) & 0xFFF] & 0xFF] << 3;
        }
        byArray2[n2++] = (byte)(n4 >>> 24);
        byArray2[n2++] = (byte)(n4 >>> 16);
        byArray2[n2++] = (byte)(n4 >>> 8);
        byArray2[n2++] = (byte)n4;
        byArray2[n2++] = (byte)(n3 >>> 24);
        byArray2[n2++] = (byte)(n3 >>> 16);
        byArray2[n2++] = (byte)(n3 >>> 8);
        byArray2[n2] = (byte)n3;
    }

    private void blockDecrypt(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = (byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
        int n4 = (byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n] & 0xFF;
        int n5 = 16;
        while (n5 > 0) {
            int n6 = n4 ^ this.sKey[--n5];
            n3 ^= P[S[n6 & 0xFFF] & 0xFF] | P[S[n6 >>> 8 & 0xFFF] & 0xFF] << 1 | P[S[n6 >>> 16 & 0xFFF] & 0xFF] << 2 | P[S[(n6 >>> 24 | n6 << 8) & 0xFFF] & 0xFF] << 3;
            n6 = n3 ^ this.sKey[--n5];
            n4 ^= P[S[n6 & 0xFFF] & 0xFF] | P[S[n6 >>> 8 & 0xFFF] & 0xFF] << 1 | P[S[n6 >>> 16 & 0xFFF] & 0xFF] << 2 | P[S[(n6 >>> 24 | n6 << 8) & 0xFFF] & 0xFF] << 3;
        }
        byArray2[n2++] = (byte)(n4 >>> 24);
        byArray2[n2++] = (byte)(n4 >>> 16);
        byArray2[n2++] = (byte)(n4 >>> 8);
        byArray2[n2++] = (byte)n4;
        byArray2[n2++] = (byte)(n3 >>> 24);
        byArray2[n2++] = (byte)(n3 >>> 16);
        byArray2[n2++] = (byte)(n3 >>> 8);
        byArray2[n2] = (byte)n3;
    }

    static {
        int[] nArray = new int[]{375, 379, 391, 395, 397, 415, 419, 425, 433, 445, 451, 463, 471, 477, 487, 499};
        for (int i = 0; i < 4096; ++i) {
            int n = i >>> 8 & 0xC | i & 3;
            int n2 = i >>> 2 & 0xFF;
            int n3 = n2 + (n * 17 ^ 0xFF) & 0xFF;
            LOKI91.S[i] = LOKI91.exp31(n3, nArray[n]);
        }
        int[] nArray2 = new int[]{31, 23, 15, 7, 30, 22, 14, 6, 29, 21, 13, 5, 28, 20, 12, 4, 27, 19, 11, 3, 26, 18, 10, 2, 25, 17, 9, 1, 24, 16, 8, 0};
        for (int i = 0; i < 256; ++i) {
            int n = 0;
            for (int j = 0; j < 32; ++j) {
                n |= (i >>> nArray2[j] & 1) << 31 - j;
            }
            LOKI91.P[i] = n;
        }
    }
}

