/*
 * Decompiled with CFR 0.152.
 */
package cryptix.provider.cipher;

import cryptix.util.core.Debug;
import java.io.PrintWriter;
import java.security.Key;
import java.security.KeyException;
import xjava.security.Cipher;
import xjava.security.SymmetricCipher;

public final class RC2
extends Cipher
implements SymmetricCipher {
    private static final boolean DEBUG = true;
    private static final boolean DEBUG_SLOW = false;
    private static final int debuglevel = Debug.getLevel("RC2");
    private static final PrintWriter err = Debug.getOutput();
    private static final int[] S_BOX = new int[]{217, 120, 249, 196, 25, 221, 181, 237, 40, 233, 253, 121, 74, 160, 216, 157, 198, 126, 55, 131, 43, 118, 83, 142, 98, 76, 100, 136, 68, 139, 251, 162, 23, 154, 89, 245, 135, 179, 79, 19, 97, 69, 109, 141, 9, 129, 125, 50, 189, 143, 64, 235, 134, 183, 123, 11, 240, 149, 33, 34, 92, 107, 78, 130, 84, 214, 101, 147, 206, 96, 178, 28, 115, 86, 192, 20, 167, 140, 241, 220, 18, 117, 202, 31, 59, 190, 228, 209, 66, 61, 212, 48, 163, 60, 182, 38, 111, 191, 14, 218, 70, 105, 7, 87, 39, 242, 29, 155, 188, 148, 67, 3, 248, 17, 199, 246, 144, 239, 62, 231, 6, 195, 213, 47, 200, 102, 30, 215, 8, 232, 234, 222, 128, 82, 238, 247, 132, 170, 114, 172, 53, 77, 106, 42, 150, 26, 210, 113, 90, 21, 73, 116, 75, 159, 208, 94, 4, 24, 164, 236, 194, 224, 65, 110, 15, 81, 203, 204, 36, 145, 175, 80, 161, 244, 112, 57, 153, 124, 58, 133, 35, 184, 180, 122, 252, 2, 54, 91, 37, 85, 151, 49, 45, 93, 250, 152, 227, 138, 146, 174, 5, 223, 41, 16, 103, 108, 186, 201, 211, 0, 230, 207, 225, 158, 168, 44, 99, 22, 1, 63, 88, 226, 137, 169, 13, 56, 52, 27, 171, 51, 255, 176, 187, 72, 12, 95, 185, 177, 205, 46, 197, 243, 219, 71, 229, 165, 156, 119, 10, 166, 32, 104, 254, 127, 193, 173};
    private int[] sKey = new int[64];
    public static final int BLOCK_SIZE = 8;

    private static void debug(String string) {
        err.println("RC2: " + string);
    }

    public RC2() {
        super(false, false, "Cryptix");
    }

    public final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public int engineBlockSize() {
        return 8;
    }

    public void engineInitEncrypt(Key key) throws KeyException {
        this.makeKey(key);
    }

    public void engineInitDecrypt(Key key) throws KeyException {
        this.makeKey(key);
    }

    protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        boolean bl;
        if (n2 < 0) {
            throw new IllegalArgumentException("inLen < 0");
        }
        int n4 = n2 / 8;
        n2 = n4 * 8;
        boolean bl2 = bl = this.getState() == 1;
        if (byArray == byArray2 && (n3 >= n && (long)n3 < (long)n + (long)n2 || n >= n3 && (long)n < (long)n3 + (long)n2)) {
            byte[] byArray3 = new byte[n2];
            System.arraycopy(byArray, n, byArray3, 0, n2);
            byArray = byArray3;
            n = 0;
        }
        if (bl) {
            for (int i = 0; i < n4; ++i) {
                this.blockEncrypt(byArray, n, byArray2, n3);
                n += 8;
                n3 += 8;
            }
        } else {
            for (int i = 0; i < n4; ++i) {
                this.blockDecrypt(byArray, n, byArray2, n3);
                n += 8;
                n3 += 8;
            }
        }
        return n2;
    }

    private void makeKey(Key key) throws KeyException {
        int n;
        byte[] byArray = key.getEncoded();
        if (byArray == null) {
            throw new KeyException("Null RC2 user key");
        }
        int n2 = byArray.length;
        if (n2 > 128) {
            throw new KeyException("Invalid RC2 user key size");
        }
        int[] nArray = new int[128];
        for (n = 0; n < n2; ++n) {
            nArray[n] = byArray[n] & 0xFF;
        }
        for (n = n2; n < 128; ++n) {
            nArray[n] = S_BOX[nArray[n - n2] + nArray[n - 1] & 0xFF];
        }
        nArray[128 - n2] = S_BOX[nArray[128 - n2] & 0xFF];
        for (n = 127 - n2; n >= 0; --n) {
            nArray[n] = S_BOX[nArray[n + n2] ^ nArray[n + 1]];
        }
        for (n = 63; n >= 0; --n) {
            this.sKey[n] = (nArray[n * 2 + 1] << 8 | nArray[n * 2]) & 0xFFFF;
        }
    }

    private void blockEncrypt(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8;
        int n4 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8;
        int n5 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8;
        int n6 = byArray[n++] & 0xFF | (byArray[n] & 0xFF) << 8;
        int n7 = 0;
        for (int i = 0; i < 16; ++i) {
            n3 = n3 + (n4 & ~n6) + (n5 & n6) + this.sKey[n7++] & 0xFFFF;
            n3 = n3 << 1 | n3 >>> 15;
            n4 = n4 + (n5 & ~n3) + (n6 & n3) + this.sKey[n7++] & 0xFFFF;
            n4 = n4 << 2 | n4 >>> 14;
            n5 = n5 + (n6 & ~n4) + (n3 & n4) + this.sKey[n7++] & 0xFFFF;
            n5 = n5 << 3 | n5 >>> 13;
            n6 = n6 + (n3 & ~n5) + (n4 & n5) + this.sKey[n7++] & 0xFFFF;
            n6 = n6 << 5 | n6 >>> 11;
            if (i != 4 && i != 10) continue;
            n5 += this.sKey[(n4 += this.sKey[(n3 += this.sKey[n6 & 0x3F]) & 0x3F]) & 0x3F];
            n6 += this.sKey[n5 & 0x3F];
        }
        byArray2[n2++] = (byte)n3;
        byArray2[n2++] = (byte)(n3 >>> 8);
        byArray2[n2++] = (byte)n4;
        byArray2[n2++] = (byte)(n4 >>> 8);
        byArray2[n2++] = (byte)n5;
        byArray2[n2++] = (byte)(n5 >>> 8);
        byArray2[n2++] = (byte)n6;
        byArray2[n2] = (byte)(n6 >>> 8);
    }

    private void blockDecrypt(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = byArray[n + 0] & 0xFF | (byArray[n + 1] & 0xFF) << 8;
        int n4 = byArray[n + 2] & 0xFF | (byArray[n + 3] & 0xFF) << 8;
        int n5 = byArray[n + 4] & 0xFF | (byArray[n + 5] & 0xFF) << 8;
        int n6 = byArray[n + 6] & 0xFF | (byArray[n + 7] & 0xFF) << 8;
        int n7 = 63;
        for (int i = 15; i >= 0; --i) {
            n6 = (n6 >>> 5 | n6 << 11) & 0xFFFF;
            n6 = n6 - (n3 & ~n5) - (n4 & n5) - this.sKey[n7--] & 0xFFFF;
            n5 = (n5 >>> 3 | n5 << 13) & 0xFFFF;
            n5 = n5 - (n6 & ~n4) - (n3 & n4) - this.sKey[n7--] & 0xFFFF;
            n4 = (n4 >>> 2 | n4 << 14) & 0xFFFF;
            n4 = n4 - (n5 & ~n3) - (n6 & n3) - this.sKey[n7--] & 0xFFFF;
            n3 = (n3 >>> 1 | n3 << 15) & 0xFFFF;
            n3 = n3 - (n4 & ~n6) - (n5 & n6) - this.sKey[n7--] & 0xFFFF;
            if (i != 11 && i != 5) continue;
            n6 = n6 - this.sKey[n5 & 0x3F] & 0xFFFF;
            n5 = n5 - this.sKey[n4 & 0x3F] & 0xFFFF;
            n4 = n4 - this.sKey[n3 & 0x3F] & 0xFFFF;
            n3 = n3 - this.sKey[n6 & 0x3F] & 0xFFFF;
        }
        byArray2[n2++] = (byte)n3;
        byArray2[n2++] = (byte)(n3 >>> 8);
        byArray2[n2++] = (byte)n4;
        byArray2[n2++] = (byte)(n4 >>> 8);
        byArray2[n2++] = (byte)n5;
        byArray2[n2++] = (byte)(n5 >>> 8);
        byArray2[n2++] = (byte)n6;
        byArray2[n2] = (byte)(n6 >>> 8);
    }
}

