/*
 * Decompiled with CFR 0.152.
 */
package cryptix.provider.cipher;

import cryptix.util.core.Debug;
import java.io.PrintWriter;
import java.security.InvalidKeyException;
import java.security.Key;
import xjava.security.Cipher;
import xjava.security.SymmetricCipher;

public final class RC4
extends Cipher
implements SymmetricCipher {
    private static final boolean DEBUG = true;
    private static final boolean DEBUG_SLOW = false;
    private static final int debuglevel = Debug.getLevel("RC4");
    private static final PrintWriter err = Debug.getOutput();
    private int[] sBox = new int[256];
    private int x;
    private int y;
    private static final int BLOCK_SIZE = 1;

    private static void debug(String string) {
        err.println("RC4: " + string);
    }

    public RC4() {
        super(false, false, "Cryptix");
    }

    public final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public int engineBlockSize() {
        return 1;
    }

    public void engineInitEncrypt(Key key) throws InvalidKeyException {
        this.makeKey(key);
    }

    public void engineInitDecrypt(Key key) throws InvalidKeyException {
        this.makeKey(key);
    }

    protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        boolean bl;
        if (n2 < 0) {
            throw new IllegalArgumentException("inLen < 0");
        }
        boolean bl2 = bl = this.getState() == 1;
        if (byArray == byArray2 && (n3 >= n && (long)n3 < (long)n + (long)n2 || n >= n3 && (long)n < (long)n3 + (long)n2)) {
            byte[] byArray3 = new byte[n2];
            System.arraycopy(byArray, n, byArray3, 0, n2);
            byArray = byArray3;
            n = 0;
        }
        this.rc4(byArray, n, n2, byArray2, n3);
        return n2;
    }

    private void rc4(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        for (int i = 0; i < n2; ++i) {
            this.x = this.x + 1 & 0xFF;
            this.y = this.sBox[this.x] + this.y & 0xFF;
            int n4 = this.sBox[this.x];
            this.sBox[this.x] = this.sBox[this.y];
            this.sBox[this.y] = n4;
            int n5 = this.sBox[this.x] + this.sBox[this.y] & 0xFF;
            byArray2[n3++] = (byte)(byArray[n++] ^ this.sBox[n5]);
        }
    }

    private void makeKey(Key key) throws InvalidKeyException {
        int n;
        byte[] byArray = key.getEncoded();
        if (byArray == null) {
            throw new InvalidKeyException(this.getAlgorithm() + ": Null user key");
        }
        int n2 = byArray.length;
        if (n2 == 0) {
            throw new InvalidKeyException(this.getAlgorithm() + ": Invalid user key length");
        }
        this.y = 0;
        this.x = 0;
        for (n = 0; n < 256; ++n) {
            this.sBox[n] = n;
        }
        n = 0;
        int n3 = 0;
        for (int i = 0; i < 256; ++i) {
            n3 = (byArray[n] & 0xFF) + this.sBox[i] + n3 & 0xFF;
            int n4 = this.sBox[i];
            this.sBox[i] = this.sBox[n3];
            this.sBox[n3] = n4;
            n = (n + 1) % n2;
        }
    }
}

