/*
 * Decompiled with CFR 0.152.
 */
package cryptix.provider.cipher;

import cryptix.util.core.Debug;
import java.io.PrintWriter;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyException;
import java.security.Security;
import xjava.security.Cipher;
import xjava.security.InvalidParameterTypeException;
import xjava.security.NoSuchParameterException;
import xjava.security.SymmetricCipher;

public final class SAFER
extends Cipher
implements SymmetricCipher {
    private static final boolean DEBUG = true;
    private static final boolean DEBUG_SLOW = false;
    private static final int debuglevel = Debug.getLevel("SAFER");
    private static final PrintWriter err = Debug.getOutput();
    public static final int SK128_VARIANT = 0;
    public static final int SK64_VARIANT = 1;
    public static final int K128_VARIANT = 2;
    public static final int K64_VARIANT = 3;
    private static final int K64_DEFAULT_NOF_ROUNDS = 6;
    private static final int K128_DEFAULT_NOF_ROUNDS = 10;
    private static final int SK64_DEFAULT_NOF_ROUNDS = 8;
    private static final int SK128_DEFAULT_NOF_ROUNDS = 10;
    private static final int MAX_NOF_ROUNDS = 13;
    private static final int BLOCK_SIZE = 8;
    private static final int KEY_LENGTH = 217;
    private static final int TAB_LEN = 256;
    private int[] sKey = new int[217];
    private int rounds = 10;
    private int variant = 0;
    private static final int[] EXP = new int[256];
    private static final int[] LOG = new int[256];

    private static void debug(String string) {
        err.println("SAFER: " + string);
    }

    public SAFER() {
        super(false, false, "Cryptix");
        String string;
        try {
            string = Security.getAlgorithmProperty("SAFER", "variant");
            if (string != null) {
                this.setVariant(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        switch (this.variant) {
            case 0: {
                this.rounds = 10;
                break;
            }
            case 1: {
                this.rounds = 8;
                break;
            }
            case 2: {
                this.rounds = 10;
                break;
            }
            case 3: {
                this.rounds = 6;
            }
        }
        try {
            string = Security.getAlgorithmProperty("SAFER", "rounds");
            if (string != null) {
                this.setRounds(Integer.parseInt(string));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public int engineBlockSize() {
        return 8;
    }

    public void engineInitEncrypt(Key key) throws KeyException {
        this.makeKey(key);
    }

    public void engineInitDecrypt(Key key) throws KeyException {
        this.makeKey(key);
    }

    protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        boolean bl;
        if (n2 < 0) {
            throw new IllegalArgumentException("inLen < 0");
        }
        int n4 = n2 / 8;
        n2 = n4 * 8;
        boolean bl2 = bl = this.getState() == 1;
        if (byArray == byArray2 && (n3 >= n && (long)n3 < (long)n + (long)n2 || n >= n3 && (long)n < (long)n3 + (long)n2)) {
            byte[] byArray3 = new byte[n2];
            System.arraycopy(byArray, n, byArray3, 0, n2);
            byArray = byArray3;
            n = 0;
        }
        if (bl) {
            for (int i = 0; i < n4; ++i) {
                this.blockEncrypt(byArray, n, byArray2, n3);
                n += 8;
                n3 += 8;
            }
        } else {
            for (int i = 0; i < n4; ++i) {
                this.blockDecrypt(byArray, n, byArray2, n3);
                n += 8;
                n3 += 8;
            }
        }
        return n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void engineSetParameter(String string, Object object) throws NoSuchParameterException, InvalidParameterException, InvalidParameterTypeException {
        if (string.equalsIgnoreCase("rounds")) {
            if (!(object instanceof Integer)) throw new InvalidParameterTypeException("rounds.SAFER");
            this.setRounds((Integer)object);
            return;
        } else {
            if (!string.equalsIgnoreCase("variant")) throw new NoSuchParameterException(string + ".SAFER");
            if (!(object instanceof String)) throw new InvalidParameterTypeException("variant.SAFER");
            this.setVariant((String)object);
        }
    }

    protected Object engineGetParameter(String string) throws NoSuchParameterException, InvalidParameterException {
        if (string.equalsIgnoreCase("rounds")) {
            return new Integer(this.rounds);
        }
        if (string.equalsIgnoreCase("variant")) {
            return this.getVariant();
        }
        throw new NoSuchParameterException(string + ".SAFER");
    }

    public void setRounds(int n) {
        if (this.getState() != 0) {
            throw new IllegalStateException("Cipher not in UNINITIALIZED state");
        }
        if (n <= 0 || n > 13) {
            throw new InvalidParameterException();
        }
        this.rounds = n;
    }

    public int getRounds() {
        return this.rounds;
    }

    public void setVariant(String string) {
        if (this.getState() != 0) {
            throw new IllegalStateException("Cipher not in UNINITIALIZED state");
        }
        if (string.equalsIgnoreCase("SK128") || string.equalsIgnoreCase("SK-128")) {
            this.variant = 0;
        } else if (string.equalsIgnoreCase("SK64") || string.equalsIgnoreCase("SK-64")) {
            this.variant = 1;
        } else if (string.equalsIgnoreCase("K128") || string.equalsIgnoreCase("K-128")) {
            this.variant = 2;
        } else if (string.equalsIgnoreCase("K64") || string.equalsIgnoreCase("K-64")) {
            this.variant = 3;
        } else {
            throw new InvalidParameterException();
        }
    }

    public String getVariant() {
        switch (this.variant) {
            case 0: {
                return "SK-128";
            }
            case 1: {
                return "SK-64";
            }
            case 2: {
                return "K-128";
            }
            case 3: {
                return "K-64";
            }
        }
        throw new InternalError("variant = " + this.variant);
    }

    private void blockEncrypt(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3;
        int n4 = 0;
        if (13 < (n3 = this.sKey[n4++])) {
            n3 = 13;
        }
        int n5 = byArray[n++];
        int n6 = byArray[n++];
        int n7 = byArray[n++];
        int n8 = byArray[n++];
        int n9 = byArray[n++];
        int n10 = byArray[n++];
        int n11 = byArray[n++];
        int n12 = byArray[n++];
        for (int i = 0; i < n3; ++i) {
            n5 ^= this.sKey[n4++];
            n6 += this.sKey[n4++];
            n7 += this.sKey[n4++];
            n8 ^= this.sKey[n4++];
            n9 ^= this.sKey[n4++];
            n10 += this.sKey[n4++];
            n11 += this.sKey[n4++];
            n12 ^= this.sKey[n4++];
            n5 = EXP[n5 & 0xFF] + this.sKey[n4++];
            n6 = LOG[n6 & 0xFF] ^ this.sKey[n4++];
            n7 = LOG[n7 & 0xFF] ^ this.sKey[n4++];
            n8 = EXP[n8 & 0xFF] + this.sKey[n4++];
            n9 = EXP[n9 & 0xFF] + this.sKey[n4++];
            n10 = LOG[n10 & 0xFF] ^ this.sKey[n4++];
            n11 = LOG[n11 & 0xFF] ^ this.sKey[n4++];
            n12 = EXP[n12 & 0xFF] + this.sKey[n4++];
            n6 += n5;
            n5 += n6;
            n8 += n7;
            n7 += n8;
            n10 += n9;
            n12 += n11;
            n11 += n12;
            n7 += n5;
            n5 += n7;
            n11 += (n9 += n10);
            n9 += n11;
            n8 += n6;
            n12 += n10;
            n10 += n12;
            n9 += n5;
            n5 += n9;
            n10 += (n6 += n8);
            n11 += n7;
            n12 += n8;
            int n13 = n6 += n10;
            n6 = n9;
            n9 = n7 += n11;
            n7 = n13;
            n13 = n8 += n12;
            n8 = n10;
            n10 = n11;
            n11 = n13;
        }
        byArray2[n2++] = (byte)(n5 ^ this.sKey[n4++]);
        byArray2[n2++] = (byte)(n6 + this.sKey[n4++]);
        byArray2[n2++] = (byte)(n7 + this.sKey[n4++]);
        byArray2[n2++] = (byte)(n8 ^ this.sKey[n4++]);
        byArray2[n2++] = (byte)(n9 ^ this.sKey[n4++]);
        byArray2[n2++] = (byte)(n10 + this.sKey[n4++]);
        byArray2[n2++] = (byte)(n11 + this.sKey[n4++]);
        byArray2[n2++] = (byte)(n12 ^ this.sKey[n4++]);
    }

    private void blockDecrypt(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = this.sKey[0];
        if (13 < n3) {
            n3 = 13;
        }
        int n4 = byArray[n++];
        int n5 = byArray[n++];
        int n6 = byArray[n++];
        int n7 = byArray[n++];
        int n8 = byArray[n++];
        int n9 = byArray[n++];
        int n10 = byArray[n++];
        int n11 = byArray[n++];
        int n12 = 8 * (1 + 2 * n3);
        n11 ^= this.sKey[n12];
        n10 -= this.sKey[--n12];
        n9 -= this.sKey[--n12];
        n8 ^= this.sKey[--n12];
        n7 ^= this.sKey[--n12];
        n6 -= this.sKey[--n12];
        n5 -= this.sKey[--n12];
        n4 ^= this.sKey[--n12];
        for (int i = 0; i < n3; ++i) {
            int n13 = n8;
            n8 = n5;
            n5 = n6;
            n6 = n13;
            n13 = n9;
            n9 = n7;
            n7 = n10;
            n10 = n13;
            n4 -= n8;
            n8 -= n4;
            n5 -= n9;
            n9 -= n5;
            n6 -= n10;
            n10 -= n6;
            n7 -= n11;
            n11 -= n7;
            n4 -= n6;
            n6 -= n4;
            n8 -= n10;
            n10 -= n8;
            n5 -= n7;
            n7 -= n5;
            n9 -= n11;
            n11 -= n9;
            n4 -= n5;
            n5 -= n4;
            n6 -= n7;
            n7 -= n6;
            n8 -= n9;
            n9 -= n8;
            n10 -= n11;
            n11 -= n10;
            n11 -= this.sKey[--n12];
            n10 ^= this.sKey[--n12];
            n9 ^= this.sKey[--n12];
            n8 -= this.sKey[--n12];
            n7 -= this.sKey[--n12];
            n6 ^= this.sKey[--n12];
            n5 ^= this.sKey[--n12];
            n4 -= this.sKey[--n12];
            n11 = LOG[n11 & 0xFF] ^ this.sKey[--n12];
            n10 = EXP[n10 & 0xFF] - this.sKey[--n12];
            n9 = EXP[n9 & 0xFF] - this.sKey[--n12];
            n8 = LOG[n8 & 0xFF] ^ this.sKey[--n12];
            n7 = LOG[n7 & 0xFF] ^ this.sKey[--n12];
            n6 = EXP[n6 & 0xFF] - this.sKey[--n12];
            n5 = EXP[n5 & 0xFF] - this.sKey[--n12];
            n4 = LOG[n4 & 0xFF] ^ this.sKey[--n12];
        }
        byArray2[n2++] = (byte)n4;
        byArray2[n2++] = (byte)n5;
        byArray2[n2++] = (byte)n6;
        byArray2[n2++] = (byte)n7;
        byArray2[n2++] = (byte)n8;
        byArray2[n2++] = (byte)n9;
        byArray2[n2++] = (byte)n10;
        byArray2[n2++] = (byte)n11;
    }

    private synchronized void makeKey(Key key) throws KeyException {
        byte[] byArray = key.getEncoded();
        if (byArray == null) {
            throw new KeyException("Invalid SAFER key");
        }
        byte[] byArray2 = new byte[16];
        int n = byArray.length;
        int n2 = 16;
        int n3 = 0;
        while (n2 >= n) {
            System.arraycopy(byArray, 0, byArray2, n3, n);
            n2 -= n;
            n3 += n;
        }
        System.arraycopy(byArray, 0, byArray2, n3, n2);
        byte[] byArray3 = new byte[8];
        byte[] byArray4 = new byte[8];
        System.arraycopy(byArray2, 0, byArray3, 0, 8);
        System.arraycopy(byArray2, 8, byArray4, 0, 8);
        this.Safer_Expand_Userkey(byArray3, byArray4);
    }

    private void Safer_Expand_Userkey(byte[] byArray, byte[] byArray2) {
        int n;
        byte[] byArray3 = new byte[9];
        byte[] byArray4 = new byte[9];
        int n2 = 0;
        this.sKey[n2++] = (byte)this.rounds;
        for (n = 0; n < 8; ++n) {
            byArray3[n] = (byte)(byArray[n] << 5 | (byArray[n] & 0xFF) >>> 3);
            byArray3[8] = (byte)(byArray3[8] ^ byArray3[n]);
            this.sKey[n2++] = byArray2[n];
            byArray4[n] = byArray2[n];
            byArray4[8] = (byte)(byArray4[8] ^ byArray4[n]);
        }
        for (n = 1; n <= this.rounds; ++n) {
            int n3;
            for (n3 = 0; n3 < 9; ++n3) {
                byArray3[n3] = (byte)(byArray3[n3] << 6 | (byArray3[n3] & 0xFF) >>> 2);
                byArray4[n3] = (byte)(byArray4[n3] << 6 | (byArray4[n3] & 0xFF) >>> 2);
            }
            for (n3 = 0; n3 < 8; ++n3) {
                this.sKey[n2++] = this.isStrong() ? byArray3[(n3 + 2 * n - 1) % 9] + EXP[EXP[18 * n + n3 + 1]] & 0xFF : byArray3[n3] + EXP[EXP[18 * n + n3 + 1]] & 0xFF;
            }
            for (n3 = 0; n3 < 8; ++n3) {
                this.sKey[n2++] = this.isStrong() ? byArray4[(n3 + 2 * n) % 9] + EXP[EXP[18 * n + n3 + 10]] & 0xFF : byArray4[n3] + EXP[EXP[18 * n + n3 + 10]] & 0xFF;
            }
        }
    }

    private boolean isStrong() {
        return this.variant < 2;
    }

    static {
        int n = 1;
        for (int i = 0; i < 256; ++i) {
            SAFER.EXP[i] = n & 0xFF;
            SAFER.LOG[SAFER.EXP[i]] = i;
            n = n * 45 % 257;
        }
    }
}

