/*
 * Decompiled with CFR 0.152.
 */
package cryptix.provider.cipher;

import cryptix.CryptixException;
import cryptix.provider.key.RawSecretKey;
import cryptix.util.core.ArrayUtil;
import cryptix.util.core.Debug;
import cryptix.util.core.Hex;
import java.io.PrintWriter;
import java.security.InvalidKeyException;
import java.security.Key;
import xjava.security.Cipher;
import xjava.security.SymmetricCipher;

public final class Square
extends Cipher
implements SymmetricCipher {
    private static final boolean DEBUG = true;
    private static final boolean DEBUG_SLOW = false;
    private static final int debuglevel;
    private static final PrintWriter err;
    private static final byte[] SE;
    private static final byte[] SD;
    private static final int[] TE;
    private static final int[] TD;
    private static final int BLOCK_SIZE = 16;
    private static final int R = 8;
    private int[][] sKey = new int[9][4];
    private static final int ROOT = 501;
    private static final int[] OFFSET;
    private static final String[][] tests;

    private static void debug(String string) {
        err.println("Square: " + string);
    }

    public Square() {
        super(false, false, "Cryptix");
    }

    public final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public int engineBlockSize() {
        return 16;
    }

    protected void engineInitEncrypt(Key key) throws InvalidKeyException {
        this.makeKey(key, true);
    }

    protected void engineInitDecrypt(Key key) throws InvalidKeyException {
        this.makeKey(key, false);
    }

    protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        boolean bl;
        if (n2 < 0) {
            throw new IllegalArgumentException("inLen < 0");
        }
        int n4 = n2 / 16;
        n2 = n4 * 16;
        boolean bl2 = bl = this.getState() == 1;
        if (byArray == byArray2 && (n3 >= n && (long)n3 < (long)n + (long)n2 || n >= n3 && (long)n < (long)n3 + (long)n2)) {
            byte[] byArray3 = new byte[n2];
            System.arraycopy(byArray, n, byArray3, 0, n2);
            byArray = byArray3;
            n = 0;
        }
        if (bl) {
            for (int i = 0; i < n4; ++i) {
                this.square(byArray, n, byArray2, n3, TE, SE);
                n += 16;
                n3 += 16;
            }
        } else {
            for (int i = 0; i < n4; ++i) {
                this.square(byArray, n, byArray2, n3, TD, SD);
                n += 16;
                n3 += 16;
            }
        }
        return n2;
    }

    private void makeKey(Key key, boolean bl) throws InvalidKeyException {
        byte[] byArray = key.getEncoded();
        if (byArray == null) {
            throw new InvalidKeyException(this.getAlgorithm() + ": Null user key");
        }
        if (byArray.length != 16) {
            throw new InvalidKeyException(this.getAlgorithm() + ": Invalid user key length");
        }
        int n = 0;
        if (bl) {
            int n2;
            for (n2 = 0; n2 < 4; ++n2) {
                this.sKey[0][n2] = (byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
            }
            for (n2 = 1; n2 < 9; ++n2) {
                n = n2 - 1;
                this.sKey[n2][0] = this.sKey[n][0] ^ Square.rot32L(this.sKey[n][3], 8) ^ OFFSET[n];
                this.sKey[n2][1] = this.sKey[n][1] ^ this.sKey[n2][0];
                this.sKey[n2][2] = this.sKey[n][2] ^ this.sKey[n2][1];
                this.sKey[n2][3] = this.sKey[n][3] ^ this.sKey[n2][2];
                Square.transform(this.sKey[n], this.sKey[n]);
            }
        } else {
            int n3;
            int[][] nArray = new int[9][4];
            for (n3 = 0; n3 < 4; ++n3) {
                nArray[0][n3] = (byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
            }
            for (n3 = 1; n3 < 9; ++n3) {
                n = n3 - 1;
                nArray[n3][0] = nArray[n][0] ^ Square.rot32L(nArray[n][3], 8) ^ OFFSET[n];
                nArray[n3][1] = nArray[n][1] ^ nArray[n3][0];
                nArray[n3][2] = nArray[n][2] ^ nArray[n3][1];
                nArray[n3][3] = nArray[n][3] ^ nArray[n3][2];
            }
            for (n3 = 0; n3 < 8; ++n3) {
                System.arraycopy(nArray[8 - n3], 0, this.sKey[n3], 0, 4);
            }
            Square.transform(nArray[0], this.sKey[8]);
        }
    }

    private static void transform(int[] nArray, int[] nArray2) {
        for (int i = 0; i < 4; ++i) {
            int n = nArray[i];
            int n2 = n >>> 8;
            int n3 = n >>> 16;
            int n4 = n >>> 24;
            int n5 = ((Square.mul(n4, 2) ^ Square.mul(n3, 3) ^ n2 ^ n) & 0xFF) << 24;
            n5 ^= ((n4 ^ Square.mul(n3, 2) ^ Square.mul(n2, 3) ^ n) & 0xFF) << 16;
            n5 ^= ((n4 ^ n3 ^ Square.mul(n2, 2) ^ Square.mul(n, 3)) & 0xFF) << 8;
            nArray2[i] = n5 ^= (Square.mul(n4, 3) ^ n3 ^ n2 ^ Square.mul(n, 2)) & 0xFF;
        }
    }

    private static int rot32L(int n, int n2) {
        return n << n2 | n >>> 32 - n2;
    }

    private static int rot32R(int n, int n2) {
        return n >>> n2 | n << 32 - n2;
    }

    private static final int mul(int n, int n2) {
        if (n == 0) {
            return 0;
        }
        n &= 0xFF;
        n2 &= 0xFF;
        int n3 = 0;
        while (n2 != 0) {
            if ((n2 & 1) != 0) {
                n3 ^= n;
            }
            if ((n <<= 1) > 255) {
                n ^= 0x1F5;
            }
            n2 >>>= 1;
        }
        return n3 & 0xFF;
    }

    private void square(byte[] byArray, int n, byte[] byArray2, int n2, int[] nArray, byte[] byArray3) {
        int n3;
        int n4 = (byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
        int n5 = (byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
        int n6 = (byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
        int n7 = (byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
        n4 ^= this.sKey[0][0];
        n5 ^= this.sKey[0][1];
        n6 ^= this.sKey[0][2];
        n7 ^= this.sKey[0][3];
        for (n3 = 1; n3 < 8; ++n3) {
            int n8 = nArray[n4 >>> 24 & 0xFF] ^ Square.rot32R(nArray[n5 >>> 24 & 0xFF], 8) ^ Square.rot32R(nArray[n6 >>> 24 & 0xFF], 16) ^ Square.rot32R(nArray[n7 >>> 24 & 0xFF], 24) ^ this.sKey[n3][0];
            int n9 = nArray[n4 >>> 16 & 0xFF] ^ Square.rot32R(nArray[n5 >>> 16 & 0xFF], 8) ^ Square.rot32R(nArray[n6 >>> 16 & 0xFF], 16) ^ Square.rot32R(nArray[n7 >>> 16 & 0xFF], 24) ^ this.sKey[n3][1];
            int n10 = nArray[n4 >>> 8 & 0xFF] ^ Square.rot32R(nArray[n5 >>> 8 & 0xFF], 8) ^ Square.rot32R(nArray[n6 >>> 8 & 0xFF], 16) ^ Square.rot32R(nArray[n7 >>> 8 & 0xFF], 24) ^ this.sKey[n3][2];
            int n11 = nArray[n4 & 0xFF] ^ Square.rot32R(nArray[n5 & 0xFF], 8) ^ Square.rot32R(nArray[n6 & 0xFF], 16) ^ Square.rot32R(nArray[n7 & 0xFF], 24) ^ this.sKey[n3][3];
            n4 = n8;
            n5 = n9;
            n6 = n10;
            n7 = n11;
        }
        n3 = 0;
        int n12 = 24;
        while (n3 < 4) {
            int n13 = (byArray3[n4 >>> n12 & 0xFF] & 0xFF) << 24 | (byArray3[n5 >>> n12 & 0xFF] & 0xFF) << 16 | (byArray3[n6 >>> n12 & 0xFF] & 0xFF) << 8 | byArray3[n7 >>> n12 & 0xFF] & 0xFF;
            byArray2[n2++] = (byte)((n13 ^= this.sKey[8][n3]) >>> 24 & 0xFF);
            byArray2[n2++] = (byte)(n13 >>> 16 & 0xFF);
            byArray2[n2++] = (byte)(n13 >>> 8 & 0xFF);
            byArray2[n2++] = (byte)(n13 & 0xFF);
            ++n3;
            n12 -= 8;
        }
    }

    public static final void main(String[] stringArray) {
        try {
            Square.self_test();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void self_test() throws Exception {
        Cipher cipher = Cipher.getInstance("Square", "Cryptix");
        for (int i = 0; i < tests.length; ++i) {
            RawSecretKey rawSecretKey = new RawSecretKey("Square", Hex.fromString(tests[i][0]));
            byte[] byArray = Hex.fromString(tests[i][1]);
            byte[] byArray2 = Hex.fromString(tests[i][2]);
            cipher.initEncrypt(rawSecretKey);
            byte[] byArray3 = cipher.crypt(byArray);
            if (!ArrayUtil.areEqual(byArray2, byArray3)) {
                System.out.println("     input: " + Hex.toString(byArray));
                System.out.println("  computed: " + Hex.toString(byArray3));
                System.out.println(" certified: " + Hex.toString(byArray2));
                throw new CryptixException("encrypt #" + i + " failed");
            }
            cipher.initDecrypt(rawSecretKey);
            byArray3 = cipher.crypt(byArray2);
            if (ArrayUtil.areEqual(byArray, byArray3)) continue;
            throw new CryptixException("decrypt #" + i + " failed");
        }
        if (debuglevel > 0) {
            Square.debug("Self-test OK");
        }
    }

    static {
        int n;
        int n2;
        debuglevel = Debug.getLevel("Square");
        err = Debug.getOutput();
        SE = new byte[256];
        SD = new byte[256];
        TE = new int[256];
        TD = new int[256];
        OFFSET = new int[8];
        byte[] byArray = new byte[256];
        byte[] byArray2 = new byte[256];
        byArray[0] = 1;
        for (n2 = 1; n2 < 256; ++n2) {
            n = byArray[n2 - 1] << 1;
            if ((n & 0x100) != 0) {
                n ^= 0x1F5;
            }
            byArray[n2] = (byte)n;
            byArray2[n & 0xFF] = (byte)n2;
        }
        Square.SE[0] = 0;
        Square.SE[1] = 1;
        for (n2 = 2; n2 < 256; ++n2) {
            Square.SE[n2] = byArray[255 - byArray2[n2] & 0xFF];
        }
        int[] nArray = new int[]{1, 3, 5, 15, 31, 61, 123, 214};
        for (n2 = 0; n2 < 256; ++n2) {
            int n3 = 177;
            for (n = 0; n < 8; ++n) {
                int n4 = SE[n2] & nArray[n] & 0xFF;
                n4 ^= n4 >>> 4;
                n4 ^= n4 >>> 2;
                n4 ^= n4 >>> 1;
                n3 ^= (n4 &= 1) << n;
            }
            Square.SE[n2] = (byte)n3;
            Square.SD[n3] = (byte)n2;
        }
        Square.OFFSET[0] = 1;
        for (n2 = 1; n2 < 8; ++n2) {
            Square.OFFSET[n2] = Square.mul(OFFSET[n2 - 1], 2);
            int n5 = n2 - 1;
            OFFSET[n5] = OFFSET[n5] << 24;
        }
        OFFSET[7] = OFFSET[7] << 24;
        for (n2 = 0; n2 < 256; ++n2) {
            int n6 = SE[n2] & 0xFF;
            int n7 = SD[n2] & 0xFF;
            Square.TE[n2] = SE[n2 & 3] == 0 ? 0 : Square.mul(n6, 2) << 24 | n6 << 16 | n6 << 8 | Square.mul(n6, 3);
            Square.TD[n2] = SD[n2 & 3] == 0 ? 0 : Square.mul(n7, 14) << 24 | Square.mul(n7, 9) << 16 | Square.mul(n7, 13) << 8 | Square.mul(n7, 11);
        }
        tests = new String[][]{{"000102030405060708090a0b0c0d0e0f", "000102030405060708090a0b0c0d0e0f", "7C3491D94994E70F0EC2E7A5CCB5A14F"}, {"000102030405060708090a0b0c0d0e0f", "000102030405060708090a0b0c0d0e0f000102030405060708090a0b0c0d0e0f", "7C3491D94994E70F0EC2E7A5CCB5A14F7C3491D94994E70F0EC2E7A5CCB5A14F"}};
    }
}

