/*
 * Decompiled with CFR 0.152.
 */
package cryptix.provider.mode;

import cryptix.CryptixException;
import cryptix.provider.mode.FeedbackMode;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyException;
import xjava.security.Cipher;

public class OFB
extends FeedbackMode {
    public OFB() {
        super(true, false, "Cryptix");
    }

    public OFB(Cipher cipher) {
        this();
        this.engineSetCipher(cipher);
    }

    public OFB(Cipher cipher, byte[] byArray) {
        this(cipher);
        this.setInitializationVector(byArray);
    }

    protected int engineBlockSize() {
        return 1;
    }

    protected void engineInitEncrypt(Key key) throws KeyException {
        this.cipher.initEncrypt(key);
        if (this.ivStart != null) {
            System.arraycopy(this.ivStart, 0, this.ivBlock, 0, this.length);
        }
        this.currentByte = this.length;
    }

    protected void engineInitDecrypt(Key key) throws KeyException {
        this.cipher.initEncrypt(key);
        if (this.ivStart != null) {
            System.arraycopy(this.ivStart, 0, this.ivBlock, 0, this.length);
        }
        this.currentByte = this.length;
    }

    protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        if (this.ivBlock == null) {
            throw new InvalidParameterException("OFB: IV is not set");
        }
        if (this.getState() == 0) {
            throw new CryptixException("OFB: Cipher not initialized");
        }
        if (byArray == byArray2 && n3 > n && (long)n3 < (long)n + (long)n2) {
            byte[] byArray3 = new byte[n2];
            System.arraycopy(byArray, n, byArray3, 0, n2);
            byArray = byArray3;
            n = 0;
        }
        for (int i = 0; i < n2; ++i) {
            byArray2[i + n3] = this.cryptByte(byArray[i + n]);
        }
        return n2;
    }

    private byte cryptByte(byte by) {
        if (this.currentByte >= this.length) {
            this.currentByte = 0;
            this.cipher.update(this.ivBlock, 0, this.length, this.ivBlock, 0);
        }
        by = (byte)(by ^ this.ivBlock[this.currentByte]);
        ++this.currentByte;
        return by;
    }
}

