/*
 * Decompiled with CFR 0.152.
 */
package cryptix.provider.rsa;

import cryptix.provider.rsa.RSAAlgorithm;
import cryptix.provider.rsa.RawRSAPrivateKey;
import cryptix.provider.rsa.RawRSAPublicKey;
import cryptix.util.core.BI;
import cryptix.util.core.Debug;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import xjava.security.interfaces.RSAKeyPairGenerator;

public class BaseRSAKeyPairGenerator
extends KeyPairGenerator
implements RSAKeyPairGenerator {
    private static final boolean DEBUG = true;
    private static final int debuglevel = Debug.getLevel("RSA", "BaseRSAKeyPairGenerator");
    private static final PrintWriter err = Debug.getOutput();
    private int strength;
    private BigInteger e;
    private SecureRandom source;
    private static final int CONFIDENCE = 80;
    private static final BigInteger F4 = BigInteger.valueOf(65537L);
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private static final int DEFAULT_STRENGTH = 1024;

    private static void debug(String string) {
        err.println("BaseRSAKeyPairGenerator: " + string);
    }

    public BaseRSAKeyPairGenerator() {
        super("RSA");
    }

    public void initialize(int n, BigInteger bigInteger, SecureRandom secureRandom) {
        this.e = bigInteger == null ? F4 : bigInteger;
        this.strength = n < 2 ? 1024 : n;
        this.source = secureRandom == null ? new SecureRandom() : secureRandom;
    }

    public void initialize(int n, SecureRandom secureRandom) {
        this.initialize(n, F4, secureRandom);
    }

    public KeyPair generateKeyPair() {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        BigInteger bigInteger3;
        BigInteger bigInteger4;
        int n = this.strength / 2;
        int n2 = this.strength - n;
        long l = 0L;
        if (debuglevel >= 7) {
            l = System.currentTimeMillis();
        }
        while (true) {
            try {
                do {
                    bigInteger4 = new BigInteger(n, 80, this.source);
                    bigInteger3 = new BigInteger(n2, 80, this.source);
                    bigInteger2 = bigInteger4.multiply(bigInteger3);
                } while (bigInteger4.compareTo(bigInteger3) == 0 || bigInteger2.bitLength() != this.strength);
                BigInteger bigInteger5 = bigInteger4.subtract(ONE).multiply(bigInteger3.subtract(ONE));
                bigInteger = this.e.modInverse(bigInteger5);
            }
            catch (ArithmeticException arithmeticException) {
                continue;
            }
            break;
        }
        if (debuglevel >= 7) {
            l = System.currentTimeMillis() - l;
            BaseRSAKeyPairGenerator.debug(" ...generateKeyPair() completed in " + l + " ms.");
        }
        if (debuglevel >= 5) {
            try {
                err.print("RSA parameters self test #1/2... ");
                BigInteger bigInteger6 = new BigInteger(n, this.source);
                BigInteger bigInteger7 = RSAAlgorithm.rsa(bigInteger6, bigInteger2, this.e);
                BigInteger bigInteger8 = RSAAlgorithm.rsa(bigInteger7, bigInteger2, bigInteger);
                boolean bl = bigInteger8.compareTo(bigInteger6) == 0;
                err.println(bl ? "OK" : "Failed");
                if (!bl) {
                    throw new RuntimeException();
                }
                err.print("RSA parameters self test #2/2... ");
                BigInteger bigInteger9 = bigInteger3.modInverse(bigInteger4);
                bigInteger8 = RSAAlgorithm.rsa(bigInteger7, bigInteger2, bigInteger, bigInteger4, bigInteger3, bigInteger9);
                bl = bigInteger8.compareTo(bigInteger6) == 0;
                err.println(bl ? "OK" : "Failed");
                if (!bl) {
                    throw new RuntimeException();
                }
                err.println();
            }
            catch (Exception exception) {
                err.println("RSA parameters:");
                err.println("         n: " + BI.dumpString(bigInteger2));
                err.println("         e: " + BI.dumpString(this.e));
                err.println("         d: " + BI.dumpString(bigInteger));
                err.println("         p: " + BI.dumpString(bigInteger4));
                err.println("         q: " + BI.dumpString(bigInteger3));
                err.println("q^-1 mod p: " + BI.dumpString(bigInteger3.modInverse(bigInteger4)));
                throw new RuntimeException(this.e.toString());
            }
        }
        return this.makeKeyPair(bigInteger2, this.e, bigInteger, bigInteger4, bigInteger3);
    }

    protected KeyPair makeKeyPair(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5) {
        RawRSAPublicKey rawRSAPublicKey = new RawRSAPublicKey(bigInteger, bigInteger2);
        RawRSAPrivateKey rawRSAPrivateKey = new RawRSAPrivateKey(bigInteger3, bigInteger4, bigInteger5);
        return new KeyPair(rawRSAPublicKey, rawRSAPrivateKey);
    }

    public void initialize() {
        this.initialize(1024, F4, new SecureRandom());
    }
}

