/*
 * Decompiled with CFR 0.152.
 */
package cryptix.test;

import cryptix.provider.md.SHA1;
import cryptix.util.core.Hex;
import cryptix.util.test.BaseTest;
import java.security.MessageDigest;

class TestSHA1
extends BaseTest {
    private static String[][] testData1 = new String[][]{{"", "da39a3ee5e6b4b0d3255bfef95601890afd80709"}, {"1", "356a192b7913b04c54574d18c28d46e6395428ab"}, {"abc", "A9993E364706816ABA3E25717850C26C9CD0D89D"}, {"abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq", "84983E441C3BD26EBAAE4AA1F95129E5E54670F1"}, {"Anyone got any SHA-1 test data?", "09b9e9c04a84ce274942048acf3a6f2ff4a8a39c"}, {"Of cabbages and kings", "5f093d74a9cb1f2f14537bcf3a8a1ffd59b038a2"}, {"aaaaaaaaa...a (1 million times)", "34AA973CD4C4DAA4F61EEB2BDBAD27316534016F"}};

    TestSHA1() {
    }

    public static void main(String[] stringArray) {
        new TestSHA1().commandline(stringArray);
    }

    protected void engineTest() throws Exception {
        int n;
        int n2 = 0;
        int n3 = 0;
        String[][] stringArray = testData1;
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-1", "Cryptix");
        this.setExpectedPasses(stringArray.length + 1);
        for (n = 0; n < stringArray.length; ++n) {
            byte[] byArray;
            boolean bl;
            messageDigest.reset();
            if (n == stringArray.length - 1) {
                for (bl = false; bl < 1000 != 0; bl += 1) {
                    for (int i = 0; i < 1000; ++i) {
                        messageDigest.update((byte)97);
                    }
                }
                byArray = messageDigest.digest();
            } else {
                byArray = messageDigest.digest(stringArray[n][0].getBytes());
            }
            String string = Hex.toString(byArray);
            this.out.println("         data: '" + stringArray[n][0] + "'");
            this.out.println("  computed md: " + string);
            this.out.println(" certified md: " + stringArray[n][1]);
            bl = string.equalsIgnoreCase(stringArray[n][1]);
            this.passIf(bl, "Data Set #" + (n + 1));
            if (bl) {
                this.out.println("   * Hash (#" + ++n2 + "/" + (n + 1) + ") good");
            } else {
                this.out.println("===> Hash (#" + ++n3 + "/" + (n + 1) + ") FAILED  <===");
                this.out.println("     (no debugging available)");
            }
            this.out.println();
        }
        this.out.println("\nSHA-1 succeeded (" + n + " tests)");
        SHA1 cfr_ignored_0 = (SHA1)messageDigest;
        SHA1.self_test();
        this.passIf(true, "Self Test (no diags)");
    }
}

