/*
 * Decompiled with CFR 0.152.
 */
package cryptix.util.core;

import cryptix.util.core.Hex;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;

public class BI {
    private BI() {
    }

    public static BigInteger fromStream(InputStream inputStream) throws IOException {
        int n = inputStream.read() << 8 | inputStream.read();
        byte[] byArray = new byte[(n + 7) / 8];
        inputStream.read(byArray);
        return new BigInteger(1, byArray);
    }

    public static void toStream(BigInteger bigInteger, OutputStream outputStream) throws IOException {
        int n = bigInteger.bitLength();
        outputStream.write(n >>> 8);
        outputStream.write(n & 0xFF);
        outputStream.write(BI.getMagnitude(bigInteger));
    }

    public static byte[] getMagnitude(BigInteger bigInteger) {
        int n;
        byte[] byArray = bigInteger.toByteArray();
        for (n = 0; byArray[n] == 0 && n < byArray.length - 1; ++n) {
        }
        byte[] byArray2 = new byte[byArray.length - n];
        System.arraycopy(byArray, n, byArray2, 0, byArray.length - n);
        return byArray2;
    }

    public static String dumpString(BigInteger bigInteger, String string) {
        if (bigInteger == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append(string).append("Multi-Precision Integer ").append(bigInteger.bitLength()).append(" bits long...\n");
        stringBuffer.append(string).append("      sign: ");
        if (bigInteger.signum() == -1) {
            stringBuffer.append("Negative\n");
        } else {
            stringBuffer.append("Positive\n");
        }
        stringBuffer.append(string).append(" magnitude: ").append(Hex.dumpString(BI.getMagnitude(bigInteger))).append('\n');
        return stringBuffer.toString();
    }

    public static String dumpString(BigInteger bigInteger) {
        return BI.dumpString(bigInteger, "");
    }
}

