/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.cert;

import COM.claymoresystems.cert.CertContext;
import COM.claymoresystems.cert.DERUtils;
import COM.claymoresystems.crypto.BaseDSAPrivateKey;
import COM.claymoresystems.crypto.RawDSAParams;
import cryptix.asn1.encoding.BaseCoder;
import cryptix.asn1.encoding.CoderOperations;
import cryptix.asn1.lang.ASNObject;
import cryptix.asn1.lang.ASNSpecification;
import cryptix.asn1.lang.ParserVisitor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.interfaces.DSAPrivateKey;

public class EAYDSAPrivateKey
extends BaseDSAPrivateKey {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EAYDSAPrivateKey(byte[] byArray) throws IOException {
        ASNSpecification aSNSpecification = CertContext.getSpec();
        synchronized (aSNSpecification) {
            CoderOperations coderOperations = BaseCoder.getInstance((String)"DER");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            coderOperations.init((InputStream)byteArrayInputStream);
            ASNObject aSNObject = CertContext.getSpec().getComponent("EAYDSAPrivateKey");
            aSNObject.accept((ParserVisitor)coderOperations, null);
            BigInteger bigInteger = (BigInteger)aSNObject.getComponent("EAYDSAPrivateKey.p").getValue();
            BigInteger bigInteger2 = (BigInteger)aSNObject.getComponent("EAYDSAPrivateKey.q").getValue();
            BigInteger bigInteger3 = (BigInteger)aSNObject.getComponent("EAYDSAPrivateKey.g").getValue();
            this.params = new RawDSAParams(bigInteger, bigInteger2, bigInteger3);
            this.X = (BigInteger)aSNObject.getComponent("EAYDSAPrivateKey.x").getValue();
        }
    }

    public EAYDSAPrivateKey(DSAPrivateKey dSAPrivateKey) {
        super(dSAPrivateKey);
    }

    public String getFormat() {
        return "DER";
    }

    public byte[] getEncoded() {
        ByteArrayOutputStream byteArrayOutputStream;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            DERUtils.encodeInteger(BigInteger.valueOf(0L), byteArrayOutputStream);
            DERUtils.encodeInteger(this.params.getP(), byteArrayOutputStream);
            DERUtils.encodeInteger(this.params.getQ(), byteArrayOutputStream);
            DERUtils.encodeInteger(this.params.getG(), byteArrayOutputStream);
            DERUtils.encodeInteger(this.getY(), byteArrayOutputStream);
            DERUtils.encodeInteger(this.X, byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.reset();
            DERUtils.encodeSequence(byArray, (OutputStream)byteArrayOutputStream);
        }
        catch (IOException iOException) {
            throw new InternalError(iOException.toString());
        }
        return byteArrayOutputStream.toByteArray();
    }
}

