/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.cert;

import COM.claymoresystems.cert.DERUtils;
import COM.claymoresystems.cert.X509Ext;
import COM.claymoresystems.ptls.SSLDebug;
import java.io.ByteArrayInputStream;
import java.io.IOException;

class X509BasicConstraints {
    private boolean critical = false;
    private boolean cA = false;
    private int pathLen = 255;
    static byte[] oid = new byte[]{85, 29, 19};

    X509BasicConstraints(X509Ext x509Ext) throws IOException {
        this.critical = x509Ext.isCritical();
        SSLDebug.debug(32, "Contents of basic constraints", x509Ext.getValue());
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(x509Ext.getValue());
        byte[] byArray = DERUtils.decodeOctetString(byteArrayInputStream);
        if (byteArrayInputStream.available() != 0) {
            throw new IOException("Overlong Basic Constraints encoding, bytes left=" + byteArrayInputStream.available());
        }
        SSLDebug.debug(32, "Sequence encoding", byArray);
        byteArrayInputStream = new ByteArrayInputStream(byArray);
        byte[] byArray2 = DERUtils.decodeSequence(byteArrayInputStream);
        if (byteArrayInputStream.available() != 0) {
            throw new IOException("Overlong Basic Constraints encoding, bytes left=" + byteArrayInputStream.available());
        }
        SSLDebug.debug(32, "Sequence internal data", byArray2);
        byteArrayInputStream = new ByteArrayInputStream(byArray2);
        if (byteArrayInputStream.available() > 0) {
            if (DERUtils.isTag(1, byteArrayInputStream)) {
                this.cA = DERUtils.decodeBoolean(byteArrayInputStream);
            }
            if (byteArrayInputStream.available() > 0 && DERUtils.isTag(2, byteArrayInputStream)) {
                this.pathLen = DERUtils.decodeIntegerX(byteArrayInputStream);
            }
        }
        if (byteArrayInputStream.available() != 0) {
            throw new IOException("Bad encoding for Basic Constraints");
        }
    }

    boolean isCritical() {
        return this.critical;
    }

    boolean isCA() {
        return this.cA;
    }

    int getPathLen() {
        return this.pathLen;
    }
}

