/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.cert;

import COM.claymoresystems.cert.DERUtils;
import COM.claymoresystems.cert.X509Cert;
import COM.claymoresystems.ptls.SSLDebug;
import COM.claymoresystems.sslg.Extension;
import cryptix.util.core.ArrayUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Vector;

public class X509Ext
implements Extension {
    private byte[] oid;
    private boolean critical;
    private byte[] value;

    X509Ext(byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        byte[] byArray2 = DERUtils.decodeSequence(byteArrayInputStream);
        byteArrayInputStream = new ByteArrayInputStream(byArray2);
        this.oid = DERUtils.decodeOID(byteArrayInputStream);
        if (DERUtils.isTag(1, byteArrayInputStream)) {
            this.critical = DERUtils.decodeBoolean(byteArrayInputStream);
        }
        this.value = DERUtils.decodeAny(byteArrayInputStream);
    }

    public byte[] getOID() {
        return this.oid;
    }

    public boolean isCritical() {
        return this.critical;
    }

    public byte[] getValue() {
        return this.value;
    }

    static X509Ext getExtensionFromCert(X509Cert x509Cert, byte[] byArray) throws IOException {
        X509Ext x509Ext = null;
        Vector vector = x509Cert.getExtensions();
        SSLDebug.debug(32, "Looking for extension", byArray);
        if (vector == null) {
            return null;
        }
        for (int i = 0; i < vector.size(); ++i) {
            X509Ext x509Ext2 = (X509Ext)vector.elementAt(i);
            SSLDebug.debug(32, "Found extension", x509Ext2.getOID());
            if (!ArrayUtil.areEqual((byte[])x509Ext2.getOID(), (byte[])byArray)) continue;
            if (x509Ext != null) {
                throw new IOException("Can't have two extensions of this type");
            }
            x509Ext = x509Ext2;
        }
        return x509Ext;
    }
}

