/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.crypto;

import cryptix.provider.mac.HMAC_MD2;
import cryptix.provider.mac.HMAC_MD5;
import cryptix.provider.mac.HMAC_RIPEMD128;
import cryptix.provider.mac.HMAC_RIPEMD160;
import cryptix.provider.mac.HMAC_SHA1;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import xjava.security.InvalidParameterTypeException;
import xjava.security.NoSuchParameterException;
import xjava.security.Parameterized;

public class HMACInputStream
extends InputStream {
    private InputStream sub;
    private MessageDigest md;

    protected void _HMACInputStream(String string, byte[] byArray, InputStream inputStream) {
        this.sub = inputStream;
        if (string.equalsIgnoreCase("MD5")) {
            this.md = new HMAC_MD5();
        }
        if (string.equalsIgnoreCase("SHA1")) {
            this.md = new HMAC_SHA1();
        }
        if (string.equalsIgnoreCase("MD2")) {
            this.md = new HMAC_MD2();
        }
        if (string.equalsIgnoreCase("SHA")) {
            this.md = new HMAC_SHA1();
        }
        if (string.equalsIgnoreCase("RIPEMD128")) {
            this.md = new HMAC_RIPEMD128();
        }
        if (string.equalsIgnoreCase("RIPEMD160")) {
            this.md = new HMAC_RIPEMD160();
        }
        try {
            ((Parameterized)this.md).setParameter("key", (Object)byArray);
        }
        catch (NoSuchParameterException noSuchParameterException) {
            noSuchParameterException.printStackTrace();
        }
        catch (InvalidParameterTypeException invalidParameterTypeException) {
            invalidParameterTypeException.printStackTrace();
        }
    }

    public HMACInputStream(String string, byte[] byArray, InputStream inputStream) {
        this._HMACInputStream(string, byArray, inputStream);
    }

    public HMACInputStream(String string, String string2, InputStream inputStream) {
        try {
            if (string.equalsIgnoreCase("MD5")) {
                this.md = new HMAC_MD5();
            }
            if (string.equalsIgnoreCase("SHA1")) {
                this.md = new HMAC_SHA1();
            }
            if (string.equalsIgnoreCase("MD2")) {
                this.md = new HMAC_MD2();
            }
            if (string.equalsIgnoreCase("SHA")) {
                this.md = new HMAC_SHA1();
            }
            if (string.equalsIgnoreCase("RIPEMD128")) {
                this.md = new HMAC_RIPEMD128();
            }
            if (string.equalsIgnoreCase("RIPEMD160")) {
                this.md = new HMAC_RIPEMD160();
            }
            this._HMACInputStream(string, this.md.digest(string2.getBytes()), inputStream);
        }
        catch (Exception exception) {
            throw new InternalError(exception.toString());
        }
    }

    public int read() throws IOException {
        int n = this.sub.read();
        this.md.update((byte)(0xFF & n));
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        int n = this.sub.read(byArray);
        this.md.update(byArray, 0, n);
        return n;
    }

    public byte[] digest() {
        return this.md.digest();
    }
}

