/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.provider.test;

import COM.claymoresystems.provider.ClaymoreProvider;
import COM.claymoresystems.util.Bench;
import COM.claymoresystems.util.Util;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;

class DSATest
extends Bench {
    private static final byte[] testString = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8};

    DSATest() {
    }

    public static void main(String[] stringArray) {
        int n = 1;
        Security.addProvider(new ClaymoreProvider());
        if (stringArray.length != 0) {
            if (stringArray.length == 1) {
                n = Integer.parseInt(stringArray[0]);
            } else {
                throw new InternalError("Bad arguments");
            }
        }
        int n2 = DSATest.register("SunSign");
        int n3 = DSATest.register("SunVerify");
        int n4 = DSATest.register("ClaymoreSign");
        int n5 = DSATest.register("ClaymoreVerify");
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("DSA");
            keyPairGenerator.initialize(1024, new SecureRandom());
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            messageDigest.update(testString);
            PrivateKey privateKey = keyPair.getPrivate();
            byte[] byArray = messageDigest.digest();
            for (int i = 0; i < n; ++i) {
                Signature signature = Signature.getInstance("RawDSA");
                Signature signature2 = Signature.getInstance("RawDSA");
                Signature signature3 = Signature.getInstance("DSA");
                Signature signature4 = Signature.getInstance("DSA");
                DSATest.start(n4);
                signature.initSign(privateKey);
                signature.update(byArray);
                byte[] byArray2 = signature.sign();
                DSATest.end(n4);
                Util.xdump("signature", byArray2);
                signature = Signature.getInstance("RawDSA");
                signature.initSign(privateKey);
                signature.update(byArray);
                byArray2 = signature.sign();
                Util.xdump("second signature", byArray2);
                DSATest.start(n2);
                signature4.initSign(privateKey);
                signature4.update(testString);
                byte[] byArray3 = signature4.sign();
                DSATest.end(n2);
                if (!Util.areEqual(byArray2, byArray3)) {
                    System.out.println("signatures don't match");
                }
                PublicKey publicKey = keyPair.getPublic();
                DSATest.start(n5);
                signature2.initVerify(publicKey);
                signature2.update(byArray);
                boolean bl = signature2.verify(byArray2);
                DSATest.end(n5);
                if (bl) {
                    System.out.println("Verifies with our implementation");
                } else {
                    System.out.println("Failed our verify");
                }
                DSATest.start(n3);
                signature3.initVerify(publicKey);
                signature3.update(testString);
                bl = signature3.verify(byArray2);
                DSATest.end(n3);
                if (bl) {
                    System.out.println("Verifies with stock implementation");
                } else {
                    System.out.println("Failed stock verify");
                }
                byte[] byArray4 = new byte[byArray2.length];
                System.arraycopy(byArray2, 0, byArray4, 0, byArray2.length);
                byArray4[0] = (byte)(byArray4[0] + 1);
                signature2 = Signature.getInstance("RawDSA");
                signature2.initVerify(publicKey);
                signature2.update(byArray);
                boolean bl2 = false;
                try {
                    bl = signature2.verify(byArray4);
                }
                catch (Exception exception) {
                    bl2 = true;
                }
                if (!bl2) {
                    System.out.println("Badly encoded sig Verifies with our implementation (BAD)");
                } else {
                    System.out.println("Badly encoded sig Failed our verify (OK)");
                }
                int n6 = byArray.length - 1;
                byArray[n6] = (byte)(byArray[n6] + 1);
                signature2 = Signature.getInstance("RawDSA");
                signature2.initVerify(publicKey);
                signature2.update(byArray);
                bl = signature2.verify(byArray2);
                if (bl) {
                    System.out.println("Bad sig Verifies with our implementation (BAD)");
                    continue;
                }
                System.out.println("Bad sig Failed our verify (OK)");
            }
        }
        catch (Exception exception) {
            System.err.println("Caught exception " + exception.toString());
            exception.printStackTrace(System.out);
        }
        DSATest.dump();
    }
}

