/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.ptls;

import COM.claymoresystems.crypto.Blindable;
import COM.claymoresystems.ptls.SSLAlertX;
import COM.claymoresystems.ptls.SSLConn;
import COM.claymoresystems.ptls.SSLDebug;
import COM.claymoresystems.ptls.SSLHandshake;
import COM.claymoresystems.ptls.SSLPDU;
import COM.claymoresystems.ptls.SSLopaque;
import COM.claymoresystems.ptls.SSLv3CertificateVerify;
import COM.claymoresystems.ptls.TLSCertificateVerify;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import xjava.security.interfaces.CryptixRSAPublicKey;

class SSLCertificateVerify
extends SSLPDU {
    SSLopaque signature = new SSLopaque(-65535);
    byte[] toBeSigned;

    private String getCVAlg(String string) {
        if (string.equals("DSA")) {
            return "RawDSA";
        }
        if (string.equals("RSA")) {
            return "RawRSA";
        }
        throw new InternalError("Bogus algorithm");
    }

    public SSLCertificateVerify(SSLConn sSLConn, SSLHandshake sSLHandshake, boolean bl) {
        switch (sSLConn.ssl_version) {
            case 768: {
                this.toBeSigned = SSLv3CertificateVerify.computeToBeSigned(sSLHandshake, bl);
                break;
            }
            case 769: {
                this.toBeSigned = TLSCertificateVerify.computeToBeSigned(sSLHandshake, bl);
                break;
            }
            default: {
                throw new InternalError("Bogus version number");
            }
        }
    }

    public int encode(SSLConn sSLConn, OutputStream outputStream) throws IOException {
        try {
            PrivateKey privateKey = sSLConn.ctx.getPrivateKey();
            String string = this.getCVAlg(privateKey.getAlgorithm());
            Signature signature = Signature.getInstance(string);
            signature.initSign(privateKey);
            if (string.equals("RawRSA")) {
                ((Blindable)((Object)signature)).setBlindingInfo(sSLConn.hs.rng, (CryptixRSAPublicKey)sSLConn.ctx.getPublicKey());
            }
            SSLDebug.debug(8, "Certificate verify toBeSigned", this.toBeSigned);
            if (string.equals("RawDSA")) {
                signature.setParameter("SecureRandom", sSLConn.hs.rng);
                signature.update(this.toBeSigned, 16, 20);
            } else {
                signature.update(this.toBeSigned, 0, this.toBeSigned.length);
            }
            byte[] byArray = signature.sign();
            SSLDebug.debug(8, "Certificate verify signature", byArray);
            this.signature.value = byArray;
            return this.signature.encode(sSLConn, outputStream);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InternalError(noSuchAlgorithmException.toString());
        }
        catch (SignatureException signatureException) {
            throw new InternalError(signatureException.toString());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InternalError(invalidKeyException.toString());
        }
    }

    public int decode(SSLConn sSLConn, InputStream inputStream) throws IOException {
        int n = 0;
        try {
            PublicKey publicKey = sSLConn.hs.peerSignatureKey;
            String string = this.getCVAlg(publicKey.getAlgorithm());
            Signature signature = Signature.getInstance(string);
            signature.initVerify(publicKey);
            n = this.signature.decode(sSLConn, inputStream);
            SSLDebug.debug(8, "Certificate verify toBeSigned", this.toBeSigned);
            if (string.equals("RawDSA")) {
                signature.update(this.toBeSigned, 16, 20);
            } else {
                signature.update(this.toBeSigned, 0, this.toBeSigned.length);
            }
            SSLDebug.debug(8, "Certificate verify signature", this.signature.value);
            if (!signature.verify(this.signature.value)) {
                sSLConn.alert(SSLAlertX.TLS_ALERT_DECRYPT_ERROR);
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InternalError(noSuchAlgorithmException.toString());
        }
        catch (InvalidKeyException invalidKeyException) {
            sSLConn.alert(SSLAlertX.TLS_ALERT_DECRYPT_ERROR);
        }
        catch (SignatureException signatureException) {
            sSLConn.alert(SSLAlertX.TLS_ALERT_DECRYPT_ERROR);
        }
        return n;
    }
}

