/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.ptls;

import COM.claymoresystems.crypto.Blindable;
import COM.claymoresystems.crypto.DHPrivateKey;
import COM.claymoresystems.crypto.DHPublicKey;
import COM.claymoresystems.crypto.PKCS1Pad;
import COM.claymoresystems.ptls.SSLConn;
import COM.claymoresystems.ptls.SSLDebug;
import COM.claymoresystems.ptls.SSLException;
import COM.claymoresystems.ptls.SSLHandshake;
import COM.claymoresystems.ptls.SSLPDU;
import COM.claymoresystems.ptls.SSLopaque;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import xjava.security.Cipher;
import xjava.security.interfaces.CryptixRSAPrivateKey;
import xjava.security.interfaces.CryptixRSAPublicKey;

class SSLClientKeyExchange
extends SSLPDU {
    SSLopaque client_data = new SSLopaque(-65535);

    SSLClientKeyExchange() {
    }

    public int encode(SSLConn sSLConn, OutputStream outputStream) throws IOException {
        switch (sSLConn.hs.cipher_suite.getKeyExchangeAlg()) {
            case 1: {
                DHPublicKey dHPublicKey = (DHPublicKey)sSLConn.hs.peerEncryptionKey;
                DHPrivateKey dHPrivateKey = DHPrivateKey.getInstance();
                SSLHandshake cfr_ignored_0 = sSLConn.hs;
                dHPrivateKey.initPrivateKey(dHPublicKey.getg(), dHPublicKey.getp(), SSLHandshake.rng);
                this.client_data.value = dHPrivateKey.getYBytes();
                sSLConn.hs.pre_master_secret = dHPrivateKey.keyAgree(dHPublicKey, true);
                return this.client_data.encode(sSLConn, outputStream);
            }
            case 2: {
                try {
                    sSLConn.hs.pre_master_secret = new byte[48];
                    SSLHandshake cfr_ignored_1 = sSLConn.hs;
                    SSLHandshake.rng.nextBytes(sSLConn.hs.pre_master_secret);
                    sSLConn.hs.pre_master_secret[0] = 3;
                    sSLConn.hs.pre_master_secret[1] = (byte)(sSLConn.max_ssl_version & 0xFF);
                    Cipher cipher = Cipher.getInstance((String)"RSA", (String)"Cryptix");
                    if (sSLConn.hs.peerEncryptionKey == null) {
                        sSLConn.hs.peerEncryptionKey = sSLConn.hs.peerSignatureKey;
                    }
                    cipher.initEncrypt((Key)sSLConn.hs.peerEncryptionKey);
                    SSLHandshake cfr_ignored_2 = sSLConn.hs;
                    byte[] byArray = PKCS1Pad.pkcs1PadBuf(SSLHandshake.rng, sSLConn.hs.pre_master_secret, sSLConn.hs.peerEncryptionKey);
                    SSLDebug.debug(8, "RSA input", byArray);
                    byte[] byArray2 = cipher.crypt(byArray);
                    this.client_data.value = byArray2;
                    SSLDebug.debug(8, "PreMasterSecret", sSLConn.hs.pre_master_secret);
                    SSLDebug.debug(8, "EncryptedPreMasterSecret", byArray2);
                    if (sSLConn.ssl_version >= 769) {
                        return this.client_data.encode(sSLConn, outputStream);
                    }
                    outputStream.write(byArray2);
                    return byArray2.length;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    throw new InternalError(exception.toString());
                }
            }
        }
        throw new InternalError("Inconsistent algorithm");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int decode(SSLConn sSLConn, InputStream inputStream) throws IOException {
        switch (sSLConn.hs.cipher_suite.getKeyExchangeAlg()) {
            case 1: {
                int n = this.client_data.decode(sSLConn, inputStream);
                sSLConn.hs.peerEncryptionKey = new DHPublicKey(new BigInteger(1, this.client_data.value));
                sSLConn.hs.pre_master_secret = sSLConn.hs.dhEphemeral.keyAgree((DHPublicKey)sSLConn.hs.peerEncryptionKey, false);
                return n;
            }
            case 2: {
                byte[] byArray;
                int n;
                if (sSLConn.ssl_version >= 769) {
                    n = this.client_data.decode(sSLConn, inputStream);
                    byArray = this.client_data.value;
                } else {
                    byte[] byArray2 = new byte[512];
                    n = inputStream.read(byArray2);
                    if (n < 0) {
                        throw new SSLException("Short RSA key");
                    }
                    byArray = new byte[n];
                    System.arraycopy(byArray2, 0, byArray, 0, n);
                }
                try {
                    Cipher cipher = Cipher.getInstance((String)"RSABlind", (String)"ClaymoreProvider");
                    PrivateKey privateKey = null;
                    PublicKey publicKey = null;
                    if (sSLConn.hs.rsaEphemeral == null) {
                        privateKey = sSLConn.ctx.getPrivateKey();
                        publicKey = sSLConn.ctx.getPublicKey();
                    } else {
                        privateKey = sSLConn.hs.rsaEphemeral;
                        publicKey = sSLConn.hs.rsaEphemeralPublic;
                    }
                    cipher.initDecrypt((Key)privateKey);
                    ((Blindable)cipher).setBlindingInfo(SSLHandshake.rng, (CryptixRSAPublicKey)publicKey);
                    byte[] byArray3 = cipher.crypt(byArray);
                    sSLConn.hs.pre_master_secret = PKCS1Pad.pkcs1UnpadBuf(byArray3, 1, (CryptixRSAPrivateKey)privateKey);
                    if (sSLConn.hs.pre_master_secret.length != 48) {
                        throw new Exception("Bad PMS length");
                    }
                    SSLDebug.debug(8, "Checking client offered version against RSA block for rollback " + sSLConn.hs.client_offered_version);
                    if (sSLConn.hs.pre_master_secret[0] == (sSLConn.hs.client_offered_version >> 8 & 0xFF) && sSLConn.hs.pre_master_secret[1] == (sSLConn.hs.client_offered_version & 0xFF)) return n;
                    if (sSLConn.hs.pre_master_secret[0] != 3 || sSLConn.hs.pre_master_secret[1] != 0 || sSLConn.hs.client_offered_version != 769 || sSLConn.ssl_version != 768) throw new Exception("Bad PMS version number");
                    SSLDebug.debug(8, "Accepting rollback to SSLv3 from TLS since this is a common SSLv3/TLS bug");
                    return n;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    sSLConn.hs.pre_master_secret = new byte[48];
                    SSLDebug.debug(8, "Bad padding. Randomizing PMS");
                    sSLConn.ctx.rng.nextBytes(sSLConn.hs.pre_master_secret);
                }
                return n;
            }
            default: {
                throw new InternalError("Inconsistent algorithm");
            }
        }
    }
}

