/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.ptls;

import COM.claymoresystems.ptls.ICertificateValidator;
import COM.claymoresystems.ptls.SSLAlert;
import COM.claymoresystems.ptls.SSLAlertException;
import COM.claymoresystems.ptls.SSLAlertX;
import COM.claymoresystems.ptls.SSLCipherState;
import COM.claymoresystems.ptls.SSLContext;
import COM.claymoresystems.ptls.SSLDebug;
import COM.claymoresystems.ptls.SSLException;
import COM.claymoresystems.ptls.SSLHandshake;
import COM.claymoresystems.ptls.SSLHandshakeClient;
import COM.claymoresystems.ptls.SSLHandshakeFailedException;
import COM.claymoresystems.ptls.SSLHandshakeServer;
import COM.claymoresystems.ptls.SSLReHandshakeException;
import COM.claymoresystems.ptls.SSLRecord;
import COM.claymoresystems.ptls.SSLRecordReader;
import COM.claymoresystems.ptls.SSLSocket;
import COM.claymoresystems.ptls.SSLThrewAlertException;
import COM.claymoresystems.sslg.SSLPolicyInt;
import COM.claymoresystems.util.Util;
import cryptix.util.core.ArrayUtil;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.util.Vector;

class SSLConn {
    static final int SSL_CLIENT = 1;
    static final int SSL_SERVER = 2;
    static int debugVal = 0;
    int ssl_version = 0;
    int max_ssl_version = 0;
    SSLContext ctx;
    SSLSocket s = null;
    SSLPolicyInt policy;
    PushbackInputStream sock_in;
    InputStream sock_in_hp;
    InputStream sock_in_data;
    OutputStream _sock_out;
    BufferedOutputStream sock_out;
    OutputStream sock_out_external;
    boolean sentClose = false;
    boolean recvdClose = false;
    Vector peerCertificateChain = null;
    String sessionLookupKey = null;
    int how;
    byte[] session_id;
    SSLCipherState write_cipher_state = null;
    SSLCipherState read_cipher_state = null;
    SSLCipherState next_write_cipher_state;
    SSLCipherState next_read_cipher_state;
    long write_sequence_num;
    long read_sequence_num;
    boolean secureMode = false;
    boolean invalid = false;
    SSLHandshake hs;
    SSLRecordReader reader;
    ICertificateValidator certificateValidator = null;

    SSLConn(SSLSocket sSLSocket, InputStream inputStream, OutputStream outputStream, SSLContext sSLContext, int n) throws IOException {
        this.s = sSLSocket;
        this.how = n;
        this.certificateValidator = sSLContext.getCertificateValidator();
        this.ctx = sSLContext;
        this.policy = sSLContext.getPolicy();
        this.sock_in = new PushbackInputStream(inputStream);
        this._sock_out = outputStream;
        this.sock_out = new BufferedOutputStream(this._sock_out);
        this.reader = new SSLRecordReader(this);
    }

    public ICertificateValidator getCertificateValidator() {
        return this.certificateValidator;
    }

    void renegotiate(SSLPolicyInt sSLPolicyInt) throws IOException {
        this.policy = sSLPolicyInt;
        this.handshake();
    }

    void handshake() throws IOException {
        if (this.read_cipher_state == null) {
            this.max_ssl_version = this.policy.negotiateTLSP() ? 769 : 768;
            this.ssl_version = this.policy.negotiateTLSP() ? 769 : 768;
        }
        this.hs = this.how == 1 ? new SSLHandshakeClient(this) : new SSLHandshakeServer(this);
        try {
            this.hs.handshake();
            if (this.sock_in_hp.available() != 0) {
                this.alert(SSLAlertX.TLS_ALERT_UNEXPECTED_MESSAGE);
            }
            this.secureMode = true;
        }
        catch (IOException iOException) {
            if ((SSLDebug.debugVal & 0x40) > 0) {
                iOException.printStackTrace();
            }
            if (!(iOException instanceof SSLAlertException)) {
                throw new SSLHandshakeFailedException(iOException.toString());
            }
            throw iOException;
        }
    }

    int getCipherSuite() throws IOException {
        if (!this.hs.finishedP()) {
            throw new SSLException("Handshake not finished");
        }
        return this.write_cipher_state.cipher_suite.getValue();
    }

    SSLPolicyInt getPolicy() {
        return this.policy;
    }

    byte[] getSessionID() throws IOException {
        if (!this.hs.finishedP()) {
            throw new SSLException("Handshake not finished");
        }
        return this.session_id;
    }

    int getVersion() throws IOException {
        if (!this.hs.finishedP()) {
            throw new SSLException("Handshake not finished");
        }
        return this.ssl_version;
    }

    Vector getCertificateChain() throws IOException {
        if (!this.hs.finishedP()) {
            throw new SSLException("Handshake not finished");
        }
        return this.peerCertificateChain;
    }

    void alert(int n) throws IOException {
        this.sendAlertNoException(n, true);
        throw new SSLThrewAlertException(new SSLAlertX(this.ssl_version, n, true));
    }

    void sendAlertNoException(int n, boolean bl) throws IOException {
        SSLAlertX sSLAlertX = new SSLAlertX(this.ssl_version, n, bl);
        if (bl) {
            SSLDebug.debug(4, "Throwing a fatal alert, lookup key " + this.sessionLookupKey);
            this.makeUnresumable();
            this.invalid = true;
        }
        SSLAlert sSLAlert = new SSLAlert(sSLAlertX);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        sSLAlert.encode(this, byteArrayOutputStream);
        SSLRecord sSLRecord = new SSLRecord(this, 21, byteArrayOutputStream.toByteArray());
        sSLRecord.send(this);
        this.sock_out.flush();
    }

    boolean processIncomingHandshakeRecord(byte[] byArray) throws IOException {
        byte[] byArray2 = new byte[]{0, 0, 0, 0};
        if (this.hs.finishedP()) {
            switch (byArray[0]) {
                case 0: {
                    if (this.how != 1) {
                        this.alert(SSLAlertX.TLS_ALERT_UNEXPECTED_MESSAGE);
                    }
                    if (!ArrayUtil.areEqual((byte[])byArray, (byte[])byArray2)) {
                        this.alert(SSLAlertX.TLS_ALERT_ILLEGAL_PARAMETER);
                    }
                    throw new SSLReHandshakeException();
                }
                case 1: {
                    if (this.how != 2) {
                        this.alert(SSLAlertX.TLS_ALERT_UNEXPECTED_MESSAGE);
                    }
                    return true;
                }
            }
            this.alert(SSLAlertX.TLS_ALERT_UNEXPECTED_MESSAGE);
        } else if (byArray[0] == 0) {
            this.alert(SSLAlertX.TLS_ALERT_UNEXPECTED_MESSAGE);
        }
        return false;
    }

    static void debug(int n, String string) {
        if ((debugVal & n) > 0) {
            System.out.println(string);
        }
    }

    static void debug(int n, String string, byte[] byArray) {
        if ((debugVal & n) > 0) {
            Util.xdump(string, byArray);
        }
    }

    InputStream getInStream() {
        if (!this.hs.finishedP()) {
            return null;
        }
        if (this.read_cipher_state == null) {
            return null;
        }
        return this.sock_in_data;
    }

    OutputStream getOutStream() {
        if (!this.hs.finishedP()) {
            return null;
        }
        if (this.write_cipher_state == null) {
            return null;
        }
        return this.sock_out_external;
    }

    void makeUnresumable() {
        if (this.sessionLookupKey != null) {
            SSLDebug.debug(4, "Making session " + this.sessionLookupKey + "Unresumable");
            this.ctx.destroySession(this.sessionLookupKey);
        }
    }

    void sendClose() throws IOException {
        if (!this.sentClose) {
            this.sendAlertNoException(SSLAlertX.TLS_ALERT_CLOSE_NOTIFY, false);
            this.sentClose = true;
        }
    }

    void recvClose(boolean bl) throws IOException {
        InputStream inputStream = this.getInStream();
        byte[] byArray = new byte[1024];
        while (inputStream.read(byArray) >= 0) {
            if (!bl) continue;
            throw new SSLException("Excess data in pipe when closed");
        }
    }

    void close() throws IOException {
        try {
            this.sendClose();
            if (this.policy.waitOnCloseP()) {
                this.recvClose(false);
            }
            if (this.s != null) {
                this.s.hardClose();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setDebug(int n) {
        debugVal = n;
    }
}

