/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.ptls;

import COM.claymoresystems.cert.EAYDHParams;
import COM.claymoresystems.cert.WrappedObject;
import COM.claymoresystems.cert.X509Cert;
import COM.claymoresystems.crypto.DHPrivateKey;
import COM.claymoresystems.crypto.EAYEncryptedPrivateKey;
import COM.claymoresystems.crypto.RandomStore;
import COM.claymoresystems.ptls.ICertificateValidator;
import COM.claymoresystems.ptls.LoadProviders;
import COM.claymoresystems.ptls.SSLDebug;
import COM.claymoresystems.ptls.SSLSessionData;
import COM.claymoresystems.sslg.SSLContextInt;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.util.Hashtable;
import java.util.Vector;
import xjava.security.interfaces.CryptixRSAPrivateKey;
import xjava.security.interfaces.CryptixRSAPublicKey;

public class SSLContext
extends SSLContextInt {
    private static final int SEED_BYTES = 128;
    private Hashtable session_cache = new Hashtable();
    Vector root_list = new Vector();
    Vector certificates = null;
    PrivateKey privateKey = null;
    PublicKey publicKey = null;
    private int ephemeralDHKeyLength = 1024;
    DHPrivateKey dhEphemeral = null;
    EAYDHParams dhParams = null;
    KeyPair rsaEphemeral = null;
    SecureRandom rng = null;
    private boolean sophieGermain = false;
    private ICertificateValidator certificateValidator = null;

    public ICertificateValidator getCertificateValidator() {
        return this.certificateValidator;
    }

    public void setCertificateValidator(ICertificateValidator iCertificateValidator) {
        this.certificateValidator = iCertificateValidator;
    }

    public void seedRNG(byte[] byArray) {
        if (byArray == null) {
            byArray = new byte[]{};
        }
        if (this.rng == null) {
            this.rng = new SecureRandom(byArray);
        } else {
            this.rng.setSeed(byArray);
        }
        this.rng.setSeed(System.currentTimeMillis());
    }

    public void useRandomnessFile(String string, String string2) throws IOException, FileNotFoundException {
        this.rng = null;
        try {
            this.rng = RandomStore.readRandomStore(string, string2.getBytes());
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        if (this.rng == null) {
            this.rng = new SecureRandom();
            RandomStore.writeRandomStore(string, string2.getBytes(), this.rng);
        }
    }

    public void loadPKCS12File(String string, String string2) {
        throw new InternalError("Not implemented");
    }

    public void loadEAYKeyFile(String string, String string2) throws FileNotFoundException, IOException {
        FileInputStream fileInputStream = new FileInputStream(string);
        this.loadEAYKeyFile(fileInputStream, string2);
    }

    public void loadEAYKeyFile(InputStream inputStream, String string) throws IOException {
        Object object;
        PrivateKey privateKey;
        int n;
        byte[] byArray = new byte[1024];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = inputStream.read(byArray)) > 0) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(byteArrayInputStream));
        StringBuffer stringBuffer = new StringBuffer();
        SSLDebug.debug(16, "Loading key file");
        if (!WrappedObject.findObject(bufferedReader, "PRIVATE KEY", stringBuffer)) {
            throw new IOException("Couldn't find private key in this file");
        }
        try {
            privateKey = EAYEncryptedPrivateKey.createPrivateKey(bufferedReader, stringBuffer.toString(), string.getBytes());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException(illegalArgumentException.toString());
        }
        byteArrayInputStream = new ByteArrayInputStream(byArray2);
        bufferedReader = new BufferedReader(new InputStreamReader(byteArrayInputStream));
        Vector<byte[]> vector = new Vector<byte[]>();
        while ((object = WrappedObject.loadObject(bufferedReader, "CERTIFICATE", null)) != null) {
            SSLDebug.debug(16, "Loading certificate", (byte[])object);
            vector.insertElementAt((byte[])object, 0);
        }
        if (vector.size() == 0) {
            throw new IOException("Need at least one certificate");
        }
        object = new X509Cert((byte[])vector.elementAt(0));
        this.publicKey = ((X509Cert)object).getPublicKey();
        this.privateKey = privateKey;
        this.certificates = vector;
    }

    public void saveEAYKeyFile(String string, String string2) throws IOException, FileNotFoundException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream);
        BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
        EAYEncryptedPrivateKey.writePrivateKey(this.privateKey, string2.getBytes(), bufferedWriter);
        for (int i = 1; i <= this.certificates.size(); ++i) {
            byte[] byArray = (byte[])this.certificates.elementAt(this.certificates.size() - i);
            WrappedObject.writeHeader("CERTIFICATE", bufferedWriter);
            WrappedObject.writeObject(byArray, "CERTIFICATE", bufferedWriter);
        }
        bufferedWriter.flush();
        fileOutputStream.close();
    }

    public void loadRootCertificates(String string) throws FileNotFoundException, IOException {
        FileInputStream fileInputStream = new FileInputStream(string);
        this.loadRootCertificates(fileInputStream);
        fileInputStream.close();
    }

    public void loadRootCertificates(InputStream inputStream) throws IOException {
        byte[] byArray;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        while ((byArray = WrappedObject.loadObject(bufferedReader, "CERTIFICATE", null)) != null) {
            SSLDebug.debug(16, "Loading root", byArray);
            this.root_list.addElement(byArray);
        }
    }

    public void loadDHParams(String string) throws FileNotFoundException, IOException {
        FileInputStream fileInputStream = new FileInputStream(string);
        this.loadDHParams(fileInputStream);
        fileInputStream.close();
    }

    public void loadDHParams(InputStream inputStream) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        byte[] byArray = WrappedObject.loadObject(bufferedReader, "DH PARAMETERS", null);
        if (byArray == null) {
            return;
        }
        SSLDebug.debug(16, "Loading DH params", byArray);
        this.dhParams = new EAYDHParams(byArray);
    }

    public void saveDHParams(String string, int n, boolean bl) throws IOException, FileNotFoundException {
        DHPrivateKey dHPrivateKey = this.getEphemeralDHPrivateKey(n, bl, true);
        EAYDHParams eAYDHParams = new EAYDHParams(dHPrivateKey.getg(), dHPrivateKey.getp());
        byte[] byArray = eAYDHParams.getEncoded();
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream);
        BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
        WrappedObject.writeHeader("DH PARAMETERS", bufferedWriter);
        WrappedObject.writeObject(byArray, "DH PARAMETERS", bufferedWriter);
        bufferedWriter.flush();
        outputStreamWriter.flush();
        fileOutputStream.close();
    }

    Vector getRootList() {
        return this.root_list;
    }

    Vector getCertificateChain() {
        return this.certificates;
    }

    PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    PublicKey getPublicKey() {
        return this.publicKey;
    }

    DHPrivateKey getEphemeralDHPrivateKey(boolean bl) throws IOException {
        if (this.dhParams == null) {
            throw new IOException("Must install DH parameters");
        }
        return this.getEphemeralDHPrivateKey(this.ephemeralDHKeyLength, this.sophieGermain, bl);
    }

    private synchronized DHPrivateKey getEphemeralDHPrivateKey(int n, boolean bl, boolean bl2) {
        this.seedRNG();
        if (this.dhEphemeral == null || bl2) {
            this.dhEphemeral = DHPrivateKey.getInstance();
            if (this.dhParams == null) {
                throw new InternalError("Can't generate ephemeral key without setting DH params");
            }
            this.dhEphemeral.initPrivateKey(this.dhParams.getG(), this.dhParams.getP(), this.rng);
        }
        return this.dhEphemeral;
    }

    private synchronized KeyPair getEphemeralRSAPair() {
        this.seedRNG();
        if (this.rsaEphemeral == null) {
            try {
                KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", "BC");
                keyPairGenerator.initialize(512, this.rng);
                this.rsaEphemeral = keyPairGenerator.generateKeyPair();
            }
            catch (Exception exception) {
                throw new InternalError(exception.toString());
            }
        }
        return this.rsaEphemeral;
    }

    synchronized CryptixRSAPrivateKey getEphemeralRSAPrivateKey() {
        return (CryptixRSAPrivateKey)this.getEphemeralRSAPair().getPrivate();
    }

    synchronized CryptixRSAPublicKey getEphemeralRSAPublicKey() {
        return (CryptixRSAPublicKey)this.getEphemeralRSAPair().getPublic();
    }

    synchronized byte[] getSeedBytes() {
        byte[] byArray = new byte[128];
        this.seedRNG();
        this.rng.nextBytes(byArray);
        return byArray;
    }

    protected synchronized void storeSession(String string, SSLSessionData sSLSessionData) {
        SSLDebug.debug(4, "Storing session under key" + string);
        this.session_cache.put(string, sSLSessionData);
    }

    protected synchronized SSLSessionData findSession(String string) {
        SSLDebug.debug(4, "Trying to recover session using key" + string);
        Object v = this.session_cache.get(string);
        if (v == null) {
            return null;
        }
        return (SSLSessionData)v;
    }

    protected synchronized void destroySession(String string) {
        SSLDebug.debug(4, "Destroying session" + string);
        this.session_cache.remove(string);
    }

    private void seedRNG() {
        if (this.rng != null) {
            return;
        }
        this.rng = new SecureRandom();
    }

    static {
        LoadProviders.init();
    }
}

