/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.ptls;

import COM.claymoresystems.ptls.SSLAlertX;
import COM.claymoresystems.ptls.SSLCipherState;
import COM.claymoresystems.ptls.SSLCipherSuite;
import COM.claymoresystems.ptls.SSLConn;
import COM.claymoresystems.ptls.SSLDebug;
import COM.claymoresystems.ptls.SSLMAC;
import COM.claymoresystems.ptls.SSLPDU;
import COM.claymoresystems.ptls.SSLopaque;
import COM.claymoresystems.ptls.SSLuint16;
import COM.claymoresystems.ptls.SSLuint8;
import COM.claymoresystems.util.Bench;
import cryptix.util.core.ArrayUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class SSLRecord
extends SSLPDU {
    SSLuint8 type = new SSLuint8();
    SSLuint16 version = new SSLuint16();
    SSLopaque data = new SSLopaque(-65535);
    public static final int SSL_CT_CHANGE_CIPHER_SPEC = 20;
    public static final int SSL_CT_ALERT = 21;
    public static final int SSL_CT_HANDSHAKE = 22;
    public static final int SSL_CT_APPLICATION_DATA = 23;

    public SSLRecord(SSLConn sSLConn, int n, byte[] byArray) {
        this.type.value = n;
        this.version.value = sSLConn.ssl_version;
        this.data.value = byArray;
    }

    public SSLRecord(SSLConn sSLConn) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int encode(SSLConn sSLConn, OutputStream outputStream) throws Error, IOException {
        int n = 0;
        SSLConn sSLConn2 = sSLConn;
        synchronized (sSLConn2) {
            Bench.start(1);
            n = this.type.encode(sSLConn, outputStream);
            n += this.version.encode(sSLConn, outputStream);
            if (sSLConn.write_cipher_state != null) {
                int n2 = this.data.value.length;
                int n3 = 0;
                SSLDebug.debug(8, "Encoding record");
                SSLCipherSuite sSLCipherSuite = sSLConn.write_cipher_state.cipher_suite;
                n2 += sSLCipherSuite.getDigestOutputLength();
                SSLDebug.debug(8, "Encrypting: plain text", this.data.value);
                if (sSLCipherSuite.blockCipherP()) {
                    if ((n3 = 8 - ++n2 % 8) == 8) {
                        n3 = 0;
                    }
                    n2 += n3;
                }
                Bench.start(5);
                byte[] byArray = this.calcMac(sSLConn, sSLConn.write_cipher_state, sSLConn.write_sequence_num++, this.data.value);
                Bench.end(5);
                SSLDebug.debug(8, "Encoding MAC", byArray);
                byte[] byArray2 = new byte[n2];
                Bench.start(6);
                System.arraycopy(this.data.value, 0, byArray2, 0, this.data.value.length);
                System.arraycopy(byArray, 0, byArray2, this.data.value.length, byArray.length);
                if (sSLCipherSuite.blockCipherP()) {
                    for (int i = 0; i < n3 + 1; ++i) {
                        byArray2[i + byArray.length + this.data.value.length] = (byte)n3;
                    }
                }
                Bench.end(6);
                Bench.start(3);
                this.data.value = sSLConn.write_cipher_state.cipher != null ? sSLConn.write_cipher_state.cipher.update(byArray2) : byArray2;
                Bench.end(3);
                SSLDebug.debug(8, "Encrypting: cipher text", this.data.value);
            }
            Bench.end(1);
        }
        return n += this.data.encode(sSLConn, outputStream);
    }

    public int decode(SSLConn sSLConn, InputStream inputStream) throws IOException, Error {
        int n = 0;
        SSLopaque sSLopaque = new SSLopaque(-65535);
        boolean bl = false;
        try {
            n = this.type.decode(sSLConn, inputStream);
            n += this.version.decode(sSLConn, inputStream);
            n += sSLopaque.decode(sSLConn, inputStream);
            if (sSLConn.read_cipher_state != null) {
                int n2;
                SSLCipherSuite sSLCipherSuite = sSLConn.read_cipher_state.cipher_suite;
                SSLDebug.debug(8, "Ciphertext", sSLopaque.value);
                byte[] byArray = sSLConn.read_cipher_state.cipher != null ? sSLConn.read_cipher_state.cipher.update(sSLopaque.value) : sSLopaque.value;
                SSLDebug.debug(8, "Plaintext", byArray);
                if (sSLCipherSuite.blockCipherP()) {
                    n2 = byArray.length;
                    int n3 = byArray[n2 - 1] & 0xFF;
                    if (n3 > n2) {
                        SSLDebug.debug(8, "Pad longer than plaintext");
                        n3 = 0;
                        bl = true;
                    }
                    if (sSLConn.ssl_version >= 769) {
                        int n4 = n2 - 2;
                        for (int i = 0; i < n3; ++i) {
                            int n5 = byArray[n4] & 0xFF;
                            if (n5 != n3) {
                                SSLDebug.debug(8, "Some pad bytes don't match");
                                n3 = 0;
                                bl = true;
                            }
                            --n4;
                        }
                    }
                    if (sSLConn.ssl_version == 768 && n3 > 8) {
                        SSLDebug.debug(8, "Pad too long");
                        n3 = 0;
                        bl = true;
                    }
                    n2 -= n3 + 1;
                } else {
                    n2 = byArray.length;
                }
                int n6 = sSLConn.read_cipher_state.cipher_suite.getDigestOutputLength();
                if (n2 < n6) {
                    SSLDebug.debug(8, "MAC too long for record--garbage");
                    bl = true;
                }
                byte[] byArray2 = new byte[n2 - n6];
                System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
                byte[] byArray3 = this.calcMac(sSLConn, sSLConn.read_cipher_state, sSLConn.read_sequence_num++, byArray2);
                SSLDebug.debug(8, "Computed MAC", byArray3);
                if (n6 != byArray3.length) {
                    throw new InternalError("Digest Length inconsistency");
                }
                byte[] byArray4 = new byte[byArray3.length];
                System.arraycopy(byArray, n2 - byArray4.length, byArray4, 0, byArray4.length);
                SSLDebug.debug(8, "Message MAC", byArray4);
                if (!ArrayUtil.areEqual((byte[])byArray4, (byte[])byArray3)) {
                    sSLConn.alert(SSLAlertX.TLS_ALERT_BAD_RECORD_MAC);
                }
                if (bl) {
                    sSLConn.alert(SSLAlertX.TLS_ALERT_BAD_RECORD_MAC);
                }
                if ((n2 -= byArray4.length) != byArray2.length) {
                    throw new InternalError("Sanity check failed");
                }
                this.data.value = new byte[byArray2.length];
                System.arraycopy(byArray2, 0, this.data.value, 0, byArray2.length);
            } else {
                this.data.value = new byte[sSLopaque.value.length];
                System.arraycopy(sSLopaque.value, 0, this.data.value, 0, sSLopaque.value.length);
            }
        }
        catch (IOException iOException) {
            sSLConn.makeUnresumable();
            throw iOException;
        }
        return n;
    }

    public void send(SSLConn sSLConn) throws Error, IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.data.value.length + 30);
        this.encode(sSLConn, byteArrayOutputStream);
        byteArrayOutputStream.writeTo(sSLConn.sock_out);
        sSLConn.sock_out.flush();
    }

    public byte[] calcMac(SSLConn sSLConn, SSLCipherState sSLCipherState, long l, byte[] byArray) {
        return SSLMAC.calcMAC(sSLConn, sSLCipherState, this.type.value, l, byArray);
    }
}

