/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.ptls;

import COM.claymoresystems.ptls.SSLAlert;
import COM.claymoresystems.ptls.SSLAlertX;
import COM.claymoresystems.ptls.SSLCaughtAlertException;
import COM.claymoresystems.ptls.SSLConn;
import COM.claymoresystems.ptls.SSLDebug;
import COM.claymoresystems.ptls.SSLInputStream;
import COM.claymoresystems.ptls.SSLReHandshakeException;
import COM.claymoresystems.ptls.SSLRecord;
import java.io.ByteArrayInputStream;
import java.io.IOException;

class SSLRecordReader {
    SSLConn conn;
    SSLInputStream[] streams = new SSLInputStream[]{new SSLInputStream(this), new SSLInputStream(this)};

    public SSLRecordReader(SSLConn sSLConn) {
        this.conn = sSLConn;
        this.conn.sock_in_hp = this.streams[0];
        this.conn.sock_in_data = this.streams[1];
    }

    public int readRecord() throws IOException {
        if (this.conn.recvdClose) {
            return -1;
        }
        SSLRecord sSLRecord = new SSLRecord(this.conn);
        sSLRecord.decode(this.conn, this.conn.sock_in);
        if (this.conn.read_cipher_state != null && this.conn.ssl_version != sSLRecord.version.value) {
            this.conn.alert(SSLAlertX.TLS_ALERT_ILLEGAL_PARAMETER);
        }
        int n = sSLRecord.type.value;
        switch (n) {
            case 20: {
                this.conn.hs.recvChangeCipherSpecs(sSLRecord.data.value);
                break;
            }
            case 21: {
                this.processAlert(sSLRecord.data.value);
                break;
            }
            case 22: {
                boolean bl = this.conn.processIncomingHandshakeRecord(sSLRecord.data.value);
                SSLDebug.debug(1, "Read a new record type: handshake length" + sSLRecord.data.value.length);
                this.streams[0].write(sSLRecord);
                if (!bl) break;
                throw new SSLReHandshakeException();
            }
            case 23: {
                if (!this.conn.secureMode || this.conn.read_cipher_state == null) {
                    this.conn.alert(SSLAlertX.TLS_ALERT_UNEXPECTED_MESSAGE);
                }
                SSLDebug.debug(1, "Read a new record type: data length" + sSLRecord.data.value.length);
                this.streams[1].write(sSLRecord);
                break;
            }
            default: {
                throw new IOException("Bad record type" + n);
            }
        }
        return 0;
    }

    public void processAlert(byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        SSLAlert sSLAlert = new SSLAlert();
        sSLAlert.decode(this.conn, byteArrayInputStream);
        SSLAlertX sSLAlertX = new SSLAlertX(sSLAlert.description.value, sSLAlert.level.value);
        if (sSLAlertX.fatalP()) {
            this.conn.recvdClose = true;
            this.conn.invalid = true;
            this.conn.makeUnresumable();
        }
        if (sSLAlert.description.value != SSLAlertX.TLS_ALERT_CLOSE_NOTIFY) {
            throw new SSLCaughtAlertException(sSLAlertX);
        }
        this.conn.recvdClose = true;
    }
}

