/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.ptls;

import COM.claymoresystems.ptls.SSLConn;
import COM.claymoresystems.ptls.SSLDebug;
import COM.claymoresystems.ptls.SSLPDU;
import COM.claymoresystems.ptls.SSLPrematureCloseException;
import COM.claymoresystems.ptls.SSLuintX;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;

class SSLopaque
extends SSLPDU {
    int length;
    byte[] value;

    public SSLopaque(int n) {
        this.length = n;
    }

    public SSLopaque(int n, byte[] byArray) {
        this.length = n;
        this.value = byArray;
    }

    public int encode(SSLConn sSLConn, OutputStream outputStream) throws Error, IOException {
        int n = 0;
        if (this.length < 0) {
            SSLuintX sSLuintX = new SSLuintX(-this.length, this.value.length);
            SSLDebug.debug(1, "Opaque <" + -1 * this.length + ">" + "length" + this.value.length);
            n = sSLuintX.encode(sSLConn, outputStream);
        } else {
            SSLDebug.debug(1, "Opaque [" + this.length + "]");
            if (this.length != this.value.length) {
                throw new Error("Array length doesn't match opaque size");
            }
        }
        outputStream.write(this.value);
        return n += this.value.length;
    }

    public int decode(SSLConn sSLConn, InputStream inputStream) throws IOException {
        int n;
        int n2 = 0;
        if (this.length < 0) {
            SSLuintX sSLuintX = new SSLuintX(-this.length);
            n2 = sSLuintX.decode(sSLConn, inputStream);
            if (sSLuintX.value > -this.length) {
                throw new IOException("Opaque length " + sSLuintX.value + " > maximum size " + -this.length);
            }
            this.value = new byte[sSLuintX.value];
        } else {
            this.value = new byte[this.length];
        }
        int n3 = 0;
        for (int i = this.value.length; i > 0; i -= n) {
            n = inputStream.read(this.value, n3, i);
            if (n < 0) {
                throw new SSLPrematureCloseException("Short read");
            }
            n3 += n;
        }
        return n2 + this.value.length;
    }

    public void print(SSLConn sSLConn, PrintWriter printWriter) {
        printWriter.print("Opaque ");
        if (this.length < 0) {
            printWriter.print("max (" + -1 * this.length + ")");
        }
        printWriter.println("length " + this.value.length);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

