/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.ptls;

import COM.claymoresystems.ptls.SSLCipherState;
import COM.claymoresystems.ptls.SSLDebug;
import COM.claymoresystems.ptls.SSLMAC;
import COM.claymoresystems.util.Util;
import cryptix.provider.mac.HMAC_MD2;
import cryptix.provider.mac.HMAC_MD5;
import cryptix.provider.mac.HMAC_RIPEMD128;
import cryptix.provider.mac.HMAC_RIPEMD160;
import cryptix.provider.mac.HMAC_SHA1;
import xjava.security.InvalidParameterTypeException;
import xjava.security.NoSuchParameterException;
import xjava.security.Parameterized;

class TLSMAC
extends SSLMAC {
    TLSMAC() {
    }

    public static byte[] calcMAC(SSLCipherState sSLCipherState, int n, int n2, long l, byte[] byArray) {
        HMAC_MD5 hMAC_MD5 = null;
        SSLDebug.debug(8, "MAC Key", sSLCipherState.mac_key);
        if (sSLCipherState.cipher_suite.getDigestAlg().equalsIgnoreCase("MD5")) {
            hMAC_MD5 = new HMAC_MD5();
        }
        if (sSLCipherState.cipher_suite.getDigestAlg().equalsIgnoreCase("SHA1")) {
            hMAC_MD5 = new HMAC_SHA1();
        }
        if (sSLCipherState.cipher_suite.getDigestAlg().equalsIgnoreCase("MD2")) {
            hMAC_MD5 = new HMAC_MD2();
        }
        if (sSLCipherState.cipher_suite.getDigestAlg().equalsIgnoreCase("SHA")) {
            hMAC_MD5 = new HMAC_SHA1();
        }
        if (sSLCipherState.cipher_suite.getDigestAlg().equalsIgnoreCase("RIPEMD128")) {
            hMAC_MD5 = new HMAC_RIPEMD128();
        }
        if (sSLCipherState.cipher_suite.getDigestAlg().equalsIgnoreCase("RIPEMD160")) {
            hMAC_MD5 = new HMAC_RIPEMD160();
        }
        try {
            ((Parameterized)hMAC_MD5).setParameter("key", (Object)sSLCipherState.mac_key);
        }
        catch (NoSuchParameterException noSuchParameterException) {
            noSuchParameterException.printStackTrace();
        }
        catch (InvalidParameterTypeException invalidParameterTypeException) {
            invalidParameterTypeException.printStackTrace();
        }
        byte[] byArray2 = Util.toBytes(l);
        SSLDebug.debug(8, "Sequence", byArray2);
        hMAC_MD5.update(byArray2);
        byte[] byArray3 = new byte[]{(byte)n};
        hMAC_MD5.update(byArray3);
        SSLDebug.debug(8, "Content type", byArray3);
        byArray2 = Util.toBytes(n2, 2);
        SSLDebug.debug(8, "Version", byArray2);
        hMAC_MD5.update(byArray2);
        byArray2 = Util.toBytes(byArray.length, 2);
        SSLDebug.debug(8, "Length", byArray2);
        hMAC_MD5.update(byArray2);
        SSLDebug.debug(8, "Data", byArray);
        hMAC_MD5.update(byArray);
        byArray2 = hMAC_MD5.digest();
        SSLDebug.debug(8, "Computed TLS MAC", byArray2);
        return byArray2;
    }
}

