/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.util;

public class Bench {
    private static int size = 10;
    private static int cur = 0;
    protected static long[] accum = new long[size];
    protected static long[] mark = new long[size];
    protected static String[] names = new String[size];

    public static int register(String string) {
        Bench.names[Bench.cur] = string;
        return cur++;
    }

    public static void clear() {
        for (int i = 0; i < size; ++i) {
            Bench.accum[i] = 0L;
        }
    }

    public static void clear(int n) {
        Bench.accum[n] = 0L;
    }

    public static void start(int n) {
        Bench.mark[n] = System.currentTimeMillis();
    }

    public static void end(int n) {
        long l = System.currentTimeMillis();
        long l2 = l - mark[n];
        int n2 = n;
        accum[n2] = accum[n2] + (l - mark[n]);
    }

    public static long get(int n) {
        return accum[n];
    }

    public static void dump() {
        Bench.dump(true);
    }

    public static void dump(boolean bl) {
        System.out.println("Timing");
        for (int i = 0; i < size; ++i) {
            if (bl && names[i] == null) continue;
            System.out.println(names[i] + "(" + i + "): " + accum[i]);
        }
    }
}

