/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.lang.reflect.Array;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.BigDecimalConverter;
import org.apache.commons.beanutils.converters.BigIntegerConverter;
import org.apache.commons.beanutils.converters.BooleanArrayConverter;
import org.apache.commons.beanutils.converters.BooleanConverter;
import org.apache.commons.beanutils.converters.ByteArrayConverter;
import org.apache.commons.beanutils.converters.ByteConverter;
import org.apache.commons.beanutils.converters.CharacterArrayConverter;
import org.apache.commons.beanutils.converters.CharacterConverter;
import org.apache.commons.beanutils.converters.ClassConverter;
import org.apache.commons.beanutils.converters.DoubleArrayConverter;
import org.apache.commons.beanutils.converters.DoubleConverter;
import org.apache.commons.beanutils.converters.FileConverter;
import org.apache.commons.beanutils.converters.FloatArrayConverter;
import org.apache.commons.beanutils.converters.FloatConverter;
import org.apache.commons.beanutils.converters.IntegerArrayConverter;
import org.apache.commons.beanutils.converters.IntegerConverter;
import org.apache.commons.beanutils.converters.LongArrayConverter;
import org.apache.commons.beanutils.converters.LongConverter;
import org.apache.commons.beanutils.converters.ShortArrayConverter;
import org.apache.commons.beanutils.converters.ShortConverter;
import org.apache.commons.beanutils.converters.SqlDateConverter;
import org.apache.commons.beanutils.converters.SqlTimeConverter;
import org.apache.commons.beanutils.converters.SqlTimestampConverter;
import org.apache.commons.beanutils.converters.StringArrayConverter;
import org.apache.commons.beanutils.converters.StringConverter;
import org.apache.commons.beanutils.converters.URLConverter;
import org.apache.commons.collections.FastHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConvertUtilsBean {
    private FastHashMap converters = new FastHashMap();
    private Log log;
    private Boolean defaultBoolean;
    private Byte defaultByte;
    private Character defaultCharacter;
    private Double defaultDouble;
    private Float defaultFloat;
    private Integer defaultInteger;
    private Long defaultLong;
    private static Short defaultShort = new Short(0);
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;
    static /* synthetic */ Class class$12;
    static /* synthetic */ Class class$13;
    static /* synthetic */ Class class$14;
    static /* synthetic */ Class class$15;
    static /* synthetic */ Class class$16;
    static /* synthetic */ Class class$17;

    protected static ConvertUtilsBean getInstance() {
        return BeanUtilsBean.getInstance().getConvertUtils();
    }

    public ConvertUtilsBean() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.commons.beanutils.ConvertUtils");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.log = LogFactory.getLog(clazz);
        this.defaultBoolean = Boolean.FALSE;
        this.defaultByte = new Byte(0);
        this.defaultCharacter = new Character(' ');
        this.defaultDouble = new Double(0.0);
        this.defaultFloat = new Float(0.0f);
        this.defaultInteger = new Integer(0);
        this.defaultLong = new Long(0L);
        this.converters.setFast(false);
        this.deregister();
        this.converters.setFast(true);
    }

    public boolean getDefaultBoolean() {
        return this.defaultBoolean;
    }

    public void setDefaultBoolean(boolean newDefaultBoolean) {
        this.defaultBoolean = new Boolean(newDefaultBoolean);
        this.register(new BooleanConverter(this.defaultBoolean), Boolean.TYPE);
        BooleanConverter booleanConverter = new BooleanConverter(this.defaultBoolean);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.register(booleanConverter, clazz);
    }

    public byte getDefaultByte() {
        return this.defaultByte;
    }

    public void setDefaultByte(byte newDefaultByte) {
        this.defaultByte = new Byte(newDefaultByte);
        this.register(new ByteConverter(this.defaultByte), Byte.TYPE);
        ByteConverter byteConverter = new ByteConverter(this.defaultByte);
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("java.lang.Byte");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.register(byteConverter, clazz);
    }

    public char getDefaultCharacter() {
        return this.defaultCharacter.charValue();
    }

    public void setDefaultCharacter(char newDefaultCharacter) {
        this.defaultCharacter = new Character(newDefaultCharacter);
        this.register(new CharacterConverter(this.defaultCharacter), Character.TYPE);
        CharacterConverter characterConverter = new CharacterConverter(this.defaultCharacter);
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("java.lang.Character");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.register(characterConverter, clazz);
    }

    public double getDefaultDouble() {
        return this.defaultDouble;
    }

    public void setDefaultDouble(double newDefaultDouble) {
        this.defaultDouble = new Double(newDefaultDouble);
        this.register(new DoubleConverter(this.defaultDouble), Double.TYPE);
        DoubleConverter doubleConverter = new DoubleConverter(this.defaultDouble);
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("java.lang.Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.register(doubleConverter, clazz);
    }

    public float getDefaultFloat() {
        return this.defaultFloat.floatValue();
    }

    public void setDefaultFloat(float newDefaultFloat) {
        this.defaultFloat = new Float(newDefaultFloat);
        this.register(new FloatConverter(this.defaultFloat), Float.TYPE);
        FloatConverter floatConverter = new FloatConverter(this.defaultFloat);
        Class<?> clazz = class$5;
        if (clazz == null) {
            try {
                clazz = class$5 = Class.forName("java.lang.Float");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.register(floatConverter, clazz);
    }

    public int getDefaultInteger() {
        return this.defaultInteger;
    }

    public void setDefaultInteger(int newDefaultInteger) {
        this.defaultInteger = new Integer(newDefaultInteger);
        this.register(new IntegerConverter(this.defaultInteger), Integer.TYPE);
        IntegerConverter integerConverter = new IntegerConverter(this.defaultInteger);
        Class<?> clazz = class$6;
        if (clazz == null) {
            try {
                clazz = class$6 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.register(integerConverter, clazz);
    }

    public long getDefaultLong() {
        return this.defaultLong;
    }

    public void setDefaultLong(long newDefaultLong) {
        this.defaultLong = new Long(newDefaultLong);
        this.register(new LongConverter(this.defaultLong), Long.TYPE);
        LongConverter longConverter = new LongConverter(this.defaultLong);
        Class<?> clazz = class$7;
        if (clazz == null) {
            try {
                clazz = class$7 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.register(longConverter, clazz);
    }

    public short getDefaultShort() {
        return defaultShort;
    }

    public void setDefaultShort(short newDefaultShort) {
        defaultShort = new Short(newDefaultShort);
        this.register(new ShortConverter(defaultShort), Short.TYPE);
        ShortConverter shortConverter = new ShortConverter(defaultShort);
        Class<?> clazz = class$8;
        if (clazz == null) {
            try {
                clazz = class$8 = Class.forName("java.lang.Short");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.register(shortConverter, clazz);
    }

    public String convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value.getClass().isArray()) {
            if (Array.getLength(value) < 1) {
                return null;
            }
            if ((value = Array.get(value, 0)) == null) {
                return null;
            }
            Class<?> clazz = class$9;
            if (clazz == null) {
                try {
                    clazz = class$9 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Converter converter = this.lookup(clazz);
            Class<?> clazz2 = class$9;
            if (clazz2 == null) {
                try {
                    clazz2 = class$9 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (String)converter.convert(clazz2, value);
        }
        Class<?> clazz = class$9;
        if (clazz == null) {
            try {
                clazz = class$9 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Converter converter = this.lookup(clazz);
        Class<?> clazz3 = class$9;
        if (clazz3 == null) {
            try {
                clazz3 = class$9 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (String)converter.convert(clazz3, value);
    }

    public Object convert(String value, Class clazz) {
        Converter converter;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Convert string '" + value + "' to class '" + clazz.getName() + "'");
        }
        if ((converter = this.lookup(clazz)) == null) {
            Class<?> clazz2 = class$9;
            if (clazz2 == null) {
                try {
                    clazz2 = class$9 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            converter = this.lookup(clazz2);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("  Using converter " + converter);
        }
        return converter.convert(clazz, value);
    }

    public Object convert(String[] values, Class clazz) {
        Converter converter;
        Class<?> type = clazz;
        if (clazz.isArray()) {
            type = clazz.getComponentType();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Convert String[" + values.length + "] to class '" + type.getName() + "[]'");
        }
        if ((converter = this.lookup(type)) == null) {
            Class<?> clazz2 = class$9;
            if (clazz2 == null) {
                try {
                    clazz2 = class$9 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            converter = this.lookup(clazz2);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("  Using converter " + converter);
        }
        Object array = Array.newInstance(type, values.length);
        int i = 0;
        while (i < values.length) {
            Array.set(array, i, converter.convert(type, values[i]));
            ++i;
        }
        return array;
    }

    public void deregister() {
        boolean[] booleanArray = new boolean[]{};
        byte[] byteArray = new byte[]{};
        char[] charArray = new char[]{};
        double[] doubleArray = new double[]{};
        float[] floatArray = new float[]{};
        int[] intArray = new int[]{};
        long[] longArray = new long[]{};
        short[] shortArray = new short[]{};
        String[] stringArray = new String[]{};
        this.converters.clear();
        Class<?> clazz = class$10;
        if (clazz == null) {
            try {
                clazz = class$10 = Class.forName("java.math.BigDecimal");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.register(clazz, new BigDecimalConverter());
        Class<?> clazz2 = class$11;
        if (clazz2 == null) {
            try {
                clazz2 = class$11 = Class.forName("java.math.BigInteger");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.register(clazz2, new BigIntegerConverter());
        this.register(Boolean.TYPE, new BooleanConverter(this.defaultBoolean));
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.register(clazz3, new BooleanConverter(this.defaultBoolean));
        this.register(booleanArray.getClass(), new BooleanArrayConverter(booleanArray));
        this.register(Byte.TYPE, new ByteConverter(this.defaultByte));
        Class<?> clazz4 = class$2;
        if (clazz4 == null) {
            try {
                clazz4 = class$2 = Class.forName("java.lang.Byte");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.register(clazz4, new ByteConverter(this.defaultByte));
        this.register(byteArray.getClass(), new ByteArrayConverter(byteArray));
        this.register(Character.TYPE, new CharacterConverter(this.defaultCharacter));
        Class<?> clazz5 = class$3;
        if (clazz5 == null) {
            try {
                clazz5 = class$3 = Class.forName("java.lang.Character");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.register(clazz5, new CharacterConverter(this.defaultCharacter));
        this.register(charArray.getClass(), new CharacterArrayConverter(charArray));
        Class<?> clazz6 = class$12;
        if (clazz6 == null) {
            try {
                clazz6 = class$12 = Class.forName("java.lang.Class");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.register(clazz6, new ClassConverter());
        this.register(Double.TYPE, new DoubleConverter(this.defaultDouble));
        Class<?> clazz7 = class$4;
        if (clazz7 == null) {
            try {
                clazz7 = class$4 = Class.forName("java.lang.Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.register(clazz7, new DoubleConverter(this.defaultDouble));
        this.register(doubleArray.getClass(), new DoubleArrayConverter(doubleArray));
        this.register(Float.TYPE, new FloatConverter(this.defaultFloat));
        Class<?> clazz8 = class$5;
        if (clazz8 == null) {
            try {
                clazz8 = class$5 = Class.forName("java.lang.Float");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.register(clazz8, new FloatConverter(this.defaultFloat));
        this.register(floatArray.getClass(), new FloatArrayConverter(floatArray));
        this.register(Integer.TYPE, new IntegerConverter(this.defaultInteger));
        Class<?> clazz9 = class$6;
        if (clazz9 == null) {
            try {
                clazz9 = class$6 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.register(clazz9, new IntegerConverter(this.defaultInteger));
        this.register(intArray.getClass(), new IntegerArrayConverter(intArray));
        this.register(Long.TYPE, new LongConverter(this.defaultLong));
        Class<?> clazz10 = class$7;
        if (clazz10 == null) {
            try {
                clazz10 = class$7 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.register(clazz10, new LongConverter(this.defaultLong));
        this.register(longArray.getClass(), new LongArrayConverter(longArray));
        this.register(Short.TYPE, new ShortConverter(defaultShort));
        Class<?> clazz11 = class$8;
        if (clazz11 == null) {
            try {
                clazz11 = class$8 = Class.forName("java.lang.Short");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.register(clazz11, new ShortConverter(defaultShort));
        this.register(shortArray.getClass(), new ShortArrayConverter(shortArray));
        Class<?> clazz12 = class$9;
        if (clazz12 == null) {
            try {
                clazz12 = class$9 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.register(clazz12, new StringConverter());
        this.register(stringArray.getClass(), new StringArrayConverter(stringArray));
        Class<?> clazz13 = class$13;
        if (clazz13 == null) {
            try {
                clazz13 = class$13 = Class.forName("java.sql.Date");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.register(clazz13, new SqlDateConverter());
        Class<?> clazz14 = class$14;
        if (clazz14 == null) {
            try {
                clazz14 = class$14 = Class.forName("java.sql.Time");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.register(clazz14, new SqlTimeConverter());
        Class<?> clazz15 = class$15;
        if (clazz15 == null) {
            try {
                clazz15 = class$15 = Class.forName("java.sql.Timestamp");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.register(clazz15, new SqlTimestampConverter());
        Class<?> clazz16 = class$16;
        if (clazz16 == null) {
            try {
                clazz16 = class$16 = Class.forName("java.io.File");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.register(clazz16, new FileConverter());
        Class<?> clazz17 = class$17;
        if (clazz17 == null) {
            try {
                clazz17 = class$17 = Class.forName("java.net.URL");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.register(clazz17, new URLConverter());
    }

    private void register(Class clazz, Converter converter) {
        this.register(converter, clazz);
    }

    public void deregister(Class clazz) {
        this.converters.remove(clazz);
    }

    public Converter lookup(Class clazz) {
        return (Converter)this.converters.get(clazz);
    }

    public void register(Converter converter, Class clazz) {
        this.converters.put(clazz, converter);
    }
}

