/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import com.sun.java.swing.SwingUtilities2;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicToggleButtonUI;
import javax.swing.plaf.metal.MetalUtils;

public class MetalToggleButtonUI
extends BasicToggleButtonUI {
    private static final MetalToggleButtonUI metalToggleButtonUI = new MetalToggleButtonUI();
    protected Color focusColor;
    protected Color selectColor;
    protected Color disabledTextColor;
    private boolean defaults_initialized = false;

    public static ComponentUI createUI(JComponent jComponent) {
        return metalToggleButtonUI;
    }

    public void installDefaults(AbstractButton abstractButton) {
        super.installDefaults(abstractButton);
        if (!this.defaults_initialized) {
            this.focusColor = UIManager.getColor(this.getPropertyPrefix() + "focus");
            this.selectColor = UIManager.getColor(this.getPropertyPrefix() + "select");
            this.disabledTextColor = UIManager.getColor(this.getPropertyPrefix() + "disabledText");
            this.defaults_initialized = true;
        }
    }

    protected void uninstallDefaults(AbstractButton abstractButton) {
        super.uninstallDefaults(abstractButton);
        this.defaults_initialized = false;
    }

    protected Color getSelectColor() {
        return this.selectColor;
    }

    protected Color getDisabledTextColor() {
        return this.disabledTextColor;
    }

    protected Color getFocusColor() {
        return this.focusColor;
    }

    public void update(Graphics graphics, JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        if (jComponent.getBackground() instanceof UIResource && abstractButton.isContentAreaFilled() && jComponent.isEnabled()) {
            ButtonModel buttonModel = abstractButton.getModel();
            if (!MetalUtils.isToolBarButton(jComponent)) {
                if (!buttonModel.isArmed() && !buttonModel.isPressed() && MetalUtils.drawGradient(jComponent, graphics, "ToggleButton.gradient", 0, 0, jComponent.getWidth(), jComponent.getHeight(), true)) {
                    this.paint(graphics, jComponent);
                    return;
                }
            } else if ((buttonModel.isRollover() || buttonModel.isSelected()) && MetalUtils.drawGradient(jComponent, graphics, "ToggleButton.gradient", 0, 0, jComponent.getWidth(), jComponent.getHeight(), true)) {
                this.paint(graphics, jComponent);
                return;
            }
        }
        super.update(graphics, jComponent);
    }

    protected void paintButtonPressed(Graphics graphics, AbstractButton abstractButton) {
        if (abstractButton.isContentAreaFilled()) {
            graphics.setColor(this.getSelectColor());
            graphics.fillRect(0, 0, abstractButton.getWidth(), abstractButton.getHeight());
        }
    }

    protected void paintText(Graphics graphics, JComponent jComponent, Rectangle rectangle, String string) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        ButtonModel buttonModel = abstractButton.getModel();
        FontMetrics fontMetrics = SwingUtilities2.getFontMetrics(abstractButton, graphics);
        int n = abstractButton.getDisplayedMnemonicIndex();
        if (buttonModel.isEnabled()) {
            graphics.setColor(abstractButton.getForeground());
        } else if (buttonModel.isSelected()) {
            graphics.setColor(jComponent.getBackground());
        } else {
            graphics.setColor(this.getDisabledTextColor());
        }
        SwingUtilities2.drawStringUnderlineCharAt(jComponent, graphics, string, n, rectangle.x, rectangle.y + fontMetrics.getAscent());
    }

    protected void paintFocus(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        boolean bl;
        Rectangle rectangle4 = new Rectangle();
        String string = abstractButton.getText();
        boolean bl2 = bl = abstractButton.getIcon() != null;
        if (string != null && !string.equals("")) {
            if (!bl) {
                rectangle4.setBounds(rectangle2);
            } else {
                rectangle4.setBounds(rectangle3.union(rectangle2));
            }
        } else if (bl) {
            rectangle4.setBounds(rectangle3);
        }
        graphics.setColor(this.getFocusColor());
        graphics.drawRect(rectangle4.x - 1, rectangle4.y - 1, rectangle4.width + 1, rectangle4.height + 1);
    }

    protected void paintIcon(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle) {
        super.paintIcon(graphics, abstractButton, rectangle);
    }
}

