/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Component;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.X11.ComponentAccessor;
import sun.awt.X11.IXAnyEvent;
import sun.awt.X11.WindowDimensions;
import sun.awt.X11.XConstants;
import sun.awt.X11.XCreateWindowParams;
import sun.awt.X11.XDecoratedPeer;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWindow;

public class XContentWindow
extends XWindow
implements XConstants {
    private static Logger insLog = Logger.getLogger("sun.awt.X11.insets.XContentWindow");
    XDecoratedPeer parentFrame;

    XContentWindow(XDecoratedPeer xDecoratedPeer, Rectangle rectangle) {
        super((Component)xDecoratedPeer.getTarget(), xDecoratedPeer.getShell(), rectangle);
        this.parentFrame = xDecoratedPeer;
    }

    void preInit(XCreateWindowParams xCreateWindowParams) {
        super.preInit(xCreateWindowParams);
        xCreateWindowParams.putIfNull((Object)"bit gravity", new Integer(1));
    }

    void initialize() {
        this.xSetVisible(true);
    }

    protected String getWMName() {
        return "Content window";
    }

    protected boolean isEventDisabled(IXAnyEvent iXAnyEvent) {
        switch (iXAnyEvent.get_type()) {
            case 7: 
            case 8: {
                return false;
            }
            case 22: {
                return true;
            }
            case 18: 
            case 19: {
                return true;
            }
        }
        return super.isEventDisabled(iXAnyEvent) || this.parentFrame.isEventDisabled(iXAnyEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setContentBounds(WindowDimensions windowDimensions) {
        XToolkit.awtLock();
        try {
            Rectangle rectangle = windowDimensions.getBounds();
            Insets insets = windowDimensions.getInsets();
            if (insets != null) {
                rectangle.setLocation(-insets.left, -insets.top);
            }
            if (insLog.isLoggable(Level.FINE)) {
                insLog.fine("Setting content bounds " + rectangle);
            }
            boolean bl = !rectangle.getSize().equals(this.getSize());
            this.reshape(rectangle);
            if (bl) {
                this.handleResize(rectangle);
            }
        }
        finally {
            XToolkit.awtUnlock();
        }
        this.validateSurface();
    }

    public void handleResize(Rectangle rectangle) {
        ComponentAccessor.setWidth(this.target, rectangle.width);
        ComponentAccessor.setHeight(this.target, rectangle.height);
        this.postEvent(new ComponentEvent(this.target, 101));
    }
}

