/*
 * Decompiled with CFR 0.152.
 */
package sun.management;

import java.lang.management.ThreadInfo;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import sun.management.LazyCompositeData;
import sun.management.MappedMXBeanType;
import sun.management.Util;

public class ThreadInfoCompositeData
extends LazyCompositeData {
    private final ThreadInfo threadInfo;
    private static final CompositeType threadInfoCompositeType;
    private static final CompositeType stackTraceElementCompositeType;
    private static final String THREAD_ID = "threadId";
    private static final String THREAD_NAME = "threadName";
    private static final String THREAD_STATE = "threadState";
    private static final String BLOCKED_TIME = "blockedTime";
    private static final String BLOCKED_COUNT = "blockedCount";
    private static final String WAITED_TIME = "waitedTime";
    private static final String WAITED_COUNT = "waitedCount";
    private static final String LOCK_NAME = "lockName";
    private static final String LOCK_OWNER_ID = "lockOwnerId";
    private static final String LOCK_OWNER_NAME = "lockOwnerName";
    private static final String STACK_TRACE = "stackTrace";
    private static final String SUSPENDED = "suspended";
    private static final String IN_NATIVE = "inNative";
    private static final String CLASS_NAME = "className";
    private static final String METHOD_NAME = "methodName";
    private static final String FILE_NAME = "fileName";
    private static final String LINE_NUMBER = "lineNumber";
    private static final String NATIVE_METHOD = "nativeMethod";
    private static final String[] threadInfoItemNames;
    private static final String[] stackTraceElementItemNames;

    private ThreadInfoCompositeData(ThreadInfo threadInfo) {
        this.threadInfo = threadInfo;
    }

    public ThreadInfo getThreadInfo() {
        return this.threadInfo;
    }

    public static CompositeData toCompositeData(ThreadInfo threadInfo) {
        ThreadInfoCompositeData threadInfoCompositeData = new ThreadInfoCompositeData(threadInfo);
        return threadInfoCompositeData.getCompositeData();
    }

    protected CompositeData getCompositeData() {
        StackTraceElement[] stackTraceElementArray = this.threadInfo.getStackTrace();
        CompositeData[] compositeDataArray = new CompositeData[stackTraceElementArray.length];
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            StackTraceElement stackTraceElement = stackTraceElementArray[i];
            Object[] objectArray = new Object[]{stackTraceElement.getClassName(), stackTraceElement.getMethodName(), stackTraceElement.getFileName(), new Integer(stackTraceElement.getLineNumber()), new Boolean(stackTraceElement.isNativeMethod())};
            try {
                compositeDataArray[i] = new CompositeDataSupport(stackTraceElementCompositeType, stackTraceElementItemNames, objectArray);
                continue;
            }
            catch (OpenDataException openDataException) {
                throw Util.newInternalError(openDataException);
            }
        }
        Object[] objectArray = new Object[]{new Long(this.threadInfo.getThreadId()), this.threadInfo.getThreadName(), this.threadInfo.getThreadState().name(), new Long(this.threadInfo.getBlockedTime()), new Long(this.threadInfo.getBlockedCount()), new Long(this.threadInfo.getWaitedTime()), new Long(this.threadInfo.getWaitedCount()), this.threadInfo.getLockName(), new Long(this.threadInfo.getLockOwnerId()), this.threadInfo.getLockOwnerName(), compositeDataArray, new Boolean(this.threadInfo.isSuspended()), new Boolean(this.threadInfo.isInNative())};
        try {
            return new CompositeDataSupport(threadInfoCompositeType, threadInfoItemNames, objectArray);
        }
        catch (OpenDataException openDataException) {
            throw Util.newInternalError(openDataException);
        }
    }

    public static long getThreadId(CompositeData compositeData) {
        return ThreadInfoCompositeData.getLong(compositeData, THREAD_ID);
    }

    public static String getThreadName(CompositeData compositeData) {
        String string = ThreadInfoCompositeData.getString(compositeData, THREAD_NAME);
        if (string == null) {
            throw new IllegalArgumentException("Invalid composite data: Attribute threadName has null value");
        }
        return string;
    }

    public static Thread.State getThreadState(CompositeData compositeData) {
        return Thread.State.valueOf(ThreadInfoCompositeData.getString(compositeData, THREAD_STATE));
    }

    public static long getBlockedTime(CompositeData compositeData) {
        return ThreadInfoCompositeData.getLong(compositeData, BLOCKED_TIME);
    }

    public static long getBlockedCount(CompositeData compositeData) {
        return ThreadInfoCompositeData.getLong(compositeData, BLOCKED_COUNT);
    }

    public static long getWaitedTime(CompositeData compositeData) {
        return ThreadInfoCompositeData.getLong(compositeData, WAITED_TIME);
    }

    public static long getWaitedCount(CompositeData compositeData) {
        return ThreadInfoCompositeData.getLong(compositeData, WAITED_COUNT);
    }

    public static String getLockName(CompositeData compositeData) {
        return ThreadInfoCompositeData.getString(compositeData, LOCK_NAME);
    }

    public static long getLockOwnerId(CompositeData compositeData) {
        return ThreadInfoCompositeData.getLong(compositeData, LOCK_OWNER_ID);
    }

    public static String getLockOwnerName(CompositeData compositeData) {
        return ThreadInfoCompositeData.getString(compositeData, LOCK_OWNER_NAME);
    }

    public static boolean isSuspended(CompositeData compositeData) {
        return ThreadInfoCompositeData.getBoolean(compositeData, SUSPENDED);
    }

    public static boolean isInNative(CompositeData compositeData) {
        return ThreadInfoCompositeData.getBoolean(compositeData, IN_NATIVE);
    }

    public static StackTraceElement[] getStackTrace(CompositeData compositeData) {
        CompositeData[] compositeDataArray = (CompositeData[])compositeData.get(STACK_TRACE);
        StackTraceElement[] stackTraceElementArray = new StackTraceElement[compositeDataArray.length];
        for (int i = 0; i < compositeDataArray.length; ++i) {
            CompositeData compositeData2 = compositeDataArray[i];
            stackTraceElementArray[i] = new StackTraceElement(ThreadInfoCompositeData.getString(compositeData2, CLASS_NAME), ThreadInfoCompositeData.getString(compositeData2, METHOD_NAME), ThreadInfoCompositeData.getString(compositeData2, FILE_NAME), ThreadInfoCompositeData.getInt(compositeData2, LINE_NUMBER));
        }
        return stackTraceElementArray;
    }

    public static void validateCompositeData(CompositeData compositeData) {
        if (compositeData == null) {
            throw new NullPointerException("Null CompositeData");
        }
        if (!ThreadInfoCompositeData.isTypeMatched(threadInfoCompositeType, compositeData.getCompositeType())) {
            throw new IllegalArgumentException("Unexpected composite type for ThreadInfo");
        }
        CompositeData[] compositeDataArray = (CompositeData[])compositeData.get(STACK_TRACE);
        if (compositeDataArray == null) {
            throw new IllegalArgumentException("StackTraceElement is missing");
        }
        if (compositeDataArray.length > 0 && !ThreadInfoCompositeData.isTypeMatched(stackTraceElementCompositeType, compositeDataArray[0].getCompositeType())) {
            throw new IllegalArgumentException("Unexpected composite type for StackTraceElement");
        }
    }

    static {
        try {
            threadInfoCompositeType = (CompositeType)MappedMXBeanType.toOpenType(ThreadInfo.class);
            stackTraceElementCompositeType = (CompositeType)MappedMXBeanType.toOpenType(StackTraceElement.class);
        }
        catch (OpenDataException openDataException) {
            throw Util.newInternalError(openDataException);
        }
        threadInfoItemNames = new String[]{THREAD_ID, THREAD_NAME, THREAD_STATE, BLOCKED_TIME, BLOCKED_COUNT, WAITED_TIME, WAITED_COUNT, LOCK_NAME, LOCK_OWNER_ID, LOCK_OWNER_NAME, STACK_TRACE, SUSPENDED, IN_NATIVE};
        stackTraceElementItemNames = new String[]{CLASS_NAME, METHOD_NAME, FILE_NAME, LINE_NUMBER, NATIVE_METHOD};
    }
}

