/*
 * Decompiled with CFR 0.152.
 */
package socks;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import socks.InetRangeResolver;

public class InetRange
implements Cloneable {
    Hashtable host_names;
    Vector all = new Vector();
    Vector end_names;
    boolean useSeparateThread = true;

    public InetRange() {
        this.host_names = new Hashtable();
        this.end_names = new Vector();
    }

    public synchronized boolean add(String string) {
        if (string == null) {
            return false;
        }
        if ((string = string.trim()).length() == 0) {
            return false;
        }
        if (string.charAt(string.length() - 1) == '.') {
            int[] nArray = InetRange.ip2intarray(string);
            long l = 0L;
            long l2 = 0L;
            if (nArray == null) {
                return false;
            }
            int n = 0;
            while (n < 4) {
                if (nArray[n] < 0) {
                    l = l2;
                    while (n < 4) {
                        l += 255L << 8 * (3 - n++);
                    }
                    break;
                }
                l2 += (long)nArray[n] << 8 * (3 - n);
                ++n;
            }
            Object[] objectArray = new Object[]{string, null, new Long(l2), new Long(l)};
            this.all.addElement(objectArray);
        } else if (string.charAt(0) == '.') {
            this.end_names.addElement(string);
            this.all.addElement(new Object[]{string, null, null, null});
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\r\n\f:");
            if (stringTokenizer.countTokens() > 1) {
                Object[] objectArray = new Object[]{string, null, null, null};
                this.resolve(objectArray, stringTokenizer.nextToken(), stringTokenizer.nextToken());
                this.all.addElement(objectArray);
            } else {
                Object[] objectArray = new Object[]{string, null, null, null};
                this.all.addElement(objectArray);
                this.host_names.put(string, objectArray);
                this.resolve(objectArray);
            }
        }
        return true;
    }

    public synchronized void add(InetAddress inetAddress) {
        long l;
        long l2 = l = InetRange.ip2long(inetAddress);
        this.all.addElement(new Object[]{inetAddress.getHostName(), inetAddress, new Long(l2), new Long(l)});
    }

    public synchronized void add(InetAddress inetAddress, InetAddress inetAddress2) {
        this.all.addElement(new Object[]{String.valueOf(inetAddress.getHostAddress()) + ":" + inetAddress2.getHostAddress(), null, new Long(InetRange.ip2long(inetAddress)), new Long(InetRange.ip2long(inetAddress2))});
    }

    private boolean checkHost(String string) {
        return this.host_names.containsKey(string);
    }

    private boolean checkHostEnding(String string) {
        Enumeration enumeration = this.end_names.elements();
        while (enumeration.hasMoreElements()) {
            if (!string.endsWith((String)enumeration.nextElement())) continue;
            return true;
        }
        return false;
    }

    public Object clone() {
        InetRange inetRange = new InetRange();
        inetRange.all = (Vector)this.all.clone();
        inetRange.end_names = (Vector)this.end_names.clone();
        inetRange.host_names = (Hashtable)this.host_names.clone();
        return inetRange;
    }

    private synchronized boolean contains(long l) {
        Enumeration enumeration = this.all.elements();
        while (enumeration.hasMoreElements()) {
            Long l2;
            Object[] objectArray = (Object[])enumeration.nextElement();
            Long l3 = objectArray[2] == null ? null : (Long)objectArray[2];
            Long l4 = l2 = objectArray[3] == null ? null : (Long)objectArray[3];
            if (l3 == null || l3 > l || l2 < l) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean contains(String string) {
        return this.contains(string, true);
    }

    public synchronized boolean contains(String string, boolean bl) {
        if (this.all.size() == 0) {
            return false;
        }
        if ((string = string.trim()).length() == 0) {
            return false;
        }
        if (this.checkHost(string)) {
            return true;
        }
        if (this.checkHostEnding(string)) {
            return true;
        }
        long l = this.host2long(string);
        if (l >= 0L) {
            return this.contains(l);
        }
        if (!bl) {
            return false;
        }
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            return this.contains(inetAddress);
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
    }

    public synchronized boolean contains(InetAddress inetAddress) {
        if (this.checkHostEnding(inetAddress.getHostName())) {
            return true;
        }
        if (this.checkHost(inetAddress.getHostName())) {
            return true;
        }
        return this.contains(InetRange.ip2long(inetAddress));
    }

    public synchronized String[] getAll() {
        int n = this.all.size();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            Object[] objectArray = (Object[])this.all.elementAt(n2);
            stringArray[n2] = (String)objectArray[0];
            ++n2;
        }
        return stringArray;
    }

    long host2long(String string) {
        long l = 0L;
        if (!Character.isDigit(string.charAt(0))) {
            return -1L;
        }
        int[] nArray = InetRange.ip2intarray(string);
        if (nArray == null) {
            return -1L;
        }
        int n = 0;
        while (n < nArray.length) {
            l += (long)(nArray[n] >= 0 ? nArray[n] : 0) << 8 * (3 - n);
            ++n;
        }
        return l;
    }

    /*
     * Unable to fully structure code
     */
    static int[] ip2intarray(String var0) {
        var1_1 = new int[]{-1, -1, -1, -1};
        var2_2 = 0;
        var3_3 = new StringTokenizer(var0, ".");
        if (var3_3.countTokens() <= 4) ** GOTO lbl11
        return null;
lbl-1000:
        // 1 sources

        {
            try {
                var1_1[var2_2++] = Integer.parseInt(var3_3.nextToken()) & 255;
                continue;
            }
            catch (NumberFormatException v0) {
                return null;
            }
lbl11:
            // 2 sources

            ** while (var3_3.hasMoreTokens())
        }
lbl12:
        // 1 sources

        return var1_1;
    }

    static long ip2long(InetAddress inetAddress) {
        long l = 0L;
        byte[] byArray = inetAddress.getAddress();
        if (byArray.length == 4) {
            int n = 0;
            while (n < 4) {
                l += ((long)byArray[n] & 0xFFL) << 8 * (3 - n);
                ++n;
            }
        } else {
            return 0L;
        }
        return l;
    }

    public synchronized boolean remove(String string) {
        Enumeration enumeration = this.all.elements();
        while (enumeration.hasMoreElements()) {
            Object[] objectArray = (Object[])enumeration.nextElement();
            if (!string.equals(objectArray[0])) continue;
            this.all.removeElement(objectArray);
            this.end_names.removeElement(string);
            this.host_names.remove(string);
            return true;
        }
        return false;
    }

    private void resolve(Object[] objectArray) {
        long l = this.host2long((String)objectArray[0]);
        if (l >= 0L) {
            objectArray[2] = objectArray[3] = new Long(l);
        } else {
            InetRangeResolver inetRangeResolver = new InetRangeResolver(objectArray);
            inetRangeResolver.resolve(this.useSeparateThread);
        }
    }

    private void resolve(Object[] objectArray, String string, String string2) {
        long l;
        long l2 = this.host2long(string);
        if (l2 >= 0L && (l = this.host2long(string2)) >= 0L) {
            objectArray[2] = new Long(l2);
            objectArray[3] = new Long(l);
        } else {
            InetRangeResolver inetRangeResolver = new InetRangeResolver(objectArray, string, string2);
            inetRangeResolver.resolve(this.useSeparateThread);
        }
    }

    public String toString() {
        String[] stringArray = this.getAll();
        if (stringArray.length == 0) {
            return "";
        }
        String string = stringArray[0];
        int n = 1;
        while (n < stringArray.length) {
            string = String.valueOf(string) + "; " + stringArray[n];
            ++n;
        }
        return string;
    }
}

