/*
 * Decompiled with CFR 0.152.
 */
package socks;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import socks.Proxy;
import socks.ProxyMessage;
import socks.SocksException;
import socks.SocksSocket;

public class SocksServerSocket
extends ServerSocket {
    protected Proxy proxy;
    protected String localHost;
    protected InetAddress localIP;
    protected int localPort;
    boolean doing_direct = false;
    InetAddress remoteAddr;

    public SocksServerSocket(String string, int n) throws SocksException, UnknownHostException, IOException {
        this(Proxy.defaultProxy, string, n);
    }

    public SocksServerSocket(InetAddress inetAddress, int n) throws SocksException, IOException {
        this(Proxy.defaultProxy, inetAddress, n);
    }

    public SocksServerSocket(Proxy proxy, String string, int n) throws SocksException, UnknownHostException, IOException {
        super(0);
        if (proxy == null) {
            throw new SocksException(65536);
        }
        this.proxy = proxy.copy();
        if (this.proxy.isDirect(string)) {
            this.remoteAddr = InetAddress.getByName(string);
            this.proxy = null;
            this.doDirect();
        } else {
            this.processReply(this.proxy.bind(string, n));
        }
    }

    public SocksServerSocket(Proxy proxy, InetAddress inetAddress, int n) throws SocksException, IOException {
        super(0);
        if (proxy == null) {
            throw new SocksException(65536);
        }
        this.proxy = proxy.copy();
        if (this.proxy.isDirect(inetAddress)) {
            this.remoteAddr = inetAddress;
            this.doDirect();
        } else {
            this.processReply(this.proxy.bind(inetAddress, n));
        }
    }

    public Socket accept() throws IOException {
        Socket socket;
        if (!this.doing_direct) {
            if (this.proxy == null) {
                return null;
            }
            ProxyMessage proxyMessage = this.proxy.accept();
            socket = proxyMessage.ip == null ? new SocksSocket(proxyMessage.host, proxyMessage.port, this.proxy) : new SocksSocket(proxyMessage.ip, proxyMessage.port, this.proxy);
            this.proxy.proxySocket.setSoTimeout(0);
        } else {
            while (!(socket = super.accept()).getInetAddress().equals(this.remoteAddr)) {
                socket.close();
            }
        }
        this.proxy = null;
        return socket;
    }

    public void close() throws IOException {
        super.close();
        if (this.proxy != null) {
            this.proxy.endSession();
        }
        this.proxy = null;
    }

    private void doDirect() {
        this.doing_direct = true;
        this.localPort = super.getLocalPort();
        this.localIP = super.getInetAddress();
        this.localHost = this.localIP.getHostName();
    }

    public String getHost() {
        return this.localHost;
    }

    public InetAddress getInetAddress() {
        if (this.localIP == null) {
            try {
                this.localIP = InetAddress.getByName(this.localHost);
            }
            catch (UnknownHostException unknownHostException) {
                return null;
            }
        }
        return this.localIP;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    private void processReply(ProxyMessage proxyMessage) throws SocksException {
        this.localPort = proxyMessage.port;
        if (proxyMessage.host.equals("0.0.0.0")) {
            this.localIP = this.proxy.proxyIP;
            this.localHost = this.localIP.getHostName();
        } else {
            this.localHost = proxyMessage.host;
            this.localIP = proxyMessage.ip;
        }
    }

    public void setSoTimeout(int n) throws SocketException {
        super.setSoTimeout(n);
        if (!this.doing_direct) {
            this.proxy.proxySocket.setSoTimeout(n);
        }
    }
}

