/*
 * Decompiled with CFR 0.152.
 */
package socks;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import socks.Proxy;
import socks.ProxyMessage;
import socks.SocksException;

public class SocksSocket
extends Socket {
    protected Proxy proxy;
    protected String localHost;
    protected String remoteHost;
    protected InetAddress localIP;
    protected InetAddress remoteIP;
    protected int localPort;
    protected int remotePort;
    private Socket directSock = null;

    public SocksSocket(String string, int n) throws SocksException, UnknownHostException {
        this(Proxy.defaultProxy, string, n);
    }

    protected SocksSocket(String string, int n, Proxy proxy) {
        this.remotePort = n;
        this.proxy = proxy;
        this.localIP = proxy.proxySocket.getLocalAddress();
        this.localPort = proxy.proxySocket.getLocalPort();
        this.remoteHost = string;
    }

    public SocksSocket(InetAddress inetAddress, int n) throws SocksException {
        this(Proxy.defaultProxy, inetAddress, n);
    }

    protected SocksSocket(InetAddress inetAddress, int n, Proxy proxy) {
        this.remoteIP = inetAddress;
        this.remotePort = n;
        this.proxy = proxy;
        this.localIP = proxy.proxySocket.getLocalAddress();
        this.localPort = proxy.proxySocket.getLocalPort();
        this.remoteHost = this.remoteIP.getHostName();
    }

    public SocksSocket(Proxy proxy, String string, int n) throws SocksException, UnknownHostException {
        if (proxy == null) {
            throw new SocksException(65536);
        }
        this.proxy = proxy.copy();
        this.remoteHost = string;
        this.remotePort = n;
        if (this.proxy.isDirect(string)) {
            this.remoteIP = InetAddress.getByName(string);
            this.doDirect();
        } else {
            this.processReply(this.proxy.connect(string, n));
        }
    }

    public SocksSocket(Proxy proxy, InetAddress inetAddress, int n) throws SocksException {
        if (proxy == null) {
            throw new SocksException(65536);
        }
        this.proxy = proxy.copy();
        this.remoteIP = inetAddress;
        this.remotePort = n;
        this.remoteHost = inetAddress.getHostName();
        if (this.proxy.isDirect(this.remoteIP)) {
            this.doDirect();
        } else {
            this.processReply(this.proxy.connect(inetAddress, n));
        }
    }

    public void close() throws IOException {
        if (this.proxy != null) {
            this.proxy.endSession();
        }
        this.proxy = null;
    }

    private void doDirect() throws SocksException {
        try {
            this.directSock = new Socket(this.remoteIP, this.remotePort);
            this.proxy.out = this.directSock.getOutputStream();
            this.proxy.in = this.directSock.getInputStream();
            this.proxy.proxySocket = this.directSock;
            this.localIP = this.directSock.getLocalAddress();
            this.localPort = this.directSock.getLocalPort();
        }
        catch (IOException iOException) {
            throw new SocksException(458752, "Direct connect failed:" + iOException);
        }
    }

    public String getHost() {
        return this.remoteHost;
    }

    public InetAddress getInetAddress() {
        if (this.remoteIP == null) {
            try {
                this.remoteIP = InetAddress.getByName(this.remoteHost);
            }
            catch (UnknownHostException unknownHostException) {
                return null;
            }
        }
        return this.remoteIP;
    }

    public InputStream getInputStream() {
        return this.proxy.in;
    }

    public InetAddress getLocalAddress() {
        if (this.localIP == null) {
            try {
                this.localIP = InetAddress.getByName(this.localHost);
            }
            catch (UnknownHostException unknownHostException) {
                return null;
            }
        }
        return this.localIP;
    }

    public String getLocalHost() {
        return this.localHost;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public OutputStream getOutputStream() {
        return this.proxy.out;
    }

    public int getPort() {
        return this.remotePort;
    }

    public int getSoLinger(int n) throws SocketException {
        return this.proxy.proxySocket.getSoLinger();
    }

    public int getSoTimeout(int n) throws SocketException {
        return this.proxy.proxySocket.getSoTimeout();
    }

    public boolean getTcpNoDelay() throws SocketException {
        return this.proxy.proxySocket.getTcpNoDelay();
    }

    private void processReply(ProxyMessage proxyMessage) throws SocksException {
        this.localPort = proxyMessage.port;
        if (proxyMessage.host.equals("0.0.0.0")) {
            this.localIP = this.proxy.proxyIP;
            this.localHost = this.localIP.getHostName();
        } else {
            this.localHost = proxyMessage.host;
            this.localIP = proxyMessage.ip;
        }
    }

    public void setSoLinger(boolean bl, int n) throws SocketException {
        this.proxy.proxySocket.setSoLinger(bl, n);
    }

    public void setSoTimeout(int n) throws SocketException {
        this.proxy.proxySocket.setSoTimeout(n);
    }

    public void setTcpNoDelay(boolean bl) throws SocketException {
        this.proxy.proxySocket.setTcpNoDelay(bl);
    }

    public String toString() {
        if (this.directSock != null) {
            return "Direct connection:" + this.directSock;
        }
        return "Proxy:" + this.proxy + ";" + "addr:" + this.remoteHost + ",port:" + this.remotePort + ",localport:" + this.localPort;
    }
}

