
#include <xmlrpc.h>
#include <xmlrpc_abyss.h>
#include <stdio.h>
#include <stdlib.h>

#include <sys/types.h>
#include <unistd.h>

static xmlrpc_value *
authenticate (xmlrpc_env * const env,
	      xmlrpc_value * const param_array, void * const user_data)
{

  char *user = NULL, *password = NULL;
  xmlrpc_int32 authenticated=0;
  pid_t mypid;
  mypid=getpid();

  printf ("server[%d]: authenticate called.\n", mypid);
  
  // sleep(30);

 
  // Parse our argument array. 
  xmlrpc_parse_value (env, param_array, "(ss)", &user, &password);
  if (env->fault_occurred)
    return NULL;

  // Log values 
  printf("auth: got: user=\"%s\", password=\"%s\" \n", user, password);
 
  authenticated = 0;


  /* Return our result. */
  return xmlrpc_build_value (env, "i", authenticated);

}


static xmlrpc_value *
account (xmlrpc_env * const env,
         xmlrpc_value * const param_array, void * const user_data)
{

  char *user = NULL, *service = NULL;
  xmlrpc_int32 account_ok=0;
  pid_t mypid;
  mypid=getpid();

  printf ("server[%d]: account called.\n", mypid);
  
  // sleep(30);

 
  // Parse our argument array. 
  xmlrpc_parse_value (env, param_array, "(ss)", &user, &service);
  if (env->fault_occurred)
    return NULL;

  // Log values 
  printf("acct: got: user=\"%s\", service=\"%s\" \n", user, service);
 
  account_ok = 0;


  /* Return our result. */
  return xmlrpc_build_value (env, "i", account_ok);

}


int
main (const int argc, const char *argv[])
{

  if (argc - 1 != 1)
    {
      fprintf (stderr, "You must specify 1 argument:  The Abyss "
	       "configuration file name.  You specified %d.\n", argc - 1);
      exit (1);
    }

  xmlrpc_server_abyss_init (XMLRPC_SERVER_ABYSS_NO_FLAGS, argv[1]);
  xmlrpc_server_abyss_add_method ("authenticate", &authenticate, NULL);
  xmlrpc_server_abyss_add_method ("account", &account, NULL);

  printf ("server: switching to background.\n");
  xmlrpc_server_abyss_run ();

  /* We never reach this point. */
  return 0;
}
