/* PAM to automate Uni-Klu login tasks */

/* 
 * Albrecht Gebhardt <agebhard@uni-klu.ac.at>
 * Copyright: GPL, See COPYING.LIB-2.0
 *
 * Created Sun Jun 16 21:12:20 CEST 2002
 * 
 * Version:
 * $Id: pam_linux_uniklu_passwd.c,v 1.5 2009-01-11 15:38:07 agebhard Exp $
 * 
 * Last Revised on
 * $Date: 2009-01-11 15:38:07 $
 * 
 * Changelog:
 *
 * $Log: pam_linux_uniklu_passwd.c,v $
 * Revision 1.5  2009-01-11 15:38:07  agebhard
 * reduce compiler warnings
 *
 * Revision 1.4  2004/10/28 21:40:47  agebhard
 * working again (debian sarge)
 *
 * Revision 1.3  2002/06/18 13:25:09  agebhard
 * new debugging. still not working on madrake.
 * pam_sm_authenticate fails because it is called before entereing a password!
 *
 * Revision 1.2  2002/06/17 09:57:28  agebhard
 * more cvs keywords ...
 *
 * 
 */

#define PAM_SM_PASSWORD

#include <unistd.h>
#include <syslog.h>
#include <string.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <security/pam_modules.h>
#include "pam_linux_uniklu.h"

PAM_EXTERN int pam_sm_chauthtok(pam_handle_t *pamh, int flags,
				int argc, const char **argv)
{
    const char *procname="pam_sm_chauthtok";

    int		i, retval;
    char	*username=NULL;

#   ifdef DEBUG
    syslog(LOG_DEBUG, "%s",procname);
#   endif

    /* get user name */
    retval = pam_get_user(pamh, (void *) &username, NULL);
    if (retval != PAM_SUCCESS) return(retval);
    
    /* handle arguments */
    for (i=0; i<argc; i++)
	{
#           ifdef DEBUG
	    syslog(LOG_DEBUG, "%s: Argument #%d: '%s'", procname, i, argv[i]);
#           endif
	    /* get uniklu_helper program name (if applicable) */
	    if (strcmp(argv[i], "uniklu_helper_program") == 0)
		{
		    /* next argument is uniklu_helper program name */
		    i++;
		    /* ignored */
		}
	    else
		{
		    /* unknown option! write to syslog! */
		    syslog(LOG_ERR, "%s: Unknown option '%s'", procname,
			   argv[i]);
		}	    
	}
    /* really nothing to do */
    return(PAM_SUCCESS);
}
