/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.ActivityNodeModel;
import com.insightful.miner.MinerApp;
import com.insightful.miner.NodeDialog;
import com.insightful.miner.PredictionPanel;
import com.insightful.miner.SetRolesPanel;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class AdaptiveRegressionDialog
extends NodeDialog {
    private SetRolesPanel setRolesPanel;
    private PredictionPanel predictionPanel;
    private JCheckBox includeInterceptCheckBox;
    private JComboBox weightsComboBox;
    private JTextField maxIterationsTextField;
    private JTextField convergenceToleranceTextField;
    private String maxIterationsDefault = "10";
    private String convergenceToleranceDefault = "0.0001";
    private JRadioButton[] positiveResponseButtons;
    private JRadioButton lastCategoryRadioButton;
    private JRadioButton specifiedCategoryRadioButton;
    private JComboBox specifiedCategoryComboBox;
    private String[] positiveResponseStrings = new String[]{"lastCategory", "specifiedCategory"};
    private int regressionType;
    public static final int REGRESSION = 0;
    public static final int LOGISTIC_REGRESSION = 0;
    public static final int LINEAR_REGRESSION = 1;
    private AbstractAction lastCategoryAction;
    private AbstractAction specifiedCategoryAction;
    private static AdaptiveRegressionDialog instance = null;

    public static AdaptiveRegressionDialog getInstance() {
        if (instance == null) {
            instance = new AdaptiveRegressionDialog();
        }
        return instance;
    }

    private AdaptiveRegressionDialog() {
        this.setSize(475, 500);
        this.setResizable(true);
    }

    public void show(ActivityNodeModel newModel, int regressionType) {
        if (newModel != null) {
            this.regressionType = regressionType;
            if (regressionType == 1) {
                this.setRolesPanel.changeDependentType(XTMetaData.CONTINUOUS_TYPE_ATTRIBUTE_TAG);
            } else {
                this.setRolesPanel.changeDependentType(XTMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG);
            }
            this.show(newModel);
            if (regressionType == 1) {
                this.setTitle(MinerApp.getText("RegressionDialog_linearRegression"));
            } else {
                this.setTitle(MinerApp.getText("RegressionDialog_logisticRegression"));
            }
        }
    }

    public void restoreProperties() {
        super.restoreProperties();
        this.setRolesPanel.restoreProperties(this.getNodeModel());
        this.predictionPanel.restoreProperties(this.getNodeModel(), this.regressionType == 0 ? 1 : 0);
        XTProps props = this.getNodeModel().getXTProps();
        this.includeInterceptCheckBox.setSelected(props.getBoolean("includeIntercept", true));
        XTMetaData metaData = null;
        try {
            metaData = this.getNodeModel().getInputMetaData(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        this.weightsComboBox.removeAllItems();
        Vector columnNames = metaData.getColumnNames();
        if (!columnNames.isEmpty()) {
            columnNames.set(0, "");
            int size = columnNames.size();
            for (int i = 0; i < size; ++i) {
                this.weightsComboBox.addItem(columnNames.get(i));
            }
            String weight = props.getValue("weightedColumn", (String)columnNames.get(0));
            for (int i = 0; i < size; ++i) {
                if (!weight.equals(columnNames.get(i))) continue;
                this.weightsComboBox.setSelectedIndex(i);
            }
        }
        this.maxIterationsTextField.setText(props.getValue("maxIterations", this.maxIterationsDefault));
        this.convergenceToleranceTextField.setText(props.getValue("convergenceTolerance", this.convergenceToleranceDefault));
        String positiveResponseString = props.getValue("probabilityFor", "lastCategory");
        for (int i = 0; i < this.positiveResponseStrings.length; ++i) {
            if (!this.positiveResponseStrings[i].equals(positiveResponseString)) continue;
            this.positiveResponseButtons[i].setSelected(true);
        }
        Vector dependents = metaData.getDataFieldsWithRole(XTMetaData.DEPENDENT_ROLE_ATTRIBUTE_TAG);
        Vector levels = new Vector();
        if (!dependents.isEmpty()) {
            levels = metaData.getCategoricalDataFieldLevels((String)dependents.get(0));
        }
        this.specifiedCategoryComboBox.removeAllItems();
        String specifiedCategoryString = props.getValue("specifiedCategory", "");
        if (!levels.isEmpty()) {
            for (int i = 0; i < levels.size(); ++i) {
                String level = (String)levels.get(i);
                this.specifiedCategoryComboBox.addItem(level);
                if (!specifiedCategoryString.equals(level)) continue;
                this.specifiedCategoryComboBox.setSelectedIndex(i);
            }
        } else {
            this.specifiedCategoryComboBox.addItem(specifiedCategoryString);
        }
    }

    public void saveProperties() throws NodeDialog.DialogException {
        super.saveProperties();
        this.setRolesPanel.saveProperties(this.getNodeModel());
        this.predictionPanel.saveProperties(this.getNodeModel(), this.regressionType == 0 ? 1 : 0);
        XTProps props = this.getNodeModel().getXTProps();
        props.set("includeIntercept", this.includeInterceptCheckBox.isSelected());
        props.set("weightedColumn", (String)this.weightsComboBox.getSelectedItem());
        props.writeToString();
        props.set("maxIterations", this.maxIterationsTextField.getText());
        props.set("convergenceTolerance", this.convergenceToleranceTextField.getText());
        String positiveResponseString = "";
        for (int i = 0; i < this.positiveResponseButtons.length; ++i) {
            if (!this.positiveResponseButtons[i].isSelected()) continue;
            positiveResponseString = this.positiveResponseStrings[i];
        }
        props.set("probabilityFor", positiveResponseString);
        props.set("specifiedCategory", (String)this.specifiedCategoryComboBox.getSelectedItem());
    }

    public void createActions() {
        super.createActions();
        this.lastCategoryAction = new AbstractAction(MinerApp.getText("RegressionDialog_forLastCategory")){

            public void actionPerformed(ActionEvent e) {
                AdaptiveRegressionDialog.this.specifiedCategoryComboBox.setEnabled(false);
            }
        };
        this.specifiedCategoryAction = new AbstractAction(MinerApp.getText("RegressionDialog_forSpecifiedCategory")){

            public void actionPerformed(ActionEvent e) {
                AdaptiveRegressionDialog.this.specifiedCategoryComboBox.setEnabled(true);
            }
        };
    }

    public JPanel createOptionsPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.setRolesPanel = new SetRolesPanel(this.okAction);
        JPanel optionsPanel = new JPanel();
        optionsPanel.setLayout(new BoxLayout(optionsPanel, 0));
        optionsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("RegressionDialog_options")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.includeInterceptCheckBox = new JCheckBox(MinerApp.getText("RegressionDialog_includeIntercept"));
        JLabel contrastTypeLabel = new JLabel(MinerApp.getText("RegressionDialog_weights"));
        this.weightsComboBox = new JComboBox();
        optionsPanel.add(Box.createHorizontalStrut(5));
        optionsPanel.add(this.includeInterceptCheckBox);
        optionsPanel.add(Box.createGlue());
        optionsPanel.add(contrastTypeLabel);
        optionsPanel.add(Box.createHorizontalStrut(4));
        optionsPanel.add(this.weightsComboBox);
        optionsPanel.add(Box.createHorizontalStrut(3));
        panel.add((Component)this.setRolesPanel, "North");
        panel.add((Component)optionsPanel, "Center");
        return panel;
    }

    public JPanel createNodePanel() {
        JPanel optimizationPanel = new JPanel(new GridBagLayout());
        optimizationPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("RegressionDialog_fittingOptions")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        JLabel maxIterationsLabel = new JLabel(MinerApp.getText("RegressionDialog_maximumIterations"));
        this.maxIterationsTextField = new JTextField(10);
        this.maxIterationsTextField.setDocument(new NodeDialog.InputIntegerDoc());
        JLabel convergenceToleranceLabel = new JLabel(MinerApp.getText("RegressionDialog_convergenceTolerance"));
        this.convergenceToleranceTextField = new JTextField(10);
        this.convergenceToleranceTextField.setDocument(new NodeDialog.InputDoubleDoc());
        JLabel positiveResponseLabel = new JLabel(MinerApp.getText("RegressionDialog_positiveResponseIs"));
        ButtonGroup positiveResponseGroup = new ButtonGroup();
        this.positiveResponseButtons = new JRadioButton[2];
        this.lastCategoryRadioButton = new JRadioButton(this.lastCategoryAction);
        this.lastCategoryRadioButton.setSelected(true);
        positiveResponseGroup.add(this.lastCategoryRadioButton);
        this.positiveResponseButtons[0] = this.lastCategoryRadioButton;
        this.specifiedCategoryRadioButton = new JRadioButton(this.specifiedCategoryAction);
        positiveResponseGroup.add(this.specifiedCategoryRadioButton);
        this.positiveResponseButtons[1] = this.specifiedCategoryRadioButton;
        this.specifiedCategoryComboBox = new JComboBox();
        this.specifiedCategoryComboBox.setPreferredSize(this.convergenceToleranceTextField.getPreferredSize());
        this.specifiedCategoryComboBox.setEditable(true);
        this.specifiedCategoryComboBox.setEnabled(false);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 0, 0, 35);
        optimizationPanel.add((Component)maxIterationsLabel, constraints);
        constraints.gridx = 1;
        constraints.insets = new Insets(0, 0, 0, 0);
        optimizationPanel.add((Component)this.maxIterationsTextField, constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.insets = new Insets(0, 0, 0, 35);
        optimizationPanel.add((Component)convergenceToleranceLabel, constraints);
        constraints.gridx = 1;
        constraints.insets = new Insets(0, 0, 0, 0);
        optimizationPanel.add((Component)this.convergenceToleranceTextField, constraints);
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.insets = new Insets(10, 0, 0, 0);
        optimizationPanel.add((Component)positiveResponseLabel, constraints);
        constraints.gridy = 3;
        constraints.insets = new Insets(0, 10, 0, 0);
        optimizationPanel.add((Component)this.lastCategoryRadioButton, constraints);
        constraints.gridy = 4;
        constraints.insets = new Insets(0, 10, 0, 10);
        optimizationPanel.add((Component)this.specifiedCategoryRadioButton, constraints);
        constraints.gridx = 1;
        constraints.insets = new Insets(0, 0, 0, 0);
        optimizationPanel.add((Component)this.specifiedCategoryComboBox, constraints);
        return optimizationPanel;
    }

    public Vector createOtherTabs() {
        Vector<PredictionPanel> panels = new Vector<PredictionPanel>();
        this.predictionPanel = new PredictionPanel();
        panels.add(this.predictionPanel);
        return panels;
    }
}

