/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.cnkjava.CNKObj;
import com.insightful.miner.DataCacheRowBuf;
import com.insightful.miner.EngineMessageHandler;
import com.insightful.miner.EngineNode;
import com.insightful.miner.SortAndShuffle;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Vector;

public class AggregateEngineNode
extends EngineNode {
    public static String AGGREGATE_COLUMNS_ATTRIBUTE_TAG = "aggregateColumns";
    public static String SUMMARY_COLUMNS_ATTRIBUTE_TAG = "summaryColumns";
    public static String SUMMARY_METHOD_ATTRIBUTE_TAG = "summaryMethod";
    public static String INPUT_NAME_ATTRIBUTE_TAG = "inputName";
    public static String SUM_METHOD_ATTRIBUTE_TAG = "sum";
    public static String COUNT_METHOD_ATTRIBUTE_TAG = "count";
    public static String MEAN_METHOD_ATTRIBUTE_TAG = "mean";
    public static String MIN_METHOD_ATTRIBUTE_TAG = "min";
    public static String MAX_METHOD_ATTRIBUTE_TAG = "max";
    public static String STD_DEV_METHOD_ATTRIBUTE_TAG = "stdDev";
    public static String VAR_METHOD_ATTRIBUTE_TAG = "var";
    public static String RANGE_METHOD_ATTRIBUTE_TAG = "range";
    public static String FIRST_METHOD_ATTRIBUTE_TAG = "first";
    public static String LAST_METHOD_ATTRIBUTE_TAG = "last";
    public static String SORT_ATTRIBUTE_TAG = "sort";

    public boolean hasCNKProc() {
        return false;
    }

    public boolean hasDataCacheProc() {
        return true;
    }

    public boolean executeDataCacheProc() throws Exception {
        XTMetaData outputMetaData = new XTMetaData();
        XTMetaData inputMetaData = this.getInputMetaData(0);
        XTProps props = this.getNodeProperties();
        String inputFilename = this.getInputDataCacheFileName(0);
        String outputFilename = this.getOutputDataCacheFileName(0);
        int rowChunkSize = this.getMaxRowsPerBlock();
        boolean nanAtTop = true;
        boolean sortRequired = props.getBoolean(SORT_ATTRIBUTE_TAG, true);
        boolean success = this.aggregateRows(inputMetaData, outputMetaData, props, this, inputFilename, outputFilename, rowChunkSize, nanAtTop, sortRequired, true);
        this.setOutputMetaData(0, outputMetaData);
        return success;
    }

    public boolean aggregateRows(XTMetaData inputMetaData, XTMetaData outputMetaData, XTProps props, EngineNode engineNode, String inputFilename, String outputFilename, int rowChunkSize, boolean nanAtTop, boolean sortRequired, boolean alphabetical) throws Exception {
        int i;
        Vector aggregateColumnNames = this.getAggregateColumnNames(props);
        Vector summaryOutputColumnNames = this.getSummaryColumnNames(props);
        int numAggregates = aggregateColumnNames.size();
        int numSummaries = summaryOutputColumnNames.size();
        int[] aggregateColumns = new int[numAggregates];
        ColumnSummary[] columnSummary = new ColumnSummary[numSummaries];
        for (i = 0; i < numAggregates; ++i) {
            String colName = (String)aggregateColumnNames.get(i);
            aggregateColumns[i] = inputMetaData.nameToOrdinal(colName);
            if (aggregateColumns[i] < 0) {
                throw new RuntimeException("Aggregate Column (" + colName + ") not found in input.");
            }
            this.addAggregateColumnMetaData(outputMetaData, inputMetaData, colName, true);
        }
        for (i = 0; i < numSummaries; ++i) {
            ColumnSummary summaryObject;
            String summaryColumnName = (String)summaryOutputColumnNames.get(i);
            columnSummary[i] = summaryObject = this.getSummaryObject(inputMetaData, props, summaryColumnName);
            if (columnSummary[i].m_inputColNum < 0) {
                throw new RuntimeException("Summary Input Column (" + summaryObject.getInputColumnName() + ") not found in input.");
            }
            this.addSummaryColumnMetaData(outputMetaData, inputMetaData, summaryColumnName, summaryObject, true);
        }
        File unsortedFile = new File(inputFilename);
        File sortedFile = null;
        if (sortRequired) {
            sortedFile = engineNode.createWorkspaceTempFile("aggregate", "tmp");
            sortedFile.deleteOnExit();
        } else {
            sortedFile = unsortedFile;
        }
        String[] sortColumnOrder = new String[numAggregates];
        boolean[] sortAscending = new boolean[numAggregates];
        boolean[] sortNAatTop = new boolean[numAggregates];
        for (int i2 = 0; i2 < numAggregates; ++i2) {
            sortColumnOrder[i2] = (String)aggregateColumnNames.get(i2);
            sortAscending[i2] = true;
            sortNAatTop[i2] = nanAtTop;
        }
        if (sortRequired) {
            boolean success = SortAndShuffle.sort(unsortedFile, sortedFile, inputMetaData, engineNode, rowChunkSize, sortColumnOrder, sortAscending, sortNAatTop, alphabetical, true);
            engineNode.resetProgressIndicator();
            if (!success) {
                return false;
            }
        }
        FileInputStream sortedStream = new FileInputStream(sortedFile);
        BufferedInputStream sortedBuffer = new BufferedInputStream(sortedStream);
        DataInputStream sortedInputStream = new DataInputStream(sortedBuffer);
        FileOutputStream outputStream = new FileOutputStream(outputFilename);
        BufferedOutputStream outputBuffer = new BufferedOutputStream(outputStream);
        DataOutputStream outputOutputStream = new DataOutputStream(outputBuffer);
        DataCacheRowBuf lastRowBuf = new DataCacheRowBuf(inputMetaData);
        DataCacheRowBuf newRowBuf = lastRowBuf.copy();
        DataCacheRowBuf outputRowBuf = new DataCacheRowBuf(outputMetaData);
        long rowCount = inputMetaData.getNumRows();
        long curRow = 0L;
        long outputRowCount = 0L;
        newRowBuf.readRow(sortedInputStream);
        lastRowBuf.copyAllColumns(newRowBuf);
        String origText = (String)EngineMessageHandler.sendMessageToApp("getStatusText", new Object[0]);
        String str = origText + ": Aggregating rows...";
        EngineMessageHandler.sendMessageToApp("setStatusText", new Object[]{str});
        while (true) {
            int i3;
            if (!newRowBuf.isSame(lastRowBuf, aggregateColumns)) {
                for (i3 = 0; i3 < numAggregates; ++i3) {
                    outputRowBuf.copyColumn(i3, aggregateColumns[i3], lastRowBuf);
                }
                for (i3 = 0; i3 < numSummaries; ++i3) {
                    columnSummary[i3].writeSummary(outputRowBuf, numAggregates + i3);
                    columnSummary[i3].reset();
                }
                outputRowBuf.writeRow(outputOutputStream);
                lastRowBuf.copyAllColumns(newRowBuf);
                ++outputRowCount;
            }
            for (i3 = 0; i3 < numSummaries; ++i3) {
                columnSummary[i3].updateSummary(newRowBuf);
            }
            if (curRow >= rowCount - 1L) {
                for (i3 = 0; i3 < numAggregates; ++i3) {
                    outputRowBuf.copyColumn(i3, aggregateColumns[i3], newRowBuf);
                }
                for (i3 = 0; i3 < numSummaries; ++i3) {
                    columnSummary[i3].writeSummary(outputRowBuf, numAggregates + i3);
                    columnSummary[i3].reset();
                }
                break;
            }
            newRowBuf.readRow(sortedInputStream);
            int tempPercentDone = (int)(100.0 * ((double)curRow / (double)rowCount));
            if (!engineNode.updateProgressIndicator(tempPercentDone)) {
                return false;
            }
            ++curRow;
        }
        outputRowBuf.writeRow(outputOutputStream);
        EngineMessageHandler.sendMessageToApp("setStatusText", new Object[]{origText});
        outputMetaData.setNumRows(++outputRowCount);
        outputOutputStream.close();
        sortedInputStream.close();
        if (sortRequired) {
            sortedFile.delete();
        }
        return true;
    }

    private Vector getAggregateColumnNames(XTProps props) {
        Vector aggregateColumnNames = props.getSubProperties(AGGREGATE_COLUMNS_ATTRIBUTE_TAG);
        return aggregateColumnNames;
    }

    private Vector getSummaryColumnNames(XTProps props) {
        Vector summaryOutputColumnNames = props.getSubProperties(SUMMARY_COLUMNS_ATTRIBUTE_TAG);
        return summaryOutputColumnNames;
    }

    private void addAggregateColumnMetaData(XTMetaData outputMetaData, XTMetaData inputMetaData, String outputName, boolean addLevels) {
        if (inputMetaData.isCategoricalColumn(outputName)) {
            Vector levels = !addLevels ? new Vector() : inputMetaData.getCategoricalDataFieldLevels(outputName);
            outputMetaData.appendCategoricalDataField(outputName, levels);
        } else if (inputMetaData.isStringColumn(outputName)) {
            int stringWidth = inputMetaData.getStringDataFieldWidth(outputName);
            outputMetaData.appendStringDataField(outputName, stringWidth);
        } else if (inputMetaData.isDateTimeColumn(outputName)) {
            outputMetaData.appendDateTimeDataField(outputName);
        } else {
            outputMetaData.appendContinousDataField(outputName);
        }
    }

    private void addSummaryColumnMetaData(XTMetaData outputMetaData, XTMetaData inputMetaData, String outputName, ColumnSummary summaryObject, boolean addLevels) {
        String inputName = summaryObject.getInputColumnName();
        if (summaryObject.outputIsFactor()) {
            Vector levels = !addLevels ? new Vector() : inputMetaData.getCategoricalDataFieldLevels(inputName);
            outputMetaData.appendCategoricalDataField(outputName, levels);
        } else if (summaryObject.outputIsString()) {
            int stringWidth = inputMetaData.getStringDataFieldWidth(inputName);
            outputMetaData.appendStringDataField(outputName, stringWidth);
        } else if (summaryObject.outputIsDate()) {
            outputMetaData.appendDateTimeDataField(outputName);
        } else {
            outputMetaData.appendContinousDataField(outputName);
        }
    }

    public ColumnSummary getSummaryObject(XTMetaData inputMetaData, XTProps props, String summaryColumnName) {
        String[] path = new String[]{SUMMARY_COLUMNS_ATTRIBUTE_TAG, summaryColumnName, ""};
        path[2] = INPUT_NAME_ATTRIBUTE_TAG;
        String inputName = props.getValue(path);
        path[2] = SUMMARY_METHOD_ATTRIBUTE_TAG;
        String methodName = props.getValue(path, FIRST_METHOD_ATTRIBUTE_TAG);
        String inputType = inputMetaData.getColumnType(inputName);
        int inputColNum = inputMetaData.nameToOrdinal(inputName);
        ColumnSummary colSum = null;
        colSum = methodName.equals(SUM_METHOD_ATTRIBUTE_TAG) ? new SumColumnSummary() : (methodName.equals(COUNT_METHOD_ATTRIBUTE_TAG) ? new CountColumnSummary() : (methodName.equals(MEAN_METHOD_ATTRIBUTE_TAG) ? new MeanColumnSummary() : (methodName.equals(MIN_METHOD_ATTRIBUTE_TAG) ? (inputType.equals(XTMetaData.DATE_TIME_TYPE_ATTRIBUTE_TAG) ? new DateMinColumnSummary() : new MinColumnSummary()) : (methodName.equals(MAX_METHOD_ATTRIBUTE_TAG) ? (inputType.equals(XTMetaData.DATE_TIME_TYPE_ATTRIBUTE_TAG) ? new DateMaxColumnSummary() : new MaxColumnSummary()) : (methodName.equals(STD_DEV_METHOD_ATTRIBUTE_TAG) ? new StdDevColumnSummary() : (methodName.equals(VAR_METHOD_ATTRIBUTE_TAG) ? new VarColumnSummary() : (methodName.equals(RANGE_METHOD_ATTRIBUTE_TAG) ? new RangeColumnSummary() : (methodName.equals(FIRST_METHOD_ATTRIBUTE_TAG) ? (inputType.equals(XTMetaData.STRING_TYPE_ATTRIBUTE_TAG) ? new StringFirstColumnSummary() : (inputType.equals(XTMetaData.DATE_TIME_TYPE_ATTRIBUTE_TAG) ? new DateFirstColumnSummary() : new FirstColumnSummary())) : (inputType.equals(XTMetaData.STRING_TYPE_ATTRIBUTE_TAG) ? new StringLastColumnSummary() : (inputType.equals(XTMetaData.DATE_TIME_TYPE_ATTRIBUTE_TAG) ? new DateLastColumnSummary() : new LastColumnSummary()))))))))));
        colSum.reset();
        colSum.setColumnInfo(inputName, inputType, inputColNum);
        return colSum;
    }

    public XTMetaData calculateOutputMetaData(int outputNum) {
        XTMetaData inputMetaData = this.getInputMetaData(0);
        XTProps props = this.getNodeProperties();
        Vector aggregateColumnNames = this.getAggregateColumnNames(props);
        Vector summaryOutputColumnNames = this.getSummaryColumnNames(props);
        int numAggregates = aggregateColumnNames.size();
        int numSummaries = summaryOutputColumnNames.size();
        XTMetaData md = null;
        try {
            int i;
            md = new XTMetaData();
            for (i = 0; i < numAggregates; ++i) {
                String colName = (String)aggregateColumnNames.get(i);
                this.addAggregateColumnMetaData(md, inputMetaData, colName, false);
            }
            for (i = 0; i < numSummaries; ++i) {
                String summaryColumnName = (String)summaryOutputColumnNames.get(i);
                ColumnSummary summaryObject = this.getSummaryObject(inputMetaData, props, summaryColumnName);
                this.addSummaryColumnMetaData(md, inputMetaData, summaryColumnName, summaryObject, false);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return md;
    }

    private class DateMaxColumnSummary
    extends ColumnSummary {
        private boolean m_firstTime;
        long m_date;

        private DateMaxColumnSummary() {
            this.m_firstTime = true;
            this.m_date = -1L;
        }

        public void updateSummary(DataCacheRowBuf buf) {
            long dat = buf.getTimeDate(this.m_inputColNum);
            if (!CNKObj.isTimeDateNA(dat) && (this.m_firstTime || dat > this.m_date)) {
                this.m_date = dat;
                this.m_firstTime = false;
            }
        }

        public void reset() {
            super.reset();
            this.m_firstTime = true;
        }

        public void writeSummary(DataCacheRowBuf buf, int outputColNum) {
            buf.setTimeDate(outputColNum, this.m_firstTime ? CNKObj.getTimeDateNA() : this.m_date);
        }

        public boolean outputIsDate() {
            return true;
        }
    }

    private class DateMinColumnSummary
    extends ColumnSummary {
        private boolean m_firstTime;
        long m_date;

        private DateMinColumnSummary() {
            this.m_firstTime = true;
            this.m_date = -1L;
        }

        public void updateSummary(DataCacheRowBuf buf) {
            long dat = buf.getTimeDate(this.m_inputColNum);
            if (!CNKObj.isTimeDateNA(dat) && (this.m_firstTime || dat < this.m_date)) {
                this.m_date = dat;
                this.m_firstTime = false;
            }
        }

        public void reset() {
            super.reset();
            this.m_firstTime = true;
        }

        public void writeSummary(DataCacheRowBuf buf, int outputColNum) {
            buf.setTimeDate(outputColNum, this.m_firstTime ? CNKObj.getTimeDateNA() : this.m_date);
        }

        public boolean outputIsDate() {
            return true;
        }
    }

    private class DateLastColumnSummary
    extends ColumnSummary {
        long m_date;

        private DateLastColumnSummary() {
            this.m_date = -1L;
        }

        public void updateSummary(DataCacheRowBuf buf) {
            this.m_date = buf.getTimeDate(this.m_inputColNum);
        }

        public void writeSummary(DataCacheRowBuf buf, int outputColNum) {
            buf.setTimeDate(outputColNum, this.m_date);
        }

        public boolean outputIsDate() {
            return true;
        }
    }

    private class DateFirstColumnSummary
    extends ColumnSummary {
        long m_date;
        private boolean firstTime;

        private DateFirstColumnSummary() {
            this.m_date = -1L;
            this.firstTime = true;
        }

        public void updateSummary(DataCacheRowBuf buf) {
            if (this.firstTime) {
                this.firstTime = false;
                this.m_date = buf.getTimeDate(this.m_inputColNum);
            }
        }

        public void writeSummary(DataCacheRowBuf buf, int outputColNum) {
            buf.setTimeDate(outputColNum, this.m_date);
        }

        public void reset() {
            super.reset();
            this.firstTime = true;
        }

        public boolean outputIsDate() {
            return true;
        }
    }

    private class StringLastColumnSummary
    extends ColumnSummary {
        String m_str;

        private StringLastColumnSummary() {
            this.m_str = null;
        }

        public void updateSummary(DataCacheRowBuf buf) {
            this.m_str = buf.getString(this.m_inputColNum);
        }

        public void writeSummary(DataCacheRowBuf buf, int outputColNum) {
            buf.setString(outputColNum, this.m_str);
        }

        public boolean outputIsString() {
            return true;
        }
    }

    private class StringFirstColumnSummary
    extends ColumnSummary {
        String m_str;
        private boolean firstTime;

        private StringFirstColumnSummary() {
            this.m_str = null;
            this.firstTime = true;
        }

        public void updateSummary(DataCacheRowBuf buf) {
            if (this.firstTime) {
                this.firstTime = false;
                this.m_str = buf.getString(this.m_inputColNum);
            }
        }

        public void writeSummary(DataCacheRowBuf buf, int outputColNum) {
            buf.setString(outputColNum, this.m_str);
        }

        public void reset() {
            super.reset();
            this.firstTime = true;
        }

        public boolean outputIsString() {
            return true;
        }
    }

    private class LastColumnSummary
    extends ColumnSummary {
        private LastColumnSummary() {
        }

        public void updateSummary(double val) {
            this.value = val;
        }

        public boolean outputIsFactor() {
            return this.m_inputType.equals(XTMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG);
        }

        public boolean outputIsDate() {
            return this.m_inputType.equals(XTMetaData.DATE_TIME_TYPE_ATTRIBUTE_TAG);
        }
    }

    private class FirstColumnSummary
    extends ColumnSummary {
        private boolean firstTime;

        private FirstColumnSummary() {
            this.firstTime = true;
        }

        public void updateSummary(double val) {
            if (this.firstTime) {
                this.firstTime = false;
                this.value = val;
            }
        }

        public void reset() {
            super.reset();
            this.firstTime = true;
        }

        public boolean outputIsFactor() {
            return this.m_inputType.equals(XTMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG);
        }

        public boolean outputIsDate() {
            return this.m_inputType.equals(XTMetaData.DATE_TIME_TYPE_ATTRIBUTE_TAG);
        }
    }

    private class RangeColumnSummary
    extends ColumnSummary {
        private boolean firstTime;
        private double max;

        private RangeColumnSummary() {
            this.firstTime = true;
        }

        public void updateSummary(double val) {
            if (!Double.isNaN(val)) {
                if (this.firstTime) {
                    this.firstTime = false;
                    this.max = val;
                    this.value = val;
                } else if (this.max < val) {
                    this.max = val;
                } else if (this.value > val) {
                    this.value = val;
                }
            }
        }

        public double getValue() {
            if (this.firstTime) {
                return Double.NaN;
            }
            return this.max - this.value;
        }

        public void reset() {
            super.reset();
            this.firstTime = true;
        }
    }

    private class StdDevColumnSummary
    extends VarColumnSummary {
        private StdDevColumnSummary() {
        }

        public double getValue() {
            if (this.firstTime) {
                return Double.NaN;
            }
            return Math.sqrt(super.getValue());
        }
    }

    private class VarColumnSummary
    extends ColumnSummary {
        protected boolean firstTime;
        private double mean;
        private long count;

        private VarColumnSummary() {
            this.firstTime = true;
        }

        public void updateSummary(double val) {
            if (!Double.isNaN(val)) {
                if (this.firstTime) {
                    this.firstTime = false;
                    this.mean = val;
                    this.value = 0.0;
                    this.count = 0L;
                } else {
                    double new_mean = this.mean + (val - this.mean) / (double)(this.count + 1L);
                    double new_stdDevSum = this.value + (val - this.mean) * (val - new_mean);
                    this.mean = new_mean;
                    this.value = new_stdDevSum;
                }
                ++this.count;
            }
        }

        public double getValue() {
            if (Double.isNaN(this.value)) {
                return this.value;
            }
            if (this.count < 2L) {
                return 0.0;
            }
            return this.value / (double)(this.count - 1L);
        }

        public void reset() {
            super.reset();
            this.firstTime = true;
        }
    }

    private class MaxColumnSummary
    extends ColumnSummary {
        private boolean firstTime;

        private MaxColumnSummary() {
            this.firstTime = true;
        }

        public void updateSummary(double val) {
            if (!Double.isNaN(val)) {
                if (this.firstTime) {
                    this.firstTime = false;
                    this.value = val;
                } else if (this.value < val) {
                    this.value = val;
                }
            }
        }

        public void reset() {
            super.reset();
            this.firstTime = true;
        }
    }

    private class MinColumnSummary
    extends ColumnSummary {
        private boolean firstTime;

        private MinColumnSummary() {
            this.firstTime = true;
        }

        public void updateSummary(double val) {
            if (!Double.isNaN(val)) {
                if (this.firstTime) {
                    this.firstTime = false;
                    this.value = val;
                } else if (this.value > val) {
                    this.value = val;
                }
            }
        }

        public void reset() {
            super.reset();
            this.firstTime = true;
        }
    }

    private class MeanColumnSummary
    extends ColumnSummary {
        private boolean firstTime;
        private long count;

        private MeanColumnSummary() {
            this.firstTime = true;
        }

        public void updateSummary(double val) {
            if (!Double.isNaN(val)) {
                if (this.firstTime) {
                    this.firstTime = false;
                    this.value = val;
                    this.count = 1L;
                } else {
                    double new_mean;
                    ++this.count;
                    double mean = this.value;
                    this.value = new_mean = mean + (val - mean) / (double)this.count;
                }
            }
        }

        public void reset() {
            super.reset();
            this.firstTime = true;
            this.count = 0L;
        }
    }

    private class CountColumnSummary
    extends ColumnSummary {
        private CountColumnSummary() {
        }

        public void updateSummary(DataCacheRowBuf buf) {
            this.value = Double.isNaN(this.value) ? 1.0 : (this.value += 1.0);
        }
    }

    private class SumColumnSummary
    extends ColumnSummary {
        private SumColumnSummary() {
        }

        public void updateSummary(double val) {
            if (!Double.isNaN(val)) {
                this.value = Double.isNaN(this.value) ? val : (this.value += val);
            }
        }

        public double getValue() {
            return this.value;
        }
    }

    protected abstract class ColumnSummary {
        protected String m_inputName;
        protected String m_inputType;
        protected int m_inputColNum;
        protected double value = Double.NaN;

        protected ColumnSummary() {
        }

        public void updateSummary(DataCacheRowBuf buf) {
            this.updateSummary(buf.getDouble(this.m_inputColNum));
        }

        public void updateSummary(double val) {
        }

        public void writeSummary(DataCacheRowBuf buf, int outputColNum) {
            buf.setDouble(outputColNum, this.getValue());
        }

        public double getValue() {
            return this.value;
        }

        public void reset() {
            this.value = Double.NaN;
        }

        public void setColumnInfo(String inputName, String inputType, int inputColNum) {
            this.m_inputName = inputName;
            this.m_inputType = inputType;
            this.m_inputColNum = inputColNum;
        }

        public String getInputColumnName() {
            return this.m_inputName;
        }

        public boolean outputIsFactor() {
            return false;
        }

        public boolean outputIsDate() {
            return false;
        }

        public boolean outputIsString() {
            return false;
        }
    }
}

