/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.util.Vector;

public class BDLList {
    public static final String STRING_AND_SUBVALUE_TAG = ".StringAndSubValue";
    String[] m_names = null;
    Object[] m_values = null;

    public BDLList(int len) {
        this.m_names = new String[len];
        this.m_values = new Object[len];
    }

    public void set(int i, String name, Object val) {
        this.m_names[i] = name;
        this.m_values[i] = val;
    }

    public int getLength() {
        return this.m_names.length;
    }

    public String getName(int i) {
        return i < 0 || i >= this.m_names.length ? null : this.m_names[i];
    }

    public Object getValue(int i) {
        return i < 0 || i >= this.m_values.length ? null : this.m_values[i];
    }

    public Object getValue(String str) {
        return this.getValue(this.getIndex(str));
    }

    public int getIndex(String str) {
        if (str == null) {
            return -1;
        }
        int len = this.m_names.length;
        for (int i = 0; i < len; ++i) {
            if (!str.equals(this.m_names[i])) continue;
            return i;
        }
        return -1;
    }

    public boolean hasValue(String str) {
        return this.getIndex(str) >= 0;
    }

    public boolean getValueBoolean(String str, boolean defaultVal) {
        return this.getValueBoolean(this.getIndex(str), defaultVal);
    }

    public boolean getValueBoolean(int index, boolean defaultVal) {
        if (index < 0 || index >= this.m_values.length) {
            return defaultVal;
        }
        return "true".equalsIgnoreCase(this.getValueString(index, defaultVal ? "true" : "false"));
    }

    public int getValueInt(String str, int defaultVal) {
        return this.getValueInt(this.getIndex(str), defaultVal);
    }

    public int getValueInt(int index, int defaultVal) {
        int val = defaultVal;
        if (index >= 0) {
            try {
                val = Integer.parseInt(this.getValueString(index));
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return val;
    }

    public String getValueString(String str, String defaultVal) {
        int index = this.getIndex(str);
        return index < 0 ? defaultVal : this.getValueString(index);
    }

    public String getValueString(int i, String defaultVal) {
        if (i < 0 || i >= this.m_values.length) {
            return defaultVal;
        }
        Object obj = this.getValue(i);
        if (obj == null || obj instanceof String) {
            return (String)obj;
        }
        throw new RuntimeException("getValueString(" + i + ") value not string in: " + this);
    }

    public String getValueString(String str) {
        return this.getValueString(str, null);
    }

    public String getValueString(int i) {
        return this.getValueString(i, null);
    }

    public BDLList getValueBDLList(String str) {
        return this.getValueBDLList(this.getIndex(str));
    }

    public BDLList getValueBDLList(int i) {
        Object obj = this.getValue(i);
        if ("".equals(obj)) {
            return new BDLList(0);
        }
        if (obj == null || obj instanceof BDLList) {
            return (BDLList)obj;
        }
        throw new RuntimeException("getValueBDLList(" + i + ") value not BDLList in: " + this);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("BDLList[");
        int len = this.getLength();
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                buf.append(",");
            }
            buf.append(this.getName(i));
            buf.append("=");
            buf.append(this.getValue(i));
        }
        buf.append("]");
        return buf.toString();
    }

    public static XTProps translateToXTProps(BDLList lst) {
        XTProps props = null;
        try {
            props = new XTProps();
            if (lst == null) {
                return props;
            }
            int len = lst.getLength();
            for (int i = 0; i < len; ++i) {
                String nm = lst.getName(i);
                Object obj = lst.getValue(i);
                if (nm == null || nm.length() == 0) continue;
                if (obj == null) {
                    obj = "";
                }
                if (obj instanceof String) {
                    props.set(nm, (String)obj);
                    continue;
                }
                BDLList.translateToXTPropsSet(props, new String[]{nm, null}, (BDLList)obj);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return props;
    }

    private static void translateToXTPropsSet(XTProps props, String[] path, BDLList lst) {
        int len = lst.getLength();
        for (int i = 0; i < len; ++i) {
            String nm = lst.getName(i);
            Object obj = lst.getValue(i);
            if (nm == null || nm.length() == 0) continue;
            if (obj == null) {
                obj = "";
            }
            path[path.length - 1] = nm;
            if (nm.equals(STRING_AND_SUBVALUE_TAG)) {
                String[] strAndSubValsPath = new String[path.length - 1];
                for (int j = 0; j < strAndSubValsPath.length; ++j) {
                    strAndSubValsPath[j] = path[j];
                }
                props.set(strAndSubValsPath, (String)obj);
                continue;
            }
            if (obj instanceof String) {
                props.set(path, (String)obj);
                continue;
            }
            String[] newPath = new String[path.length + 1];
            System.arraycopy(path, 0, newPath, 0, path.length);
            BDLList.translateToXTPropsSet(props, newPath, (BDLList)obj);
        }
    }

    public static BDLList translateFromXTProps(XTProps props) {
        return BDLList.translateFromXTProps(props, new String[0]);
    }

    private static BDLList translateFromXTProps(XTProps props, String[] path) {
        if (props == null) {
            return new BDLList(0);
        }
        Vector subNames = props.getSubProperties(path);
        BDLList ret = new BDLList(subNames.size());
        String[] newPath = new String[path.length + 1];
        System.arraycopy(path, 0, newPath, 0, path.length);
        for (int i = 0; i < subNames.size(); ++i) {
            String subName;
            newPath[path.length] = subName = (String)subNames.get(i);
            String valueString = props.getValue(newPath, null);
            Vector valueLists = props.getSubProperties(newPath);
            Object subVal = "";
            if (valueLists.size() > 0) {
                subVal = BDLList.translateFromXTProps(props, newPath);
                if (valueString != null && valueString.length() > 0) {
                    BDLList subList = (BDLList)subVal;
                    BDLList newList = new BDLList(valueLists.size() + 1);
                    for (int j = 0; j < valueLists.size(); ++j) {
                        newList.set(j, subList.getName(j), subList.getValue(j));
                    }
                    newList.set(valueLists.size(), STRING_AND_SUBVALUE_TAG, valueString);
                    subVal = newList;
                }
            } else if (valueString != null) {
                subVal = valueString;
            }
            ret.set(i, subName, subVal);
        }
        return ret;
    }

    public static BDLList translateFromXTMetaData(XTMetaData md) {
        BDLList lst = new BDLList(0);
        try {
            if (md == null) {
                md = new XTMetaData();
            }
            int numColumns = md.getNumColumns();
            lst = new BDLList(3);
            lst.set(0, "num.columns", String.valueOf(numColumns));
            lst.set(1, "num.rows", String.valueOf(md.getNumRows()));
            BDLList columnInfoList = new BDLList(numColumns);
            lst.set(2, "columns", columnInfoList);
            for (int col = 0; col < numColumns; ++col) {
                String colName = md.ordinalToName(col);
                BDLList levelList = null;
                if (md.isCategoricalColumn(col)) {
                    Vector levelVec = md.getCategoricalDataFieldLevels(colName);
                    int numLevels = levelVec.size();
                    levelList = new BDLList(numLevels);
                    for (int levelNum = 0; levelNum < numLevels; ++levelNum) {
                        String levelName = (String)levelVec.get(levelNum);
                        String levelCount = String.valueOf(md.getLevelCount(colName, levelName));
                        levelList.set(levelNum, levelName, levelCount);
                    }
                }
                BDLList colInfo = new BDLList(8);
                colInfo.set(0, "type", md.getColumnType(col));
                colInfo.set(1, "missing", String.valueOf((long)md.getColumnMissingCount(col)));
                colInfo.set(2, "mean", String.valueOf(md.getColumnMean(col)));
                colInfo.set(3, "min", String.valueOf(md.getColumnMin(col)));
                colInfo.set(4, "max", String.valueOf(md.getColumnMax(col)));
                colInfo.set(5, "stdev", String.valueOf(md.getColumnStandardDeviation(col)));
                colInfo.set(6, "max.string.chars", String.valueOf(md.getStringDataFieldWidth(col) - 1));
                colInfo.set(7, "levels", levelList);
                columnInfoList.set(col, colName, colInfo);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return lst;
    }

    public static XTMetaData translateToXTMetaData(BDLList md) {
        try {
            XTMetaData xtMD = new XTMetaData();
            if (md == null || md.getLength() < 3) {
                return xtMD;
            }
            int numColumns = md.getValueInt(0, 0);
            long numRows = Long.parseLong(md.getValueString(1));
            BDLList columnInfoList = md.getValueBDLList(2);
            for (int col = 0; col < numColumns; ++col) {
                String colName = columnInfoList.getName(col);
                BDLList colInfo = columnInfoList.getValueBDLList(col);
                String type = colInfo.getValueString("type");
                long missing = Long.parseLong(colInfo.getValueString("missing"));
                double mean = Double.parseDouble(colInfo.getValueString("mean"));
                double min = Double.parseDouble(colInfo.getValueString("min"));
                double max = Double.parseDouble(colInfo.getValueString("max"));
                double stdev = Double.parseDouble(colInfo.getValueString("stdev"));
                int maxStringChars = colInfo.getValueInt("max.string.chars", 32);
                BDLList levels = colInfo.getValueBDLList("levels");
                if (type.equals(XTMetaData.CONTINUOUS_TYPE_ATTRIBUTE_TAG)) {
                    xtMD.appendContinousDataField(colName);
                } else if (type.equals(XTMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG)) {
                    xtMD.appendCategoricalDataField(colName, levels.m_names);
                    long[] counts = new long[levels.m_values.length];
                    for (int i = 0; i < counts.length; ++i) {
                        counts[i] = Long.parseLong((String)levels.m_values[i]);
                    }
                    xtMD.appendCountsCategories(colName, levels.m_names, counts);
                } else if (type.equals(XTMetaData.STRING_TYPE_ATTRIBUTE_TAG)) {
                    xtMD.appendStringDataField(colName, maxStringChars + 1);
                } else if (type.equals(XTMetaData.DATE_TIME_TYPE_ATTRIBUTE_TAG)) {
                    xtMD.appendDateTimeDataField(colName);
                } else if (type.equals(XTMetaData.BLOB_TYPE_ATTRIBUTE_TAG)) {
                    xtMD.appendBlobDataField(colName, "");
                }
                xtMD.appendNumericInfo(colName, mean, min, max, stdev, Double.NaN, Double.NaN);
                xtMD.appendCounts(colName, numRows, missing);
            }
            return xtMD;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

