/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.ClusterEngineNode;
import com.insightful.miner.MinerApp;
import com.insightful.miner.NodeDialog;
import com.insightful.miner.PredictionPanel;
import com.insightful.miner.SelectColumnsPanel;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class ClusterDialog
extends NodeDialog {
    private SelectColumnsPanel selectColumnsPanel;
    private PredictionPanel predictionPanel;
    private JRadioButton[] scaleRadioButtons;
    private JTextField numClustersTextField;
    private JTextField maxIterationsTextField;
    private JTextField rowsRetainedSetTextField;
    private JComboBox initializingCentersComboBox;
    private JTextField maxTimesRetainPointsTextField;
    private JCheckBox chartCheckBox;
    private JCheckBox tableViewCheckBox;
    private static final String[] initializingCenterMethods = new String[]{MinerApp.getText("ClusterDialog_firstKDataPoints"), MinerApp.getText("ClusterDialog_samplingFromFirstBlock"), MinerApp.getText("ClusterDialog_HClustFromFirstBlock"), MinerApp.getText("ClusterDialog_SamplingFromEntireDataSet")};
    private static final String[] initializingCenterEngineStrings = new String[]{ClusterEngineNode.FIRST_K_DATA_POINTS_ATTRIBUTE_TAG, ClusterEngineNode.SAMPLING_FROM_FIRST_BLOCK_ATTRIBUTE_TAG, ClusterEngineNode.HCLUST_FROM_FIRST_BLOCK_ATTRIBUTE_TAG, ClusterEngineNode.SAMPLING_FROM_ENTIRE_SET_ATTRIBUTE_TAG};
    private static final String[] scaleEngineStrings = new String[]{ClusterEngineNode.NO_SCALE_ATTRIBUTE_TAG, ClusterEngineNode.RANGE_SCALE_ATTRIBUTE_TAG, ClusterEngineNode.ST_DEV_SCALE_ATTRIBUTE_TAG};
    private static ClusterDialog instance = null;

    public static ClusterDialog getInstance() {
        if (instance == null) {
            instance = new ClusterDialog();
        }
        return instance;
    }

    private ClusterDialog() {
        this.setSize(475, 425);
        this.setMinimumSize(new Dimension(475, 425));
        this.setResizable(true);
    }

    public boolean displaySeedPanel() {
        return true;
    }

    public void restoreProperties() {
        super.restoreProperties();
        this.selectColumnsPanel.restoreProperties(this.getNodeModel());
        this.predictionPanel.restoreProperties(this.getNodeModel(), 2);
        XTProps props = this.getNodeModel().getXTProps();
        this.numClustersTextField.setText(props.getValue(ClusterEngineNode.NUM_CLUSTERS_ATTRIBUTE_TAG, ClusterEngineNode.NUM_CLUSTERS_DEFAULT));
        this.maxIterationsTextField.setText(props.getValue(ClusterEngineNode.MAX_ITERATIONS_ATTRIBUTE_TAG, ClusterEngineNode.MAX_ITERATIONS_DEFAULT));
        String globalChunkDefault = String.valueOf(MinerApp.getWorksheetPropertiesManager().getMaxRowsPerBlock());
        this.rowsRetainedSetTextField.setText(props.getValue(ClusterEngineNode.ROWS_RETAINED_SET_ATTRIBUTE_TAG, globalChunkDefault));
        String method = props.getValue(ClusterEngineNode.INITIALIZING_CENTER_ATTRIBUTE_TAG, ClusterEngineNode.SAMPLING_FROM_FIRST_BLOCK_ATTRIBUTE_TAG);
        for (int iMethod = 0; iMethod < initializingCenterEngineStrings.length; ++iMethod) {
            if (!method.equals(initializingCenterEngineStrings[iMethod])) continue;
            this.initializingCentersComboBox.setSelectedIndex(iMethod);
            break;
        }
        this.chartCheckBox.setSelected(props.getBoolean(ClusterEngineNode.CHART_DISPLAY_ATTRIBUTE_TAG, ClusterEngineNode.CHART_DISPLAY_DEFAULT));
        this.tableViewCheckBox.setSelected(props.getBoolean(ClusterEngineNode.TABLE_VIEW_DISPLAY_ATTRIBUTE_TAG, ClusterEngineNode.TABLE_VIEW_DISPLAY_DEFAULT));
        String scaleString = props.getValue(ClusterEngineNode.SCALE_ATTRIBUTE_TAG, ClusterEngineNode.SCALE_METHOD_DEFAULT);
        for (int i = 0; i < scaleEngineStrings.length; ++i) {
            if (!scaleString.equals(scaleEngineStrings[i])) continue;
            this.scaleRadioButtons[i].setSelected(true);
            this.scaleRadioButtons[i].doClick();
            break;
        }
    }

    public void saveProperties() throws NodeDialog.DialogException {
        super.saveProperties();
        this.selectColumnsPanel.saveProperties(this.getNodeModel());
        this.predictionPanel.saveProperties(this.getNodeModel(), 2);
        XTProps props = this.getNodeModel().getXTProps();
        props.set(ClusterEngineNode.NUM_CLUSTERS_ATTRIBUTE_TAG, this.numClustersTextField.getText());
        props.set(ClusterEngineNode.MAX_ITERATIONS_ATTRIBUTE_TAG, this.maxIterationsTextField.getText());
        props.set(ClusterEngineNode.ROWS_RETAINED_SET_ATTRIBUTE_TAG, this.rowsRetainedSetTextField.getText());
        props.set(ClusterEngineNode.INITIALIZING_CENTER_ATTRIBUTE_TAG, initializingCenterEngineStrings[this.initializingCentersComboBox.getSelectedIndex()]);
        props.set(ClusterEngineNode.CHART_DISPLAY_ATTRIBUTE_TAG, this.chartCheckBox.isSelected());
        props.set(ClusterEngineNode.TABLE_VIEW_DISPLAY_ATTRIBUTE_TAG, this.tableViewCheckBox.isSelected());
        for (int i = 0; i < this.scaleRadioButtons.length; ++i) {
            if (!this.scaleRadioButtons[i].isSelected()) continue;
            props.set(ClusterEngineNode.SCALE_ATTRIBUTE_TAG, scaleEngineStrings[i]);
            break;
        }
    }

    public JPanel createOptionsPanel() {
        JPanel optionsPanel = new JPanel(new BorderLayout());
        this.selectColumnsPanel = new SelectColumnsPanel(this.okAction);
        this.selectColumnsPanel.setExcludedColumnType(XTMetaData.STRING_TYPE_ATTRIBUTE_TAG);
        this.selectColumnsPanel.setExcludedColumnType(XTMetaData.BLOB_TYPE_ATTRIBUTE_TAG);
        JPanel clusterPanel = new JPanel(new GridBagLayout());
        clusterPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("ClusterDialog_options")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        JLabel numClustersLabel = new JLabel(MinerApp.getText("ClusterDialog_numberOfClusters"));
        this.numClustersTextField = new JTextField(10);
        numClustersLabel.setLabelFor(this.numClustersTextField);
        numClustersLabel.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent kevEvent) {
                if (kevEvent.getKeyCode() == 78) {
                    ClusterDialog.this.numClustersTextField.setRequestFocusEnabled(true);
                }
            }
        });
        numClustersLabel.setDisplayedMnemonic(MinerApp.getText("ClusterDialog_numberOfClustersHotkey").charAt(0));
        numClustersLabel.setLabelFor(this.numClustersTextField);
        this.numClustersTextField.setDocument(new NodeDialog.InputIntegerDoc());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 18;
        clusterPanel.add((Component)numClustersLabel, constraints);
        constraints.gridx = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.insets = new Insets(0, 15, 0, 0);
        clusterPanel.add((Component)this.numClustersTextField, constraints);
        optionsPanel.add((Component)this.selectColumnsPanel, "Center");
        optionsPanel.add((Component)clusterPanel, "South");
        return optionsPanel;
    }

    private JPanel getOptionsPanel() {
        JPanel clusterPanel = new JPanel(new GridBagLayout());
        clusterPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("ClusterDialog_computationOptions")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        JLabel maxIterationsLabel = new JLabel(MinerApp.getText("ClusterDialog_maximumIterations"));
        this.maxIterationsTextField = new JTextField(22);
        maxIterationsLabel.setDisplayedMnemonic(MinerApp.getText("ClusterDialog_maximumIterationsHotkey").charAt(0));
        maxIterationsLabel.setLabelFor(this.maxIterationsTextField);
        this.maxIterationsTextField.setDocument(new NodeDialog.InputIntegerDoc());
        JLabel rowsRetainedSetLabel = new JLabel(MinerApp.getText("ClusterDialog_rowsRetainedSet"));
        this.rowsRetainedSetTextField = new JTextField(22);
        this.rowsRetainedSetTextField.setDocument(new NodeDialog.InputIntegerDoc());
        rowsRetainedSetLabel.setDisplayedMnemonic(MinerApp.getText("ClusterDialog_rowsRetainedSetHotkey").charAt(0));
        rowsRetainedSetLabel.setLabelFor(this.rowsRetainedSetTextField);
        JLabel initializingCentersLabel = new JLabel(MinerApp.getText("ClusterDialog_initializingTheCenters"));
        this.initializingCentersComboBox = new JComboBox<String>(initializingCenterMethods);
        initializingCentersLabel.setDisplayedMnemonic(MinerApp.getText("ClusterDialog_initializingTheCentersHotkey").charAt(0));
        initializingCentersLabel.setLabelFor(this.initializingCentersComboBox);
        this.initializingCentersComboBox.setPreferredSize(this.rowsRetainedSetTextField.getPreferredSize());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 18;
        clusterPanel.add((Component)initializingCentersLabel, constraints);
        constraints.gridx = 1;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(0, 15, 0, 0);
        clusterPanel.add((Component)this.initializingCentersComboBox, constraints);
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.weightx = 0.0;
        constraints.insets = new Insets(0, 0, 0, 0);
        clusterPanel.add((Component)maxIterationsLabel, constraints);
        constraints.gridx = 1;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(0, 15, 0, 0);
        clusterPanel.add((Component)this.maxIterationsTextField, constraints);
        constraints.gridy = 3;
        constraints.gridx = 0;
        constraints.weightx = 0.0;
        constraints.insets = new Insets(0, 0, 0, 0);
        clusterPanel.add((Component)rowsRetainedSetLabel, constraints);
        constraints.gridx = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.insets = new Insets(0, 15, 0, 0);
        clusterPanel.add((Component)this.rowsRetainedSetTextField, constraints);
        JPanel scalePanel = new JPanel(new GridBagLayout());
        scalePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("ClusterDialog_scale")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        ButtonGroup scaleButtons = new ButtonGroup();
        this.scaleRadioButtons = new JRadioButton[3];
        JRadioButton noneRadioButton = new JRadioButton(MinerApp.getText("ClusterDialog_none"));
        noneRadioButton.setMnemonic(MinerApp.getText("ClusterDialog_noneHotkey").charAt(0));
        scaleButtons.add(noneRadioButton);
        this.scaleRadioButtons[0] = noneRadioButton;
        JRadioButton rangeRadioButton = new JRadioButton(MinerApp.getText("ClusterDialog_range"));
        rangeRadioButton.setMnemonic(MinerApp.getText("ClusterDialog_rangeHotkey").charAt(0));
        scaleButtons.add(rangeRadioButton);
        this.scaleRadioButtons[1] = rangeRadioButton;
        JRadioButton stDevRadioButton = new JRadioButton(MinerApp.getText("ClusterDialog_stdDev"));
        stDevRadioButton.setMnemonic(MinerApp.getText("ClusterDialog_stdDevHotkey").charAt(0));
        scaleButtons.add(stDevRadioButton);
        this.scaleRadioButtons[2] = stDevRadioButton;
        GridBagConstraints scaleConstraints = new GridBagConstraints();
        scaleConstraints.anchor = 18;
        scaleConstraints.weightx = 1.0;
        scalePanel.add((Component)noneRadioButton, scaleConstraints);
        scaleConstraints.gridy = 1;
        scalePanel.add((Component)rangeRadioButton, scaleConstraints);
        scaleConstraints.gridy = 2;
        scaleConstraints.weighty = 1.0;
        scalePanel.add((Component)stDevRadioButton, scaleConstraints);
        JPanel displayPanel = new JPanel(new GridBagLayout());
        displayPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("ClusterDialog_displayOptions")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.chartCheckBox = new JCheckBox(MinerApp.getText("ClusterDialog_displayChart"));
        this.chartCheckBox.setMnemonic(MinerApp.getText("ClusterDialog_displayChart").charAt(0));
        this.tableViewCheckBox = new JCheckBox(MinerApp.getText("ClusterDialog_displayTableView"));
        this.tableViewCheckBox.setMnemonic(MinerApp.getText("ClusterDialog_displayTableViewHotkey").charAt(0));
        GridBagConstraints displayConstraints = new GridBagConstraints();
        displayConstraints.anchor = 18;
        displayConstraints.weightx = 1.0;
        displayPanel.add((Component)this.chartCheckBox, displayConstraints);
        displayConstraints.gridy = 1;
        displayConstraints.weighty = 1.0;
        displayPanel.add((Component)this.tableViewCheckBox, displayConstraints);
        JPanel optionsPanel = new JPanel(new BorderLayout());
        optionsPanel.setName(MinerApp.getText("ClusterDialog_options"));
        optionsPanel.add((Component)displayPanel, "North");
        optionsPanel.add((Component)scalePanel, "Center");
        optionsPanel.add((Component)clusterPanel, "South");
        return optionsPanel;
    }

    public Vector createOtherTabs() {
        Vector<JPanel> panels = new Vector<JPanel>();
        this.predictionPanel = new PredictionPanel();
        panels.add(this.getOptionsPanel());
        panels.add(this.predictionPanel);
        return panels;
    }
}

