/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.ChartBuilder;
import com.insightful.miner.ChartEngineNode;
import com.insightful.miner.ClusterDialog;
import com.insightful.miner.ClusterEngineNode;
import com.insightful.miner.HtmlFrame;
import com.insightful.miner.MinerApp;
import com.insightful.miner.PredictableNodeModel;
import com.insightful.miner.XMLTree;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.awt.Frame;
import java.util.Vector;
import javax.swing.JOptionPane;

public class ClusterNodeModel
extends PredictableNodeModel {
    public void initializeNodeModel() {
        XTProps props = this.getXTProps();
        props.set(new String[]{ClusterEngineNode.NUM_CLUSTERS_ATTRIBUTE_TAG}, props.getValue(new String[]{ClusterEngineNode.NUM_CLUSTERS_ATTRIBUTE_TAG}, ClusterEngineNode.NUM_CLUSTERS_DEFAULT));
        props.set(new String[]{ClusterEngineNode.NUM_CLUSTERS_ATTRIBUTE_TAG}, props.getValue(new String[]{ClusterEngineNode.NUM_CLUSTERS_ATTRIBUTE_TAG}, ClusterEngineNode.MAX_ITERATIONS_DEFAULT));
        props.set(new String[]{"newColumns", "clusterMembership"}, props.getValue(new String[]{"newColumns", "clusterMembership"}, "true"));
        props.set(new String[]{"newColumns", "distanceToCenter"}, props.getValue(new String[]{"newColumns", "distanceToCenter"}, "false"));
        props.set(new String[]{"copyInputColumns", "clusterColumns"}, props.getValue(new String[]{"copyInputColumns", "clusterColumns"}, "true"));
        props.set(new String[]{"copyInputColumns", "clusterOther"}, props.getValue(new String[]{"copyInputColumns", "clusterOther"}, "false"));
    }

    public boolean isPropertiesValid() {
        XTProps props = this.getXTProps();
        Vector display = props.getSubProperties("outgoingColumns");
        try {
            if (this.isInputValid()) {
                XTMetaData md = this.getInputMetaData(0);
                for (int i = display.size() - 1; i >= 0; --i) {
                    if (md.nameToOrdinal((String)display.get(i)) != -1) continue;
                    return false;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return display.size() != 0;
    }

    public boolean postDialogEqualityCheck(XTProps oldProps, XTProps newProps) {
        oldProps.removeProperty(new String[]{ClusterEngineNode.TABLE_VIEW_DISPLAY_ATTRIBUTE_TAG});
        newProps.removeProperty(new String[]{ClusterEngineNode.TABLE_VIEW_DISPLAY_ATTRIBUTE_TAG});
        if (oldProps.getBoolean(new String[]{ClusterEngineNode.CHART_DISPLAY_ATTRIBUTE_TAG}, false)) {
            oldProps.removeProperty(new String[]{ClusterEngineNode.CHART_DISPLAY_ATTRIBUTE_TAG});
            newProps.removeProperty(new String[]{ClusterEngineNode.CHART_DISPLAY_ATTRIBUTE_TAG});
        }
        return oldProps.equals(newProps);
    }

    public void showPropertiesDialog(boolean modality) {
        ClusterDialog dialog = ClusterDialog.getInstance();
        dialog.setModal(modality);
        dialog.show(this);
    }

    public String getModelOutputType() {
        return "cluster";
    }

    public String getModelAlgorithm() {
        return "cluster";
    }

    public void showView(Frame frame) {
        XTProps props = this.getXTProps();
        boolean chart = props.getBoolean(ClusterEngineNode.CHART_DISPLAY_ATTRIBUTE_TAG, ClusterEngineNode.CHART_DISPLAY_DEFAULT);
        boolean html = props.getBoolean(ClusterEngineNode.TABLE_VIEW_DISPLAY_ATTRIBUTE_TAG, ClusterEngineNode.TABLE_VIEW_DISPLAY_DEFAULT);
        if (chart) {
            this.showChart();
        }
        if (html) {
            this.showHTMLTable(frame);
        }
        if (!chart && !html) {
            super.showView(frame);
        }
    }

    private void showChart() {
        int numBins;
        XTProps dialogProps = this.getXTProps();
        XTMetaData metaData = null;
        XTProps chartStats = null;
        try {
            metaData = this.getOutputMetaData(0);
            chartStats = (XTProps)this.sendMessageToEngine("getNodeCacheXTProps", new Object[]{ClusterEngineNode.BIN_COUNT_CACHE});
            Integer integer = (Integer)this.sendMessageToEngine("getBinCount", new Object[0]);
            numBins = integer;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        Vector displayColumns = dialogProps.getSubProperties(ClusterEngineNode.DISPLAY_COLUMNS_ATTRIBUTE_TAG);
        for (int i = displayColumns.size() - 1; i >= 0; --i) {
            String column = (String)displayColumns.get(i);
            if (metaData.isStringColumn(column)) {
                displayColumns.remove(i);
            }
            if (metaData.nameToOrdinal(column) != -1) continue;
            JOptionPane.showMessageDialog(null, MinerApp.getText("ClusterNodeModel_msg_couldNotDisplayChart"), MinerApp.getText("ClusterNodeModel_msg_clusterColumnsNotFound"), 1);
            return;
        }
        if (metaData.nameToOrdinal("PREDICT.membership") == -1) {
            JOptionPane.showMessageDialog(null, MinerApp.getText("ClusterNodeModel_couldntDisplayChart"), MinerApp.getText("ClusterNodeModel_clusterMembershipColNotFound"), 1);
            return;
        }
        Vector<String> byColumns = new Vector<String>();
        byColumns.add("PREDICT.membership");
        ChartBuilder chartBuilder = new ChartBuilder(metaData, chartStats);
        int catChartType = 0;
        int contChartType = 0;
        boolean[] executeChartType = new boolean[ChartEngineNode.m_chartTypes.length];
        for (int i = 0; i < executeChartType.length; ++i) {
            executeChartType[i] = dialogProps.getBoolean(ChartEngineNode.m_chartTypes[i], false);
        }
        contChartType = 0;
        catChartType = 3;
        int result = chartBuilder.setDisplayInfo(contChartType, catChartType, displayColumns, byColumns, numBins, true, true, true);
        if (result != -1) {
            try {
                chartBuilder.displayCharts(this.getLabelText());
            }
            catch (OutOfMemoryError oom) {
                chartBuilder.clearMemory();
                chartBuilder = null;
            }
        }
    }

    private void showHTMLTable(Frame frame) {
        try {
            XMLTree xt = this.getFittedModel();
            if (xt != null) {
                String htmlString = xt.getHtmlString(XMLTree.CLUSTER_XSL_FILE, this.getLabelText());
                new HtmlFrame(htmlString);
            } else {
                super.showView(frame);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

