/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.AcceleratorOptionPane;
import com.insightful.miner.ColumnFilterTools;
import com.insightful.miner.MinerApp;
import com.insightful.miner.NodeDialog;
import com.insightful.miner.XTProps;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ColumnFilterSpecificationDialog
extends JDialog {
    private XTProps props;
    private DecimalFormat decimalFormatter;
    private String[] columnNames;
    private double[] statValues;
    String[] colsExcluded;
    private JTable table;
    private DefaultTableModel tableModel;
    private NodeDialog.TableSorter sorter;
    private TitledBorder titleBorder;
    private JLabel methodLabel;
    private JLabel numKeepLabel;
    private JLabel maxLabel;
    private JLabel minLabel;
    private JRadioButton specifyNumRadioButton;
    private JRadioButton specifyRangeRadioButton;
    private JTextField numKeepTextField;
    private JTextField maxTextField;
    private JTextField minTextField;
    private static final String okHotkeyString = "NodeDialog_okHotkey";
    private static final String helpHotkeyString = "NodeDialog_helpHotkey";
    private static final String cancelHotkeyString = "NodeDialog_cancelHotkey";
    private static final String helpString = "NodeDialog_help";
    private static final String okString = "NodeDialog_ok";
    private static final String cancelString = "NodeDialog_cancel";
    protected AbstractAction helpAction;
    protected AbstractAction okAction;
    protected AbstractAction cancelAction;
    private Dimension minimumSize;
    private Dimension maximumSize;
    private JButton okButton;
    private JButton cancelButton;
    private JButton helpButton;
    private ActionListener methodButtonListener;
    private ActionListener textFieldListener;
    private FocusAdapter focusListener;
    private static ColumnFilterSpecificationDialog instance = null;

    public ColumnFilterSpecificationDialog(Frame owner) {
        super(owner, MinerApp.getText("ColumnFilterSpecificationDialog_title"), true);
        this.setMinimumSize(new Dimension(460, 290));
        this.setSize(new Dimension(600, 400));
        this.createActions();
        this.createLayout();
        this.setResizable(true);
        this.setLocationRelativeTo(owner);
        this.minimumSize = this.getMinimumSize();
        this.maximumSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent event) {
                if (event.getSource() instanceof JDialog) {
                    Dimension myDimensions = ColumnFilterSpecificationDialog.this.getPermittedSize(ColumnFilterSpecificationDialog.this.getSize());
                    ColumnFilterSpecificationDialog.this.setSize(myDimensions);
                }
            }
        });
    }

    public String[] show(XTProps props, String[] columnNames, double[] statValues) {
        if (props != null) {
            this.props = props;
            this.columnNames = columnNames;
            this.statValues = statValues;
            this.decimalFormatter = new DecimalFormat();
            MinerApp.getWorksheetPropertiesManager().initViewerRoundingObject(this.decimalFormatter);
            this.decimalFormatter.setGroupingUsed(false);
            this.restoreProperties();
            this.setVisible(true);
        }
        return this.colsExcluded;
    }

    protected void restoreProperties() {
        int i;
        int j;
        this.props.set("dialogExitStatus", 0);
        if (this.props.getValue("method", "number").equals("number")) {
            this.specifyNumRadioButton.setSelected(true);
        } else {
            this.specifyNumRadioButton.setSelected(false);
        }
        this.methodButtonListener.actionPerformed(new ActionEvent(this.specifyNumRadioButton, 0, ""));
        this.titleBorder.setTitle(this.props.getValue("label", ""));
        double max = this.statValues.length != 0 ? this.statValues[0] : Double.NaN;
        double min = this.statValues.length != 0 ? this.statValues[0] : Double.NaN;
        for (j = 0; j < this.statValues.length; ++j) {
            if (Double.isNaN(this.statValues[j])) continue;
            min = this.statValues[j];
            max = this.statValues[j];
            ++j;
            break;
        }
        while (j < this.statValues.length) {
            if (!Double.isNaN(this.statValues[j])) {
                min = Math.min(min, this.statValues[j]);
                max = Math.max(max, this.statValues[j]);
            }
            ++j;
        }
        this.numKeepTextField.setText(this.props.getValue("numKeep", Integer.toString(this.statValues.length)));
        int roundingPlaces = MinerApp.getWorksheetPropertiesManager().getNumDigitsInViewers();
        StringBuffer roundingString = new StringBuffer();
        roundingString.append("0.");
        for (int i2 = 0; i2 < roundingPlaces - 1; ++i2) {
            roundingString.append('0');
        }
        roundingString.append('1');
        double roundingValue = Double.parseDouble(roundingString.toString());
        this.minTextField.setText(this.props.getValue("minValue", Double.isNaN(min -= roundingValue) ? "0" : this.decimalFormatter.format(min)));
        this.maxTextField.setText(this.props.getValue("maxValue", Double.isNaN(max) ? "0" : this.decimalFormatter.format(max += roundingValue)));
        int rowCount = this.tableModel.getRowCount();
        for (i = 0; i < rowCount; ++i) {
            this.tableModel.removeRow(0);
        }
        for (i = 0; i < this.columnNames.length; ++i) {
            this.tableModel.addRow(new Object[]{this.columnNames[i], String.valueOf(this.statValues[i])});
        }
        this.getRootPane().setDefaultButton(this.okButton);
        this.refresh();
    }

    protected JPanel createButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(15, 5, 10, 5));
        Dimension buttonSize = new Dimension(80, 25);
        buttonPanel.add(Box.createGlue());
        buttonPanel.add(Box.createHorizontalStrut(5));
        this.okButton = new JButton(this.okAction);
        this.okButton.setPreferredSize(buttonSize);
        this.okButton.setMnemonic(MinerApp.getText(okHotkeyString).charAt(0));
        buttonPanel.add(this.okButton);
        buttonPanel.add(Box.createHorizontalStrut(5));
        this.getRootPane().setDefaultButton(this.okButton);
        this.cancelButton = new JButton(this.cancelAction);
        this.cancelButton.setPreferredSize(buttonSize);
        this.cancelButton.setMnemonic(MinerApp.getText(cancelHotkeyString).charAt(0));
        buttonPanel.add(this.cancelButton);
        this.cancelButton.registerKeyboardAction(this.cancelAction, KeyStroke.getKeyStroke("ESCAPE"), 2);
        buttonPanel.add(Box.createHorizontalStrut(5));
        this.helpButton = new JButton(this.helpAction);
        this.helpButton.setPreferredSize(buttonSize);
        this.helpButton.setMnemonic(MinerApp.getText(helpHotkeyString).charAt(0));
        buttonPanel.add(this.helpButton);
        buttonPanel.add(Box.createHorizontalStrut(5));
        this.helpButton.registerKeyboardAction(this.helpAction, KeyStroke.getKeyStroke("F1"), 2);
        return buttonPanel;
    }

    protected void saveProperties() throws NodeDialog.DialogException {
        this.colsExcluded = this.getExcludeColumnsFromFilterSpecification();
        this.props.set("method", this.specifyNumRadioButton.isSelected() ? "number" : "range");
        this.props.set("numKeep", this.numKeepTextField.getText());
        this.props.set("minValue", this.minTextField.getText());
        this.props.set("maxValue", this.maxTextField.getText());
    }

    protected void onCancel() {
        this.colsExcluded = null;
        this.setVisible(false);
    }

    protected void onOk() {
        try {
            this.saveProperties();
            this.setVisible(false);
        }
        catch (NodeDialog.DialogException e) {
            AcceleratorOptionPane.showOKDialog(this, e.getMessage(), MinerApp.getText("NodeDialog_dialogCannotBeSaved"), 0);
        }
    }

    protected void onHelp() {
        MinerApp.getHelpManager().showTopic(this.getTitle());
    }

    public void createLayout() {
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JPanel centerPanel = new JPanel(new BorderLayout());
        this.titleBorder = BorderFactory.createTitledBorder(MinerApp.getText("ColumnFilterSpecificationDialog_statLabel"));
        centerPanel.setBorder(BorderFactory.createCompoundBorder(this.titleBorder, BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        centerPanel.add((Component)this.createMainPanel(), "West");
        centerPanel.add((Component)this.createTablePanel(), "Center");
        container.add((Component)centerPanel, "Center");
        container.add((Component)this.createButtonPanel(), "South");
    }

    private JPanel createTablePanel() {
        JPanel tablePanel = new JPanel(new BorderLayout());
        tablePanel.setBorder(BorderFactory.createEmptyBorder(0, 15, 0, 0));
        this.tableModel = new DefaultTableModel(){

            public boolean isCellEditable(int row, int column) {
                return false;
            }

            public Object getValueAt(int row, int column) {
                Object o = super.getValueAt(row, column);
                if (column == 0) {
                    return o;
                }
                if (o instanceof String) {
                    try {
                        double full = Double.parseDouble((String)o);
                        o = ColumnFilterSpecificationDialog.this.decimalFormatter.format(full);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                return o;
            }
        };
        this.sorter = new NodeDialog.TableSorter(this.tableModel){

            public void addMouseListenerToHeaderInTable(JTable table) {
                final 3 sorter = this;
                final JTable tableView = table;
                tableView.setColumnSelectionAllowed(false);
                MouseAdapter listMouseListener = new MouseAdapter(){

                    public void mouseClicked(MouseEvent e) {
                        TableColumnModel columnModel = tableView.getColumnModel();
                        int viewColumn = columnModel.getColumnIndexAtX(e.getX());
                        int column = tableView.convertColumnIndexToModel(viewColumn);
                        if (e.getClickCount() == 1 && column != -1) {
                            sorter.sortByColumn(column, sorter.ascending);
                            sorter.ascending = !sorter.ascending;
                            ColumnFilterSpecificationDialog.this.refresh();
                        }
                    }
                };
                JTableHeader th = tableView.getTableHeader();
                th.addMouseListener(listMouseListener);
                table.addMouseListener(new MouseAdapter(){

                    public void mousePressed(MouseEvent e) {
                        if (e.getButton() != 1) {
                            JPopupMenu popup = new JPopupMenu();
                            popup.add(new AbstractAction(MinerApp.getText("ColumnFilterSpecificationDialog_copySelectedRows")){

                                public void actionPerformed(ActionEvent ae) {
                                    TransferHandler tf = tableView.getTransferHandler();
                                    Clipboard clip = tableView.getToolkit().getSystemClipboard();
                                    if (clip != null) {
                                        tf.exportToClipboard(tableView, clip, 1);
                                    }
                                    if ((clip = tableView.getToolkit().getSystemSelection()) != null) {
                                        tf.exportToClipboard(tableView, clip, 1);
                                    }
                                }
                            });
                            popup.show(tableView, e.getX(), e.getY());
                        }
                    }
                });
            }
        };
        this.tableModel.setColumnIdentifiers(new Object[]{MinerApp.getText("ColumnFilterSpecificationDialog_name"), MinerApp.getText("ColumnFilterSpecificationDialog_value")});
        this.table = new JTable(this.sorter);
        this.table.setEnabled(false);
        this.sorter.addMouseListenerToHeaderInTable(this.table);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setRowSelectionAllowed(true);
        this.table.setColumnSelectionAllowed(false);
        this.table.setSelectionMode(2);
        int columnCount = this.tableModel.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            TableColumn column = this.table.getColumn(this.table.getColumnName(i));
            column.setCellRenderer(new NodeDialog.GeneralRenderer());
            column.setCellEditor(null);
        }
        JScrollPane scrollingTable = new JScrollPane(this.table);
        tablePanel.add((Component)scrollingTable, "Center");
        return tablePanel;
    }

    private String[] getExcludeColumnsFromFilterSpecification() throws NodeDialog.DialogException {
        int numToKeep = 0;
        double minValue = 0.0;
        double maxValue = 0.0;
        if (this.specifyNumRadioButton.isSelected()) {
            try {
                numToKeep = Integer.parseInt(this.numKeepTextField.getText());
            }
            catch (Exception e) {
                throw new NodeDialog.DialogException(MinerApp.getText("ColumnFilterSpecificationDialog_invalidInputError"));
            }
            if (numToKeep == 0) {
                return ColumnFilterTools.getExcludeColumnsFromFilterSpecification(this.columnNames, this.statValues, true, 0, minValue, maxValue);
            }
            if (numToKeep > this.columnNames.length) {
                numToKeep = this.columnNames.length;
                this.numKeepTextField.setText(Integer.toString(numToKeep));
            }
        } else {
            try {
                minValue = this.decimalFormatter.parse(this.minTextField.getText()).doubleValue();
                maxValue = this.decimalFormatter.parse(this.maxTextField.getText()).doubleValue();
            }
            catch (Exception e) {
                throw new NodeDialog.DialogException(MinerApp.getText("ColumnFilterSpecificationDialog_invalidInputError"));
            }
            if (minValue > maxValue) {
                return ColumnFilterTools.getExcludeColumnsFromFilterSpecification(this.columnNames, this.statValues, true, 0, minValue, maxValue);
            }
        }
        String[] excludedColumns = ColumnFilterTools.getExcludeColumnsFromFilterSpecification(this.columnNames, this.statValues, this.specifyNumRadioButton.isSelected(), numToKeep, minValue, maxValue);
        return excludedColumns;
    }

    private void refresh() {
        String[] excludedColumns;
        try {
            excludedColumns = this.getExcludeColumnsFromFilterSpecification();
        }
        catch (NodeDialog.DialogException ex) {
            return;
        }
        boolean isExcluded = false;
        this.table.clearSelection();
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            isExcluded = false;
            for (int j = 0; j < excludedColumns.length; ++j) {
                if (!this.table.getValueAt(i, 0).equals(excludedColumns[j])) continue;
                isExcluded = true;
                j = excludedColumns.length;
            }
            if (!isExcluded) {
                this.table.addRowSelectionInterval(i, i);
            }
            this.repaint();
        }
    }

    protected JPanel createMainPanel() {
        JPanel mainPanel = new JPanel(new GridBagLayout());
        this.specifyNumRadioButton = new JRadioButton(MinerApp.getText("ColumnFilterSpecificationDialog_numToKeep"));
        this.specifyNumRadioButton.setMnemonic(MinerApp.getText("ColumnFilterSpecificationDialog_specifyNumberHotkey").charAt(0));
        this.specifyRangeRadioButton = new JRadioButton(MinerApp.getText("ColumnFilterSpecificationDialog_specifyRange"));
        this.specifyRangeRadioButton.setMnemonic(MinerApp.getText("ColumnFilterSpecificationDialog_specifyRangeHotkey").charAt(0));
        ButtonGroup specifyMethodButtonGroup = new ButtonGroup();
        specifyMethodButtonGroup.add(this.specifyNumRadioButton);
        specifyMethodButtonGroup.add(this.specifyRangeRadioButton);
        this.methodButtonListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean useNum = ColumnFilterSpecificationDialog.this.specifyNumRadioButton.isSelected();
                ColumnFilterSpecificationDialog.this.numKeepTextField.setEnabled(useNum);
                ColumnFilterSpecificationDialog.this.minTextField.setEnabled(!useNum);
                ColumnFilterSpecificationDialog.this.maxTextField.setEnabled(!useNum);
                ColumnFilterSpecificationDialog.this.numKeepLabel.setEnabled(useNum);
                ColumnFilterSpecificationDialog.this.minLabel.setEnabled(!useNum);
                ColumnFilterSpecificationDialog.this.maxLabel.setEnabled(!useNum);
                ColumnFilterSpecificationDialog.this.refresh();
            }
        };
        this.textFieldListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ColumnFilterSpecificationDialog.this.refresh();
            }
        };
        this.focusListener = new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                ColumnFilterSpecificationDialog.this.refresh();
            }
        };
        this.specifyNumRadioButton.addActionListener(this.methodButtonListener);
        this.specifyRangeRadioButton.addActionListener(this.methodButtonListener);
        this.numKeepTextField = new JTextField(10);
        this.numKeepTextField.addFocusListener(this.focusListener);
        this.numKeepTextField.addActionListener(this.textFieldListener);
        this.numKeepTextField.setDocument(new NodeDialog.InputIntegerDoc());
        this.maxTextField = new JTextField(10);
        this.maxTextField.addFocusListener(this.focusListener);
        this.maxTextField.addActionListener(this.textFieldListener);
        this.maxTextField.setDocument(new NodeDialog.InputAllDoubleDoc());
        this.minTextField = new JTextField(10);
        this.minTextField.addFocusListener(this.focusListener);
        this.minTextField.addActionListener(this.textFieldListener);
        this.minTextField.setDocument(new NodeDialog.InputAllDoubleDoc());
        this.methodLabel = new JLabel(MinerApp.getText("ColumnFilterSpecificationDialog_method"));
        this.methodLabel.setLabelFor(this.specifyNumRadioButton);
        this.numKeepLabel = new JLabel(MinerApp.getText("ColumnFilterSpecificationDialog_number"));
        this.numKeepLabel.setLabelFor(this.numKeepTextField);
        this.numKeepLabel.setDisplayedMnemonic(MinerApp.getText("ColumnFilterSpecificationDialog_numberHotkey").charAt(0));
        this.maxLabel = new JLabel(MinerApp.getText("ColumnFilterSpecificationDialog_max"));
        this.maxLabel.setLabelFor(this.maxTextField);
        this.maxLabel.setDisplayedMnemonic(MinerApp.getText("ColumnFilterSpecificationDialog_maxHotkey").charAt(0));
        this.minLabel = new JLabel(MinerApp.getText("ColumnFilterSpecificationDialog_min"));
        this.minLabel.setLabelFor(this.minTextField);
        this.minLabel.setDisplayedMnemonic(MinerApp.getText("ColumnFilterSpecificationDialog_minHotkey").charAt(0));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 18;
        Insets fieldInsets = new Insets(0, 15, 0, 0);
        Insets labelInsets = new Insets(0, 30, 0, 0);
        mainPanel.add((Component)this.methodLabel, constraints);
        constraints.gridy = 1;
        constraints.insets = fieldInsets;
        mainPanel.add((Component)this.specifyNumRadioButton, constraints);
        constraints.insets = labelInsets;
        constraints.gridy = 2;
        mainPanel.add((Component)this.numKeepLabel, constraints);
        constraints.insets = fieldInsets;
        constraints.weightx = 1.0;
        constraints.gridx = 1;
        mainPanel.add((Component)this.numKeepTextField, constraints);
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.weightx = 0.0;
        constraints.insets = fieldInsets;
        mainPanel.add((Component)this.specifyRangeRadioButton, constraints);
        constraints.insets = labelInsets;
        constraints.gridy = 4;
        mainPanel.add((Component)this.minLabel, constraints);
        constraints.insets = fieldInsets;
        constraints.gridx = 1;
        constraints.weightx = 1.0;
        mainPanel.add((Component)this.minTextField, constraints);
        constraints.insets = labelInsets;
        constraints.gridx = 0;
        constraints.gridy = 5;
        constraints.weightx = 0.0;
        mainPanel.add((Component)this.maxLabel, constraints);
        constraints.insets = fieldInsets;
        constraints.gridx = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        mainPanel.add((Component)this.maxTextField, constraints);
        return mainPanel;
    }

    public Dimension getMaximumSize() {
        return this.maximumSize;
    }

    public Dimension getMinimumSize() {
        return this.minimumSize;
    }

    public void setMaximumSize(Dimension maximumSize) {
        this.maximumSize = maximumSize;
    }

    public void setMinimumSize(Dimension minimumSize) {
        this.minimumSize = minimumSize;
    }

    public Dimension getPermittedSize(Dimension dimension) {
        double width = dimension.getWidth();
        double height = dimension.getHeight();
        double minHeight = -1.0;
        double maxHeight = -1.0;
        double minWidth = -1.0;
        double maxWidth = -1.0;
        if (this.minimumSize != null) {
            minHeight = this.minimumSize.getHeight();
            minWidth = this.minimumSize.getWidth();
        }
        if (this.maximumSize != null) {
            maxHeight = this.maximumSize.getHeight();
            maxWidth = this.maximumSize.getWidth();
        }
        if (maxWidth != -1.0 && width > maxWidth) {
            width = maxWidth;
        }
        if (minWidth != -1.0 && width < minWidth) {
            width = minWidth;
        }
        if (maxHeight != -1.0 && height > maxHeight) {
            height = maxHeight;
        }
        if (minHeight != -1.0 && height < minHeight) {
            height = minHeight;
        }
        return new Dimension((int)width, (int)height);
    }

    protected void createActions() {
        this.okAction = new AbstractAction(MinerApp.getText(okString)){

            public void actionPerformed(ActionEvent e) {
                ColumnFilterSpecificationDialog.this.onOk();
            }
        };
        this.cancelAction = new AbstractAction(MinerApp.getText(cancelString)){

            public void actionPerformed(ActionEvent e) {
                ColumnFilterSpecificationDialog.this.onCancel();
            }
        };
        this.helpAction = new AbstractAction(MinerApp.getText(helpString)){

            public void actionPerformed(ActionEvent e) {
                ColumnFilterSpecificationDialog.this.onHelp();
            }
        };
    }
}

