/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.ActivityNodeModel;
import com.insightful.miner.ColumnFilterGenerator;
import com.insightful.miner.ColumnFilterTools;
import com.insightful.miner.CorrelationsDialog;
import com.insightful.miner.CorrelationsEngineNode;
import com.insightful.miner.MinerApp;
import com.insightful.miner.Retrievable;
import com.insightful.miner.TableViewNodeModel;
import com.insightful.miner.XTProps;
import java.awt.Frame;
import java.text.DecimalFormat;
import java.util.Vector;

public class CorrelationsNodeModel
extends ActivityNodeModel
implements ColumnFilterGenerator {
    public void initializeNodeModel() {
        XTProps props = this.getXTProps();
        props.set(CorrelationsEngineNode.CORRELATIONS_ATTRIBUTE_TAG, props.getValue(CorrelationsEngineNode.CORRELATIONS_ATTRIBUTE_TAG, "true"));
        props.set(CorrelationsEngineNode.COVARIANCE_ATTRIBUTE_TAG, props.getValue(CorrelationsEngineNode.COVARIANCE_ATTRIBUTE_TAG, "false"));
    }

    public void showPropertiesDialog(boolean modality) {
        CorrelationsDialog dialog = CorrelationsDialog.getInstance();
        dialog.setModal(modality);
        dialog.show(this);
    }

    public boolean postDialogEqualityCheck(XTProps oldProps, XTProps newProps) {
        return oldProps.equals(newProps);
    }

    public String[] getFilterColumnsToExclude() {
        String[] colNames = null;
        double[] absCorValues = null;
        try {
            XTProps props = this.getXTProps();
            boolean covariance = props.getBoolean(CorrelationsEngineNode.COVARIANCE_ATTRIBUTE_TAG, false);
            XTProps covData = (XTProps)this.sendMessageToEngine("getNodeCacheXTProps", new Object[]{"data"});
            Vector correlationsColumns = props.getSubProperties(CorrelationsEngineNode.CORRELATION_COLUMNS_ATTRIBUTE_TAG);
            Vector targetColumns = props.getSubProperties(CorrelationsEngineNode.TARGET_COLUMNS_ATTRIBUTE_TAG);
            if (targetColumns.size() < 1) {
                targetColumns = correlationsColumns;
            }
            int numRows = correlationsColumns.size();
            colNames = new String[numRows];
            absCorValues = new double[numRows];
            String[] path = new String[]{"", (String)targetColumns.get(0), ""};
            path[0] = covariance ? "covariance" : "correlation";
            for (int row = 0; row < numRows; ++row) {
                colNames[row] = (String)correlationsColumns.get(row);
                path[2] = colNames[row];
                absCorValues[row] = covData.getDouble(path, Double.NaN);
                if (!(absCorValues[row] < 0.0)) continue;
                int n = row;
                absCorValues[n] = absCorValues[n] * -1.0;
            }
            if (covariance) {
                return ColumnFilterTools.showDefaultFilterSpecificationDialog(colNames, absCorValues, "Absolute Value of Covariance");
            }
            return ColumnFilterTools.showDefaultFilterSpecificationDialog(colNames, absCorValues, "Absolute Value of Correlation");
        }
        catch (Exception e) {
            e.printStackTrace();
            return new String[0];
        }
    }

    public void showView(Frame frame) {
        try {
            CorrelationDataSource ds;
            XTProps covData = (XTProps)this.sendMessageToEngine("getNodeCacheXTProps", new Object[]{"data"});
            XTProps props = this.getXTProps();
            boolean showCovariances = "true".equals(props.getValue(CorrelationsEngineNode.COVARIANCE_ATTRIBUTE_TAG, "false"));
            boolean showCorrelations = "true".equals(props.getValue(CorrelationsEngineNode.CORRELATIONS_ATTRIBUTE_TAG, "false"));
            if (showCovariances) {
                ds = new CorrelationDataSource("covariance", covData);
                TableViewNodeModel.getTableViewer("Covariances Viewer", this.getID(), ds, false, this, false).show();
            }
            if (showCorrelations) {
                ds = new CorrelationDataSource("correlation", covData);
                TableViewNodeModel.getTableViewer("Correlations Viewer", this.getID(), ds, false, this, false).show();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public class CorrelationDataSource
    implements Retrievable {
        private Vector m_varNames = null;
        private Vector m_targetNames = null;
        private Object[][] m_data = null;
        private int m_rowCount;
        private int m_colCount;
        private boolean m_rounding = true;
        private DecimalFormat m_decimalFormat = new DecimalFormat();

        public CorrelationDataSource(String dataTag, XTProps covData) {
            this.m_targetNames = covData.getSubProperties(dataTag);
            String firstName = this.m_targetNames.size() < 1 ? null : (String)this.m_targetNames.get(0);
            this.m_varNames = firstName == null ? new Vector() : covData.getSubProperties(new String[]{dataTag, firstName});
            this.m_rowCount = this.m_varNames.size();
            this.m_colCount = this.m_targetNames.size();
            this.m_data = new Object[this.m_rowCount][this.m_colCount];
            String[] path = new String[]{dataTag, "", ""};
            for (int col = 0; col < this.m_colCount; ++col) {
                path[1] = (String)this.m_targetNames.get(col);
                for (int row = 0; row < this.m_rowCount; ++row) {
                    path[2] = (String)this.m_varNames.get(row);
                    double val = covData.getDouble(path, Double.NaN);
                    this.m_data[row][col] = Double.toString(val);
                }
            }
        }

        public boolean isSortable() {
            return true;
        }

        public Object getData(long row, int column) {
            if (this.m_rounding) {
                String ret = (String)this.m_data[(int)row][column];
                double full = Double.parseDouble(ret);
                if (Double.isNaN(full)) {
                    return "";
                }
                ret = this.m_decimalFormat.format(full);
                return ret;
            }
            return this.m_data[(int)row][column];
        }

        public void setRounding(boolean rounding) {
            this.m_rounding = rounding;
        }

        public boolean isRounding() {
            return this.m_rounding;
        }

        public void setRounding(boolean rounding, int decimalPlaces) {
            this.m_rounding = rounding;
            if (this.m_rounding) {
                MinerApp.getWorksheetPropertiesManager().initViewerRoundingObject(this.m_decimalFormat, decimalPlaces);
            }
        }

        public String getRowLabel(long rowNum) {
            return (String)this.m_varNames.get((int)rowNum);
        }

        public int getRowLabelWidth() {
            int maxSize = 0;
            int tmp = 0;
            for (int i = this.m_varNames.size() - 1; i >= 0; --i) {
                tmp = ((String)this.m_varNames.get(i)).length();
                if (tmp <= maxSize) continue;
                maxSize = tmp;
            }
            return maxSize > 5 ? maxSize * 9 : 50;
        }

        public void updateWindowPosition(long neededRowOrigin, int neededNumRows, int neededColOrigin, int neededNumCols) {
        }

        public long getTotalRows() {
            return this.m_rowCount;
        }

        public int getTotalColumns() {
            return this.m_colCount;
        }

        public String getColumnType(int colNum) {
            return (String)this.m_targetNames.get(colNum);
        }

        public String getColumnDisplayType(int colNum) {
            return (String)this.m_targetNames.get(colNum);
        }

        public String getColumnName(int colNum) {
            return (String)this.m_targetNames.get(colNum);
        }

        public int getColumnWidth(int colNum) {
            return 100;
        }
    }
}

