/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.HtmlFrame;
import com.insightful.miner.PredictableNodeModel;
import com.insightful.miner.SetSurvivalRolesPanel;
import com.insightful.miner.SurvivalDialog;
import com.insightful.miner.SurvivalViewer;
import com.insightful.miner.XMLTree;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.awt.Frame;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CoxRegressionNodeModel
extends PredictableNodeModel {
    public void initializeNodeModel() {
        XTProps props = this.getXTProps();
        props.set(new String[]{"copyInputColumns", XTMetaData.INDEPENDENT_ROLE_ATTRIBUTE_TAG}, props.getValue(new String[]{"copyInputColumns", XTMetaData.INDEPENDENT_ROLE_ATTRIBUTE_TAG}, "false"));
        props.set(new String[]{"copyInputColumns", SetSurvivalRolesPanel.ID_ROLE_ATTRIBUTE_TAG}, props.getValue(new String[]{"copyInputColumns", SetSurvivalRolesPanel.ID_ROLE_ATTRIBUTE_TAG}, "false"));
        props.set(new String[]{"copyInputColumns", SetSurvivalRolesPanel.TIME1_ROLE_ATTRIBUTE_TAG}, props.getValue(new String[]{"copyInputColumns", SetSurvivalRolesPanel.TIME1_ROLE_ATTRIBUTE_TAG}, "true"));
        props.set(new String[]{"copyInputColumns", SetSurvivalRolesPanel.TIME2_ROLE_ATTRIBUTE_TAG}, props.getValue(new String[]{"copyInputColumns", SetSurvivalRolesPanel.TIME2_ROLE_ATTRIBUTE_TAG}, "false"));
        props.set(new String[]{"copyInputColumns", XTMetaData.DEPENDENT_ROLE_ATTRIBUTE_TAG}, props.getValue(new String[]{"copyInputColumns", XTMetaData.DEPENDENT_ROLE_ATTRIBUTE_TAG}, "true"));
        props.set(new String[]{"copyInputColumns", "other"}, props.getValue(new String[]{"copyInputColumns", "other"}, "false"));
        props.set(new String[]{"newColumns", "survival"}, props.getValue(new String[]{"newColumns", "survival"}, props.getValue(new String[]{"newColumns", "survivalType"}, "none")));
    }

    public void showPropertiesDialog(boolean modality) {
        SurvivalDialog dialog = SurvivalDialog.getInstance();
        dialog.setModal(modality);
        dialog.show(this, 1);
    }

    public boolean isPropertiesValid() {
        XTProps props = this.getXTProps();
        Vector roleVars = props.getSubProperties("columnRoles");
        boolean ID = false;
        boolean event = false;
        boolean time1 = false;
        boolean time2 = false;
        boolean indep = false;
        for (String varName : roleVars) {
            String specialRole;
            String roleName = props.getValue(new String[]{"columnRoles", varName});
            if (roleName == null) continue;
            if (roleName.equals(XTMetaData.INFORMATION_ROLE_ATTRIBUTE_TAG)) {
                specialRole = props.getValue(new String[]{"columnRoles", "roleSpecials", varName});
                if (!specialRole.equals(SetSurvivalRolesPanel.ID_ROLE_ATTRIBUTE_TAG)) continue;
                ID = true;
                continue;
            }
            if (roleName.equals(XTMetaData.DEPENDENT_ROLE_ATTRIBUTE_TAG)) {
                specialRole = props.getValue(new String[]{"columnRoles", "roleSpecials", varName});
                if (specialRole.equals(SetSurvivalRolesPanel.EVENT_ROLE_ATTRIBUTE_TAG)) {
                    event = true;
                    continue;
                }
                if (specialRole.equals(SetSurvivalRolesPanel.TIME1_ROLE_ATTRIBUTE_TAG)) {
                    time1 = true;
                    continue;
                }
                if (!specialRole.equals(SetSurvivalRolesPanel.TIME2_ROLE_ATTRIBUTE_TAG)) continue;
                time2 = true;
                continue;
            }
            if (!roleName.equals(XTMetaData.INDEPENDENT_ROLE_ATTRIBUTE_TAG)) continue;
            indep = true;
        }
        return time1 && event && indep;
    }

    public void showView(Frame frame) {
        try {
            XMLTree xt = this.getFittedModel();
            if (xt != null) {
                Element ele = xt.getXML();
                NodeList list = ele.getElementsByTagName("BaselineSurvival");
                if (list.getLength() > 0) {
                    SurvivalViewer gui = new SurvivalViewer(xt, this.getDocument().getWorksheetID(), this.getID(), this.getLabelText());
                    gui.show();
                } else {
                    String htmlString = xt.getHtmlString(XMLTree.SURVIVAL_XSL_FILE, this.getLabelText());
                    new HtmlFrame(htmlString);
                }
            } else {
                super.showView(frame);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getModelOutputType() {
        return "survival";
    }

    public String getModelAlgorithm() {
        return "coxRegression";
    }
}

