/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.AcceleratorOptionPane;
import com.insightful.miner.ActivityNodeModel;
import com.insightful.miner.ChartBuilder;
import com.insightful.miner.ChartEngineNode;
import com.insightful.miner.CrosstabulateDialog;
import com.insightful.miner.CrosstabulateEngineNode;
import com.insightful.miner.HtmlFrame;
import com.insightful.miner.MinerApp;
import com.insightful.miner.XMLTree;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTNetwork;
import com.insightful.miner.XTProps;
import java.awt.Frame;
import java.util.Vector;
import org.w3c.dom.Element;

public class CrosstabulateNodeModel
extends ActivityNodeModel {
    private long m_numCounts = 1L;

    public CrosstabulateNodeModel(Element elt) {
        super(elt);
    }

    public CrosstabulateNodeModel(XTNetwork.NodeInfo elt) {
        super(elt);
    }

    public void showPropertiesDialog(boolean modality) {
        CrosstabulateDialog dialog = CrosstabulateDialog.getInstance();
        dialog.setModal(modality);
        dialog.show(this);
    }

    public boolean isPropertiesValid() {
        Vector crosstabs = this.getXTProps().getSubProperties(CrosstabulateEngineNode.CROSSTABULATE_COLUMNS_ATTRIBUTE_TAG);
        try {
            if (this.isInputValid()) {
                XTMetaData md = this.getInputMetaData(0);
                for (int i = crosstabs.size() - 1; i >= 0; --i) {
                    if (md.nameToOrdinal((String)crosstabs.get(i)) != -1) continue;
                    return false;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return crosstabs.size() > 0;
    }

    public void showView(Frame frame) {
        try {
            XTProps dialogProps = this.getXTProps();
            XTMetaData metaData = this.getInputMetaData(0);
            XTProps countProps = null;
            countProps = (XTProps)this.sendMessageToEngine("getNodeCacheXTProps", new Object[]{CrosstabulateEngineNode.COUNTS_DATA_CACHE});
            double lowerBoundPercent = dialogProps.getDouble(CrosstabulateEngineNode.LOWER_BOUND_PERCENT_ATTRIBUTE_TAG, -1.0);
            boolean displayOK = true;
            if (dialogProps.getBoolean(CrosstabulateEngineNode.TABULAR_ATTRIBUTE_TAG, true)) {
                try {
                    this.displayTabularCrosstabs(dialogProps, countProps, metaData, lowerBoundPercent);
                }
                catch (OutOfMemoryError oom) {
                    String msg = MinerApp.getText("CrossTabulateNodeModel_message_notEnoughMemory") + " " + this.m_numCounts + " " + MinerApp.getText("CrossTabulateNodeModel_message_tables");
                    AcceleratorOptionPane.showOKDialog(MinerApp.getMainFrame(), msg, MinerApp.getText("CrossTabulateNodeModel_message_memoryLocation"), 0);
                    displayOK = false;
                }
            }
            if (displayOK && dialogProps.getBoolean(CrosstabulateEngineNode.CHART_ATTRIBUTE_TAG, false)) {
                this.displayBarchartCrosstabs(dialogProps, countProps, metaData, lowerBoundPercent);
            }
            countProps = null;
            System.gc();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean postDialogEqualityCheck(XTProps oldProps, XTProps newProps) {
        oldProps.removeProperty(new String[]{CrosstabulateEngineNode.TABULAR_ATTRIBUTE_TAG});
        oldProps.removeProperty(new String[]{CrosstabulateEngineNode.CHART_ATTRIBUTE_TAG});
        oldProps.removeProperty(new String[]{CrosstabulateEngineNode.LOWER_BOUND_PERCENT_ATTRIBUTE_TAG});
        oldProps.removeProperty(new String[]{CrosstabulateEngineNode.TABLE_CELL_TYPE_ATTRIBUTE_TAG});
        newProps.removeProperty(new String[]{CrosstabulateEngineNode.TABULAR_ATTRIBUTE_TAG});
        newProps.removeProperty(new String[]{CrosstabulateEngineNode.CHART_ATTRIBUTE_TAG});
        newProps.removeProperty(new String[]{CrosstabulateEngineNode.LOWER_BOUND_PERCENT_ATTRIBUTE_TAG});
        newProps.removeProperty(new String[]{CrosstabulateEngineNode.TABLE_CELL_TYPE_ATTRIBUTE_TAG});
        return oldProps.equals(newProps);
    }

    private void displayBarchartCrosstabs(XTProps dialogProps, XTProps chartStats, XTMetaData metaData, double lowerBoundPercent) throws Exception {
        Vector byColumns = dialogProps.getSubProperties(CrosstabulateEngineNode.CROSSTABULATE_COLUMNS_ATTRIBUTE_TAG);
        for (int i = byColumns.size() - 1; i >= 0; --i) {
            if (metaData.isCategoricalColumn((String)byColumns.get(i))) continue;
            byColumns.remove(i);
        }
        Vector<String> displayColumns = new Vector<String>();
        String countColumn = (String)byColumns.get(0);
        byColumns.remove(countColumn);
        displayColumns.add(countColumn);
        ChartBuilder chartBuilder = new ChartBuilder(metaData, chartStats);
        int contChartType = ChartEngineNode.HISTOGRAM_POS;
        int catChartType = ChartEngineNode.BARCHART_POS;
        int numBins = 0;
        boolean showPercents = dialogProps.getBoolean(ChartEngineNode.SHOW_PERCENTS_TAG, false);
        chartBuilder.setCategoryLowerBoundPercentage(lowerBoundPercent);
        int result = chartBuilder.setDisplayInfo(contChartType, catChartType, displayColumns, byColumns, numBins, false, showPercents, true);
        if (result != -1) {
            try {
                chartBuilder.displayCharts(this.getLabelText());
            }
            catch (OutOfMemoryError oom) {
                chartBuilder.clearMemory();
                chartBuilder = null;
            }
        }
    }

    private void displayTabularCrosstabs(XTProps dialogProps, XTProps countProps, XTMetaData metaData, double lowerBoundPercent) throws Exception, OutOfMemoryError {
        int[] crosstabIndex = null;
        int[] crosstabNumLevels = null;
        int[] counts = null;
        StringBuffer output = null;
        StringBuffer htmlString = null;
        StringBuffer linkage = null;
        Object levelsAlphaMapping = null;
        Vector[] crosstabLevels = null;
        Vector crosstabColumns = null;
        String[] propsPath = null;
        boolean[] hasNaN = null;
        try {
            String type = dialogProps.getValue(CrosstabulateEngineNode.TABLE_CELL_TYPE_ATTRIBUTE_TAG, CrosstabulateEngineNode.ABSOLUTE_COUNT_ATTRIBUTE_TAG);
            int tableType = 0;
            String tableTypeString = MinerApp.getText("CrosstabulateDialog_useAbsolute");
            if (type.equals(CrosstabulateEngineNode.ROW_PERCENT_ATTRIBUTE_TAG)) {
                tableType = 1;
                tableTypeString = MinerApp.getText("CrosstabulateDialog_useRowPercent");
            } else if (type.equals(CrosstabulateEngineNode.COLUMN_PERCENT_ATTRIBUTE_TAG)) {
                tableType = 2;
                tableTypeString = MinerApp.getText("CrosstabulateDialog_useColumnPercent");
            } else if (type.equals(CrosstabulateEngineNode.TOTAL_PERCENT_ATTRIBUTE_TAG)) {
                tableType = 3;
                tableTypeString = MinerApp.getText("CrosstabulateDialog_useTotalPercent");
            }
            crosstabColumns = dialogProps.getSubProperties(CrosstabulateEngineNode.CROSSTABULATE_COLUMNS_ATTRIBUTE_TAG);
            for (int i = crosstabColumns.size() - 1; i >= 0; --i) {
                if (metaData.isCategoricalColumn((String)crosstabColumns.get(i))) continue;
                crosstabColumns.remove(i);
            }
            String first = (String)crosstabColumns.get(0);
            crosstabColumns.remove(first);
            crosstabColumns.add(first);
            int numCrosstabColumns = crosstabColumns.size();
            crosstabLevels = new Vector[numCrosstabColumns];
            levelsAlphaMapping = new int[numCrosstabColumns][];
            crosstabIndex = new int[numCrosstabColumns];
            crosstabNumLevels = new int[numCrosstabColumns];
            hasNaN = new boolean[numCrosstabColumns];
            this.m_numCounts = 1L;
            int numCrosstabsPerTable = 1;
            int linkNum = 0;
            for (int i = 0; i < numCrosstabColumns; ++i) {
                String column = (String)crosstabColumns.get(i);
                crosstabLevels[i] = this.getSortedLevels(metaData, column, lowerBoundPercent);
                if (metaData.getColumnMissingCount(column) > 0.0) {
                    crosstabLevels[i].add("NaN");
                    hasNaN[i] = true;
                } else {
                    hasNaN[i] = false;
                }
                crosstabNumLevels[i] = crosstabLevels[i].size();
                this.m_numCounts *= (long)crosstabNumLevels[i];
                crosstabIndex[i] = 0;
                if (i >= numCrosstabColumns - 2) {
                    numCrosstabsPerTable *= crosstabNumLevels[i];
                }
                Vector indices = this.getSortedIndices(metaData, column, lowerBoundPercent);
                levelsAlphaMapping[i] = new int[crosstabNumLevels[i]];
                for (int level = 0; level < crosstabNumLevels[i]; ++level) {
                    int mapping;
                    levelsAlphaMapping[i][level] = hasNaN[i] && level == crosstabNumLevels[i] - 1 ? level : (mapping = ((Integer)indices.get(level)).intValue());
                }
            }
            propsPath = new String[numCrosstabColumns * 2 + 3];
            htmlString = new StringBuffer();
            linkage = new StringBuffer();
            counts = new int[numCrosstabsPerTable];
            boolean createLink = false;
            int relocateCol = numCrosstabColumns - 1;
            propsPath[0] = (String)crosstabColumns.get(relocateCol);
            propsPath[numCrosstabColumns * 2 - 1] = ChartEngineNode.STATS_ATTRIBUTE_TAG;
            propsPath[numCrosstabColumns * 2] = ChartEngineNode.BINS_ATTRIBUTE_TAG;
            propsPath[numCrosstabColumns * 2 + 2] = ChartEngineNode.COUNT_ATTRIBUTE_TAG;
            int i = 0;
            while ((long)i < this.m_numCounts) {
                int j;
                for (j = 0; j < relocateCol; ++j) {
                    propsPath[2 * j + 1] = (String)crosstabColumns.get(j);
                    propsPath[2 * j + 2] = (String)crosstabLevels[j].get(crosstabIndex[j]);
                }
                if (hasNaN[relocateCol] && crosstabIndex[relocateCol] == crosstabNumLevels[relocateCol] - 1) {
                    propsPath[numCrosstabColumns * 2 + 1] = (String)crosstabLevels[relocateCol].get(crosstabIndex[relocateCol]);
                } else {
                    int mapping = levelsAlphaMapping[relocateCol][crosstabIndex[relocateCol]];
                    propsPath[numCrosstabColumns * 2 + 1] = Integer.toString(mapping);
                }
                counts[i % numCrosstabsPerTable] = (int)countProps.getDouble(propsPath, 0.0);
                if (counts[i % numCrosstabsPerTable] > 0) {
                    createLink = true;
                }
                for (j = numCrosstabColumns - 1; j >= 0; --j) {
                    int n = j;
                    crosstabIndex[n] = crosstabIndex[n] + 1;
                    if (crosstabIndex[j] != crosstabNumLevels[j]) break;
                    crosstabIndex[j] = 0;
                }
                if ((i + 1) % numCrosstabsPerTable == 0) {
                    String caption = "";
                    if (numCrosstabColumns > 2) {
                        caption = (String)crosstabColumns.get(0) + "=" + propsPath[2];
                        if (numCrosstabColumns > 3) {
                            caption = caption + ", ";
                        }
                    }
                    for (int j2 = 1; j2 < numCrosstabColumns - 2; ++j2) {
                        String tempCaption = (String)crosstabColumns.get(j2) + "=" + propsPath[2 * j2 + 2];
                        if (j2 < numCrosstabColumns - 3) {
                            tempCaption = tempCaption + ", ";
                        }
                        caption = caption + tempCaption;
                    }
                    String html = "";
                    html = numCrosstabColumns > 1 ? this.createHTMLTable(caption, (String)crosstabColumns.get(numCrosstabColumns - 1), crosstabLevels[crosstabLevels.length - 1], (String)crosstabColumns.get(numCrosstabColumns - 2), crosstabLevels[crosstabLevels.length - 2], counts, tableType, linkNum) : this.createHTMLTable(caption, (String)crosstabColumns.get(numCrosstabColumns - 1), crosstabLevels[crosstabLevels.length - 1], "", new Vector(), counts, tableType, linkNum);
                    htmlString.append(html);
                    if (createLink && numCrosstabColumns > 2) {
                        linkage.append("<LI><A HREF=\"#");
                        linkage.append(linkNum);
                        linkage.append("\">");
                        linkage.append(caption);
                        linkage.append("</A></LI>\n");
                    }
                    ++linkNum;
                    createLink = false;
                }
                ++i;
            }
            linkage.append("</UL>\n");
            String title = this.getLabelText();
            output = new StringBuffer();
            output.append("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n");
            output.append("<HTML>\n<TITLE>" + title + " Summary</TITLE>");
            output.append("<style type=\"text/css\">" + XMLTree.getCSSText() + "</style>");
            output.append("<P><H1 class=\"title\">" + title + " Summary - " + tableTypeString + "</H1>\n</P><BR>");
            output.append(linkage.toString());
            output.append(htmlString.toString());
            output.append("</HTML>\n");
            new HtmlFrame(output.toString());
        }
        catch (OutOfMemoryError oom) {
            counts = null;
            crosstabNumLevels = null;
            crosstabIndex = null;
            output = null;
            htmlString = null;
            linkage = null;
            crosstabColumns = null;
            crosstabLevels = null;
            propsPath = null;
            hasNaN = null;
            System.gc();
            throw oom;
        }
    }

    private String createHTMLTable(String caption, String horizontalColumn, Vector horizontalLevels, String verticalColumn, Vector verticalLevels, int[] counts, int tableType, int linkNum) {
        int i;
        int extraCols;
        int rows;
        StringBuffer buffer = new StringBuffer();
        buffer.append("<BR><BR>\n");
        buffer.append("<A NAME=\"");
        buffer.append(linkNum);
        buffer.append("\">");
        buffer.append("\t<table width=\"85%\" align=\"center\" border=\"0\" cellspacing=\"0\" cellpadding=\"3\">");
        buffer.append("\t\t<tr>");
        buffer.append("\t\t\t<td class=\"tableBG\">");
        if (!caption.equals("")) {
            buffer.append("\t\t\t\t\t<p><b><font size=\"4\" class=\"tableHead\">" + caption + "</font></b></p>");
        }
        buffer.append("\t\t\t\t\t\t<table width=\"100%\" border=\"0\" class=\"content\" cellspacing=\"1\">");
        buffer.append("\t\t\t\t\t\t\t<tbody>");
        if (verticalLevels.size() == 0) {
            rows = 1;
            extraCols = 0;
        } else {
            rows = verticalLevels.size();
            extraCols = 2;
        }
        long[] previewRowTotals = new long[rows];
        long[] previewColTotals = new long[horizontalLevels.size()];
        long previewTotal = 0L;
        String[] classStr = new String[]{"blueBG", "whiteBG", "greyBG"};
        int countIndex = 0;
        for (i = 0; i < rows + 2; ++i) {
            for (int j = 0; j < previewColTotals.length + extraCols; ++j) {
                if (i <= 1 || j < extraCols) continue;
                int n = i - 2;
                previewRowTotals[n] = previewRowTotals[n] + (long)counts[countIndex];
                if (previewColTotals.length > 0) {
                    int n2 = j - extraCols;
                    previewColTotals[n2] = previewColTotals[n2] + (long)counts[countIndex];
                }
                previewTotal += (long)counts[countIndex];
                ++countIndex;
            }
        }
        countIndex = 0;
        for (i = 0; i < rows + 2; ++i) {
            buffer.append("\t\t<TR>\n");
            String str = classStr[i % 2 == 0 ? 1 : 2];
            for (int j = 0; j < previewColTotals.length + extraCols; ++j) {
                if (i < 2 && j < extraCols) {
                    buffer.append("\t\t\t<TD></TD>\n");
                } else {
                    if (i == 0 && j == extraCols) {
                        buffer.append("\t\t\t<TD class=\"" + classStr[0] + "\" COLSPAN=");
                        buffer.append(previewColTotals.length);
                        buffer.append("><CENTER><B><FONT SIZE=4>");
                        buffer.append(horizontalColumn);
                        buffer.append("</FONT></B></CENTER></TD>\n");
                        buffer.append("\t\t\t<TD class=\"" + classStr[0] + "\" ROWSPAN=2><CENTER><B><FONT SIZE=3>");
                        buffer.append("Totals</FONT></B></CENTER></TD>\n");
                        break;
                    }
                    if (i == 1 && j >= extraCols) {
                        buffer.append("\t\t\t<TD class=\"" + classStr[0] + "\"><CENTER><I><FONT SIZE=3>");
                        buffer.append((String)horizontalLevels.get(j - extraCols));
                        buffer.append("</FONT></I></CENTER></TD>\n");
                    } else if (i == 2 && j == 0 && extraCols == 2) {
                        buffer.append("\t\t\t<TD class=\"" + classStr[0] + "\" ROWSPAN=");
                        buffer.append(verticalLevels.size());
                        buffer.append("><CENTER><B><FONT SIZE=4>");
                        buffer.append(verticalColumn);
                        buffer.append("</FONT></B></CENTER></TD>\n");
                    } else if (i > 1 && j == 1 && extraCols == 2) {
                        buffer.append("\t\t\t<TD class=\"" + classStr[0] + "\"><CENTER><I><FONT SIZE=3>");
                        buffer.append((String)verticalLevels.get(i - 2));
                        buffer.append("</FONT></I></CENTER></TD>\n");
                    } else if (i > 1 && j >= extraCols) {
                        buffer.append("\t\t\t<TD align=\"right\" class=\"" + str + "\">");
                        double percent = 100.0;
                        switch (tableType) {
                            case 1: {
                                if (Double.isNaN(percent *= (double)counts[countIndex++] / (double)previewRowTotals[i - 2])) {
                                    percent = 0.0;
                                }
                                buffer.append(MinerApp.formatDouble(percent));
                                break;
                            }
                            case 2: {
                                if (Double.isNaN(percent *= (double)counts[countIndex++] / (double)previewColTotals[j - extraCols])) {
                                    percent = 0.0;
                                }
                                buffer.append(MinerApp.formatDouble(percent));
                                break;
                            }
                            case 3: {
                                if (Double.isNaN(percent *= (double)counts[countIndex++] / (double)previewTotal)) {
                                    percent = 0.0;
                                }
                                buffer.append(MinerApp.formatDouble(percent));
                                break;
                            }
                            default: {
                                buffer.append(counts[countIndex++]);
                            }
                        }
                        buffer.append("</TD>\n");
                        if (j == previewColTotals.length + extraCols - 1) {
                            buffer.append("\t\t\t<TD align=\"right\" class=\"" + str + "\">");
                            buffer.append(previewRowTotals[i - 2]);
                            buffer.append("</TD>\n");
                        }
                    }
                }
                if (verticalLevels.size() == 0 || i != rows + 1 || j != previewColTotals.length + extraCols - 1) continue;
                String str2 = classStr[i % 2 == 0 ? 2 : 1];
                buffer.append("\t\t</TR>\n");
                buffer.append("\t\t<TR>\n");
                buffer.append("\t\t\t<TD class=\"" + classStr[0] + "\" COLSPAN=2><CENTER><B><FONT SIZE=3>");
                buffer.append("Totals");
                buffer.append("</FONT></B></CENTER></TD>\n");
                for (int k = 0; k < previewColTotals.length; ++k) {
                    buffer.append("\t\t\t<TD align=\"right\" class=\"" + str2 + "\">");
                    buffer.append(previewColTotals[k]);
                    buffer.append("</TD>\n");
                }
                buffer.append("\t\t\t<TD align=\"right\" class=\"" + str2 + "\">");
                buffer.append(previewTotal);
                buffer.append("</TD>\n");
            }
            buffer.append("\t\t</TR>\n");
        }
        buffer.append("\t\t\t\t\t\t\t</tbody>");
        buffer.append("\t\t\t\t\t\t</table>");
        buffer.append("\t\t\t</td>");
        buffer.append("\t\t</tr>");
        buffer.append("\t</table>");
        buffer.append("</A>\n");
        return buffer.toString();
    }

    private Vector getUnsortedLevels(XTMetaData metaData, String column, double lowerBoundPercent) {
        Vector ret = metaData.getCategoricalDataFieldLevels(column);
        double numRows = metaData.getNumRows();
        int rem = 0;
        for (int i = 0; i < ret.size(); ++i) {
            String level = (String)ret.get(i - rem);
            double num = Long.parseLong(metaData.getLevelCount(column, level));
            double reprPercent = num / numRows * 100.0;
            if (!(reprPercent < lowerBoundPercent)) continue;
            ret.remove(i - rem);
            ++rem;
        }
        return ret;
    }

    private Vector getSortedLevels(XTMetaData metaData, String column, double lowerBoundPercent) {
        Vector ret = metaData.getSortedCategoricalDataFieldLevels(column);
        double numRows = metaData.getNumRows();
        int rem = 0;
        for (int i = 0; i < ret.size(); ++i) {
            String level = (String)ret.get(i - rem);
            double num = Long.parseLong(metaData.getLevelCount(column, level));
            double reprPercent = num / numRows * 100.0;
            if (!(reprPercent < lowerBoundPercent)) continue;
            ret.remove(i - rem);
            ++rem;
        }
        return ret;
    }

    private Vector getSortedIndices(XTMetaData metaData, String column, double lowerBoundPercent) {
        Vector ret = metaData.getSortedCategoricalDataFieldLevelIndices(column);
        int columnNum = metaData.nameToOrdinal(column);
        double numRows = metaData.getNumRows();
        int rem = 0;
        for (int i = 0; i < ret.size(); ++i) {
            int index = (Integer)ret.get(i - rem);
            String level = metaData.getCategoricalDataFieldLevel(columnNum, index);
            double num = Long.parseLong(metaData.getLevelCount(column, level));
            double reprPercent = num / numRows * 100.0;
            if (!(reprPercent < lowerBoundPercent)) continue;
            ret.remove(i - rem);
            ++rem;
        }
        return ret;
    }
}

