/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.cnkjava.CNKProcCoxRegPredict;
import com.insightful.cnkjava.CNKProcGLMFit;
import com.insightful.cnkjava.CNKProcJavaTransform;
import com.insightful.cnkjava.CNKProcKMeansPredict;
import com.insightful.cnkjava.CNKProcNNetPredict;
import com.insightful.cnkjava.CNKProcPredict;
import com.insightful.cnkjava.CNKProcPrinCompPredict;
import com.insightful.miner.EngineNode;
import com.insightful.miner.MinerApp;
import com.insightful.miner.PredictNodeModel;
import com.insightful.miner.XMLTree;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import com.insightful.miner.tree.model.NaiveBayesPredictor;
import com.insightful.miner.tree.model.TreeCollection;
import com.insightful.miner.tree.model.TreePredictor;
import com.insightful.splus.SplusWinSessionImpl;
import java.io.File;
import java.io.FileOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class GenerateCEngineNode
extends EngineNode {
    public boolean hasDataCacheProc() {
        return true;
    }

    public boolean hasCNKProc() {
        return false;
    }

    public boolean executeDataCacheProc() throws Exception {
        XMLTree fittedModel;
        boolean licenseOK = false;
        String licenseError = "Error getting C Code Generation (02C) license:\n";
        try {
            Method mt = SplusWinSessionImpl.class.getMethod("checkoutLicenseFeature", String.class);
            Object licenseVal = mt.invoke(null, "02C");
            String licenseString = (String)licenseVal;
            if (licenseString == null || licenseString.length() > 0) {
                licenseError = licenseError + (licenseString == null ? "license error" : licenseString);
            } else {
                licenseOK = true;
            }
        }
        catch (InvocationTargetException ex) {
            licenseError = licenseError + ex.getCause().toString();
            throw new Exception(licenseError, ex);
        }
        catch (Throwable ex) {
            licenseError = licenseError + ex.toString();
            throw new Exception(licenseError, ex);
        }
        if (!licenseOK) {
            throw new Exception(licenseError);
        }
        XTProps props = this.getNodeProperties();
        String distDir = this.getNetworkManager().getAbsolutePath(props.getValue("filePath"));
        File distDirFile = new File(distDir);
        if (!distDirFile.exists()) {
            distDirFile.mkdirs();
        }
        if ((fittedModel = this.getModel()) == null) {
            throw new RuntimeException("No model found.  Check for previous errors.");
        }
        String modelType = PredictNodeModel.getModelAlgorithm(fittedModel);
        XMLTree pmmlModel = XMLTree.readFromString(fittedModel.getHtmlString(XMLTree.IMML_TO_PMML_XSL_FILE));
        FileOutputStream os = new FileOutputStream(distDir + "/" + "InputDefinition.html");
        os.write(pmmlModel.getHtmlString(XMLTree.PMML_DATA_DICTIONARY_XSL_FILE).getBytes());
        os.close();
        CNKProcPredict proc = null;
        if (modelType.equals("cluster")) {
            proc = new CNKProcKMeansPredict();
        } else if (modelType.equals("glm")) {
            proc = new CNKProcGLMFit();
        } else if (modelType.equals("NNet")) {
            proc = new CNKProcNNetPredict();
        } else if (modelType.equals("principleComponent")) {
            proc = new CNKProcPrinCompPredict();
        } else if (modelType.equals("coxRegression")) {
            proc = new CNKProcCoxRegPredict();
        } else {
            CNKProcJavaTransform jProc = null;
            if (modelType.equals("tree")) {
                jProc = new CNKProcJavaTransform();
                TreeCollection treeCollection = new TreeCollection(fittedModel, null, Integer.parseInt(this.getNodeID()), this.getNetworkManager().getWorksheetID());
                TreePredictor treePredictor = new TreePredictor(treeCollection);
                treePredictor.setGenerateCCode(distDir);
                jProc.setExecObject(treePredictor);
            } else if (modelType.equals("naiveBayes")) {
                jProc = new CNKProcJavaTransform();
                XTMetaData modelMD = PredictNodeModel.getFittedModelMetaData(fittedModel);
                NaiveBayesPredictor nbPredictor = new NaiveBayesPredictor(new XTProps(fittedModel), modelMD, this);
                nbPredictor.setGenerateCCode(distDir);
                jProc.setExecObject(nbPredictor);
            } else {
                throw new RuntimeException("Unrecognized Model type.");
            }
            jProc.init();
            return this.getNetworkManager().executeCNKProc(this.getNodeID(), jProc);
        }
        String codeSourceDir = MinerApp.getSprimeHome() + "/imcsrc";
        if (!new File(codeSourceDir).isDirectory()) {
            throw new Exception("C code source directory " + codeSourceDir + " not found");
        }
        proc.setCGenerationLocations(distDir, codeSourceDir);
        proc.setModel(fittedModel.writeToString());
        proc.init();
        boolean ok = this.getNetworkManager().executeCNKProc(this.getNodeID(), proc);
        return ok;
    }
}

